/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.math;

import tazadum.engine.math.Vector3f;

public class Box {
    private Vector3f a;
    private Vector3f b;

    public Box() {
        this.a = null;
        this.b = null;
    }

    public Box(Vector3f vector3f, Vector3f vector3f2) {
        this.a = vector3f;
        this.b = new Vector3f(vector3f);
        this.extend(vector3f2);
    }

    public Vector3f getFrom() {
        return this.a;
    }

    public Vector3f center() {
        return this.a.add(this.b).multLocal(0.5f);
    }

    public final void extend(Vector3f vector3f) {
        if (this.a == null) {
            this.a = new Vector3f(vector3f);
            this.b = new Vector3f(vector3f);
        }
        this.a.x = Math.min(this.a.x, vector3f.x);
        this.a.y = Math.min(this.a.y, vector3f.y);
        this.a.z = Math.min(this.a.z, vector3f.z);
        this.b.x = Math.max(this.b.x, vector3f.x);
        this.b.y = Math.max(this.b.y, vector3f.y);
        this.b.z = Math.max(this.b.z, vector3f.z);
    }

    public boolean contains(Vector3f vector3f) {
        return this.a.x <= vector3f.x && vector3f.x <= this.b.x && this.a.y <= vector3f.y && vector3f.y <= this.b.y && this.a.y <= vector3f.y && vector3f.y <= this.b.y;
    }

    public float getWidth() {
        return this.b.x - this.a.x;
    }

    public float getHeight() {
        return this.b.y - this.a.y;
    }

    public float getDepth() {
        return this.b.z - this.a.z;
    }

    public String toString() {
        return String.format("{%f->%f, %f->%f, %f->%f}", Float.valueOf(this.a.x), Float.valueOf(this.b.x), Float.valueOf(this.a.y), Float.valueOf(this.b.y), Float.valueOf(this.a.z), Float.valueOf(this.b.z));
    }
}

