/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.configuration;

import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.inject.Inject;
import tazadum.engine.configuration.Layer;
import tazadum.engine.configuration.LayerType;
import tazadum.engine.configuration.TimelineLayer;
import tazadum.engine.configuration.TimelineManager;
import tazadum.engine.configuration.TimelineScene;
import tazadum.engine.configuration.model.JsonScene;
import tazadum.engine.configuration.model.JsonTimeline;
import tazadum.engine.math.Interval;
import tazadum.engine.rendering.scenegraph.Scene;
import tazadum.engine.resource.ResourceManager;
import tazadum.engine.ui.event.ReloadActionEvent;
import tazadum.engine.ui.event.SaveActionEvent;
import tazadum.engine.util.event.EventBus;

public class TimelineManagerImpl
implements TimelineManager {
    private final ResourceManager resourceManager;
    private Interval interval = new Interval(0.0f, 60.0f);
    private final Map<Integer, TimelineLayer<TimelineScene>> layers = new TreeMap<Integer, TimelineLayer<TimelineScene>>();
    private final List<TimelineScene> currentEntries = new ArrayList<TimelineScene>(10);
    private String sceneDescriptor;
    private static final Comparator<TimelineScene> LAYER_COMPARATOR = new Comparator<TimelineScene>(){

        @Override
        public int compare(TimelineScene timelineScene, TimelineScene timelineScene2) {
            return timelineScene2.getLayer() - timelineScene.getLayer();
        }
    };

    @Inject
    public TimelineManagerImpl(EventBus eventBus, ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        eventBus.addHandler(SaveActionEvent.TYPE, new SaveActionEvent.Handler(){

            @Override
            public void onSave(SaveActionEvent saveActionEvent) {
                TimelineManagerImpl.this.save();
            }
        });
        eventBus.addHandler(ReloadActionEvent.TYPE, new ReloadActionEvent.Handler(){

            @Override
            public void onReload(ReloadActionEvent reloadActionEvent) {
                TimelineManagerImpl.this.reload();
            }
        });
    }

    public void reload() {
    }

    @Override
    public int getSceneLayers() {
        return this.layers.size();
    }

    @Override
    public int getSyncLayers() {
        return 0;
    }

    @Override
    public synchronized void load(Injector injector, String string, float f) {
        this.sceneDescriptor = string;
        this.interval = new Interval(0.0f, f);
        JsonTimeline jsonTimeline = this.resourceManager.load(string, JsonTimeline.class);
        for (Map.Entry<Integer, List<JsonScene>> entry : jsonTimeline.getScenes().entrySet()) {
            int n = entry.getKey();
            TimelineLayer timelineLayer = new TimelineLayer(LayerType.SceneLayer);
            for (JsonScene jsonScene : entry.getValue()) {
                try {
                    Object object;
                    Class<?> clazz = Class.forName(jsonScene.getClassName());
                    if (!Scene.class.isAssignableFrom(clazz)) {
                        object = String.format("%s is not an implementation of %s", jsonScene.getClassName(), Scene.class.getName());
                        throw new IllegalArgumentException((String)object);
                    }
                    object = (Scene)injector.getInstance(clazz);
                    float[] fArray = jsonScene.getInterval();
                    if (fArray == null) {
                        fArray = new float[]{0.0f, 10.0f};
                    }
                    if (fArray.length != 2) {
                        throw new IllegalAccessException("Interval for " + jsonScene.getClassName() + " is invalid");
                    }
                    TimelineScene timelineScene = new TimelineScene((Scene)object, new Interval(fArray[0], fArray[1]), n);
                    timelineLayer.getEntries().add(timelineScene);
                    this.interval.union(timelineScene.getInterval());
                }
                catch (ClassNotFoundException | IllegalAccessException reflectiveOperationException) {
                    throw new RuntimeException(reflectiveOperationException);
                }
            }
            this.layers.put(n, timelineLayer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() {
        if (this.sceneDescriptor == null) {
            return;
        }
        TimelineManagerImpl timelineManagerImpl = this;
        synchronized (timelineManagerImpl) {
            JsonTimeline jsonTimeline = new JsonTimeline();
            Map<Integer, List<JsonScene>> map = jsonTimeline.getScenes();
            for (Map.Entry<Integer, TimelineLayer<TimelineScene>> entry : this.layers.entrySet()) {
                int n = entry.getKey();
                if (!map.containsKey(n)) {
                    map.put(n, new ArrayList());
                }
                TimelineLayer<TimelineScene> timelineLayer = entry.getValue();
                for (TimelineScene timelineScene : timelineLayer.getEntries()) {
                    JsonScene jsonScene = new JsonScene();
                    jsonScene.setClassName(timelineScene.getScene().getClass().getName());
                    jsonScene.setInterval(new float[]{timelineScene.getInterval().from(), timelineScene.getInterval().to()});
                    map.get(n).add(jsonScene);
                }
            }
            this.resourceManager.save(this.sceneDescriptor, jsonTimeline);
        }
    }

    @Override
    public Interval getInterval() {
        return this.interval;
    }

    @Override
    public synchronized boolean move(Object object, Layer layer, Layer layer2) {
        TimelineLayer<TimelineScene> timelineLayer = this.layers.get(layer.getIndex());
        TimelineLayer<TimelineScene> timelineLayer2 = this.layers.get(layer2.getIndex());
        if (timelineLayer == null || timelineLayer2 == null) {
            return false;
        }
        TimelineScene timelineScene = null;
        for (TimelineScene timelineScene2 : timelineLayer.getEntries()) {
            if (!object.equals(timelineScene2)) continue;
            timelineScene = timelineScene2;
            break;
        }
        if (timelineScene != null) {
            timelineLayer.getEntries().remove(timelineScene);
            timelineLayer2.getEntries().add(timelineScene);
            timelineScene.setLayer(layer2.getIndex());
            return true;
        }
        return false;
    }

    @Override
    public synchronized List<TimelineScene> getScenes() {
        ArrayList<TimelineScene> arrayList = new ArrayList<TimelineScene>();
        for (Map.Entry<Integer, TimelineLayer<TimelineScene>> entry : this.layers.entrySet()) {
            arrayList.addAll(entry.getValue().getEntries());
        }
        return arrayList;
    }

    @Override
    public synchronized List<TimelineScene> getScenes(float f) {
        this.currentEntries.clear();
        for (Map.Entry<Integer, TimelineLayer<TimelineScene>> entry : this.layers.entrySet()) {
            for (TimelineScene timelineScene : entry.getValue().getEntries()) {
                if (!timelineScene.getInterval().contains(f)) continue;
                this.currentEntries.add(timelineScene);
            }
        }
        Collections.sort(this.currentEntries, LAYER_COMPARATOR);
        return this.currentEntries;
    }

    @Override
    public synchronized List<TimelineScene> getScenes(Layer layer, Interval interval) {
        ArrayList<TimelineScene> arrayList = new ArrayList<TimelineScene>();
        if (layer.getType() != LayerType.SceneLayer) {
            return arrayList;
        }
        TimelineLayer<TimelineScene> timelineLayer = this.layers.get(layer.getIndex());
        if (timelineLayer == null) {
            return arrayList;
        }
        for (TimelineScene timelineScene : timelineLayer.getEntries()) {
            if (!interval.intersects(timelineScene.getInterval())) continue;
            arrayList.add(timelineScene);
        }
        return arrayList;
    }
}

