/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import tazadum.engine.configuration.ParameterManager;
import tazadum.engine.configuration.model.JsonParameter;
import tazadum.engine.parameter.Parameter;
import tazadum.engine.resource.JsonSerializer;
import tazadum.engine.resource.ResourceManager;
import tazadum.engine.ui.ParameterGroup;
import tazadum.engine.ui.event.ReloadActionEvent;
import tazadum.engine.ui.event.SaveActionEvent;
import tazadum.engine.util.Pair;
import tazadum.engine.util.event.EventBus;

public class ParameterManagerImpl
implements ParameterManager {
    private final ResourceManager resourceManager;
    private final JsonSerializer jsonSerializer;
    private final ConcurrentMap<Object, ParameterGroup> groups = new ConcurrentHashMap<Object, ParameterGroup>();
    private final Map<String, Parameter<?>> parameters = new ConcurrentHashMap();
    private String directory = null;
    private String pattern;

    @Inject
    public ParameterManagerImpl(EventBus eventBus, ResourceManager resourceManager, JsonSerializer jsonSerializer) {
        this.resourceManager = resourceManager;
        this.jsonSerializer = jsonSerializer;
        eventBus.addHandler(SaveActionEvent.TYPE, new SaveActionEvent.Handler(){

            @Override
            public void onSave(SaveActionEvent saveActionEvent) {
                ParameterManagerImpl.this.saveAll();
            }
        });
        eventBus.addHandler(ReloadActionEvent.TYPE, new ReloadActionEvent.Handler(){

            @Override
            public void onReload(ReloadActionEvent reloadActionEvent) {
            }
        });
    }

    @Override
    public void load(String string) {
        this.pattern = string;
        this.directory = string.substring(0, string.lastIndexOf(47));
    }

    @Override
    public <T> void save(String string, Parameter<T> parameter) {
        if (this.directory == null) {
            throw new IllegalStateException("No parameters where loaded so no directory set.");
        }
        JsonParameter jsonParameter = new JsonParameter();
        jsonParameter.setName(string);
        jsonParameter.setClassname(parameter.getClass().getName());
        jsonParameter.setData(this.jsonSerializer.serialize(parameter));
        this.resourceManager.save(this.directory + File.separatorChar + string + ".json", jsonParameter);
    }

    @Override
    public void reload() {
        this.parameters.clear();
        this.load(this.pattern);
    }

    @Override
    public void saveAll() {
        for (Map.Entry<String, Parameter<?>> entry : this.parameters.entrySet()) {
            this.save(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public <T extends Parameter<?>> T getParameter(Object object, String string, Class<T> clazz) {
        ParameterGroup parameterGroup = new ParameterGroup();
        ParameterGroup parameterGroup2 = this.groups.putIfAbsent(object, parameterGroup);
        if (parameterGroup2 == null) {
            parameterGroup2 = parameterGroup;
        }
        if (this.parameters.containsKey(string)) {
            Parameter<?> parameter = this.parameters.get(string);
            if (parameterGroup2.get(string) == null) {
                parameterGroup2.add(string, parameter);
            }
            return (T)parameter;
        }
        JsonParameter jsonParameter = this.resourceManager.load(this.directory + "/" + string + ".json", JsonParameter.class);
        try {
            Class<?> clazz2 = Class.forName(jsonParameter.getClassname());
            if (!Parameter.class.isAssignableFrom(clazz2)) {
                throw new IllegalArgumentException(jsonParameter.getClassname() + " is not implementing " + Parameter.class);
            }
            Parameter parameter = (Parameter)this.jsonSerializer.deserialize(jsonParameter.getData(), clazz2);
            parameter.initialize();
            this.parameters.put(jsonParameter.getName(), parameter);
            return (T)parameter;
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                Parameter parameter = (Parameter)clazz.newInstance();
                parameter.initialize();
                this.save(string, parameter);
                if (parameterGroup2.get(string) == null) {
                    parameterGroup2.add(string, parameter);
                }
                return (T)parameter;
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                throw new RuntimeException(reflectiveOperationException);
            }
        }
    }

    @Override
    public ParameterGroup getParameters(Object object) {
        return (ParameterGroup)this.groups.get(object);
    }

    @Override
    public Collection<Pair<String, Parameter>> getAll() {
        ArrayList<Pair<String, Parameter>> arrayList = new ArrayList<Pair<String, Parameter>>(this.parameters.size());
        for (Map.Entry<String, Parameter<?>> entry : this.parameters.entrySet()) {
            arrayList.add(Pair.create(entry.getKey(), entry.getValue()));
        }
        return arrayList;
    }
}

