/*
 * Decompiled with CFR 0.152.
 */
package tazadum.engine.asset;

import com.jogamp.opengl.util.texture.Texture;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import tazadum.engine.asset.Asset;
import tazadum.engine.asset.AssetManager;
import tazadum.engine.asset.ByteAsset;
import tazadum.engine.asset.FontAsset;
import tazadum.engine.asset.MeshAsset;
import tazadum.engine.asset.TextureAsset;
import tazadum.engine.rendering.font.Font;
import tazadum.engine.rendering.mesh.Mesh;
import tazadum.engine.resource.Loadable;
import tazadum.engine.resource.ResourceManager;

public class AssetManagerImpl
implements AssetManager {
    private final ResourceManager resourceManager;
    private final Map<String, TextureAsset> textures = new ConcurrentHashMap<String, TextureAsset>();
    private final Map<String, FontAsset> fonts = new ConcurrentHashMap<String, FontAsset>();
    private final Map<String, MeshAsset> meshes = new ConcurrentHashMap<String, MeshAsset>();
    private final Map<String, ByteAsset> raws = new ConcurrentHashMap<String, ByteAsset>();

    @Inject
    public AssetManagerImpl(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    @Override
    public void load() {
        this.load(this.textures.values());
        this.load(this.fonts.values());
        this.load(this.meshes.values());
        this.load(this.raws.values());
    }

    private <T extends Loadable> void load(Collection<T> collection) {
        for (Loadable loadable : collection) {
            try {
                loadable.load(this.resourceManager);
            }
            catch (Exception exception) {
                throw new RuntimeException("Missing asset " + loadable, exception);
            }
        }
    }

    @Override
    public Asset<Texture> loadTexture(String string) {
        if (!this.textures.containsKey(string)) {
            this.textures.put(string, new TextureAsset(string));
        }
        return this.textures.get(string);
    }

    @Override
    public Asset<Font> loadFont(String string, String string2) {
        Asset<Texture> asset = this.loadTexture(string2);
        if (!this.fonts.containsKey(string)) {
            this.fonts.put(string, new FontAsset(string, asset));
        }
        return this.fonts.get(string);
    }

    @Override
    public Asset<Mesh> loadMesh(String string) {
        if (!this.meshes.containsKey(string)) {
            this.meshes.put(string, new MeshAsset(string));
        }
        return this.meshes.get(string);
    }

    @Override
    public Asset<byte[]> loadRaw(String string) {
        if (!this.raws.containsKey(string)) {
            this.raws.put(string, new ByteAsset(string));
        }
        return this.raws.get(string);
    }
}

