package katajakasa;
import robocode.*;
import java.awt.Color;
import java.util.Random;

/**
 * DeadHorseSix - a robot by Katajakasa
 */
public class DeadHorseSix extends AdvancedRobot {
	public Random rand;
	
	public DeadHorseSix() {
		rand = new Random();
	}
	
	public void run() {
		setColors(Color.black, Color.red, Color.red); 
		
		while(true) {
			ahead(rand.nextInt(120)+50);
			if(rand.nextBoolean()) {
				turnRight(rand.nextInt(190)+10);
			} else {
				turnLeft(rand.nextInt(190)+10);
			}	
			turnGunRight(360);
		}
	}

	public void onHitRobot(HitRobotEvent e) {
       if(e.getBearing() > -20 && e.getBearing() <= 20) {
           fire(35);
       } else {
           turnGunRight(360);
       }
   }

	public void onScannedRobot(ScannedRobotEvent e) {
		double power = 10 * (e.getDistance()/600.0) + rand.nextDouble()*3;
		fire(power);
	}
	
	public void onHitWall(HitWallEvent e) {
		back(rand.nextInt(150)+10);
	}	
}
					   	