/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.UGen;

public class Noise
extends UGen {
    public UGen.UGenInput amplitude = new UGen.UGenInput(UGen.InputType.CONTROL);
    public UGen.UGenInput offset;
    private Tint tint;
    private float lastOutput;
    private float brownCutoffFreq = 100.0f;
    private float brownAlpha;
    private float brownAmpCorr = 6.2f;
    private int maxKey;
    private int key;
    private int range;
    private float[] whiteValues;
    private float maxSumEver;

    public Noise() {
        this(1.0f, 0.0f, Tint.WHITE);
    }

    public Noise(float f) {
        this(f, 0.0f, Tint.WHITE);
    }

    public Noise(Tint tint) {
        this(1.0f, 0.0f, tint);
    }

    public Noise(float f, Tint tint) {
        this(f, 0.0f, tint);
    }

    public Noise(float f, float f2, Tint tint) {
        this.amplitude.setLastValue(f);
        this.offset = new UGen.UGenInput(UGen.InputType.CONTROL);
        this.offset.setLastValue(f2);
        this.lastOutput = 0.0f;
        this.tint = tint;
        if (this.tint == Tint.PINK) {
            this.initPink();
        }
    }

    public void setTint(Tint tint) {
        if (this.tint != tint) {
            if (tint == Tint.PINK) {
                this.initPink();
            }
            this.tint = tint;
        }
    }

    public final Tint getTint() {
        return this.tint;
    }

    @Override
    protected void sampleRateChanged() {
        float f = 1.0f / this.sampleRate();
        float f2 = 1.0f / ((float)Math.PI * 2 * this.brownCutoffFreq);
        this.brownAlpha = f / (f2 + f);
    }

    @Override
    protected void uGenerate(float[] fArray) {
        float f;
        float f2 = this.amplitude.getLastValue();
        switch (this.tint) {
            case BROWN: 
            case RED: {
                f = f2 * (2.0f * (float)Math.random() - 1.0f);
                this.lastOutput = f = this.brownAlpha * f + (1.0f - this.brownAlpha) * this.lastOutput;
                f *= this.brownAmpCorr;
                break;
            }
            case PINK: {
                f = f2 * this.pink();
                break;
            }
            default: {
                f = f2 * (2.0f * (float)Math.random() - 1.0f);
            }
        }
        f += this.offset.getLastValue();
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = f;
        }
    }

    private void initPink() {
        this.maxKey = 31;
        this.range = 128;
        this.maxSumEver = 90.0f;
        this.key = 0;
        this.whiteValues = new float[6];
        for (int i = 0; i < 6; ++i) {
            this.whiteValues[i] = (float)Math.random() * 9.223372E18f % (float)(this.range / 6);
        }
    }

    private float pink() {
        int n = this.key++;
        if (this.key > this.maxKey) {
            this.key = 0;
        }
        int n2 = n ^ this.key;
        float f = 0.0f;
        for (int i = 0; i < 6; ++i) {
            if ((n2 & 1 << i) != 0) {
                this.whiteValues[i] = (float)Math.random() * 9.223372E18f % (float)(this.range / 6);
            }
            f += this.whiteValues[i];
        }
        if (f > this.maxSumEver) {
            this.maxSumEver = f;
        }
        f = 2.0f * (f / this.maxSumEver) - 1.0f;
        return f;
    }

    public static enum Tint {
        WHITE,
        PINK,
        RED,
        BROWN;

    }
}

