/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.UGen;

public class Pan
extends UGen {
    public UGen.UGenInput pan;
    private UGen audio;
    private float[] tickBuffer = new float[1];
    private static float PIOVER2 = 1.5707964f;

    public Pan(float f) {
        this.pan = new UGen.UGenInput(UGen.InputType.CONTROL);
        this.pan.setLastValue(f);
    }

    public void setPan(float f) {
        this.pan.setLastValue(f);
    }

    @Override
    protected void addInput(UGen uGen) {
        this.audio = uGen;
        this.audio.setChannelCount(1);
    }

    @Override
    protected void removeInput(UGen uGen) {
        if (this.audio == uGen) {
            this.audio = null;
        }
    }

    @Override
    protected void sampleRateChanged() {
        if (this.audio != null) {
            this.audio.setSampleRate(this.sampleRate());
        }
    }

    @Override
    public void setChannelCount(int n) {
        if (n != 2) {
            throw new IllegalArgumentException("Pan MUST be ticked with STEREO output! It doesn't make sense in any other context!");
        }
        super.setChannelCount(n);
    }

    @Override
    protected void uGenerate(float[] fArray) {
        if (fArray.length != 2) {
            throw new IllegalArgumentException("Pan MUST be ticked with STEREO output! It doesn't make sense in any other context!");
        }
        float f = this.pan.getLastValue();
        if (this.audio != null) {
            this.audio.tick(this.tickBuffer);
        }
        float f2 = (f + 1.0f) * 0.5f;
        float f3 = (float)Math.cos(PIOVER2 * f2);
        float f4 = (float)Math.sin(PIOVER2 * f2);
        fArray[0] = this.tickBuffer[0] * f3;
        fArray[1] = this.tickBuffer[0] * f4;
    }
}

