/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt.event;

import com.jogamp.newt.event.InputEvent;

public class MouseEvent
extends InputEvent {
    public static final short BUTTON1 = 1;
    public static final short BUTTON2 = 2;
    public static final short BUTTON3 = 3;
    public static final short BUTTON4 = 4;
    public static final short BUTTON5 = 5;
    public static final short BUTTON6 = 6;
    public static final short BUTTON7 = 7;
    public static final short BUTTON8 = 8;
    public static final short BUTTON9 = 9;
    public static final short BUTTON_NUMBER = 16;
    private final int[] x;
    private final int[] y;
    private final short clickCount;
    private final short button;
    private final float wheelRotation;
    private final float[] pressure;
    private final short[] pointerids;
    public static final short EVENT_MOUSE_CLICKED = 200;
    public static final short EVENT_MOUSE_ENTERED = 201;
    public static final short EVENT_MOUSE_EXITED = 202;
    public static final short EVENT_MOUSE_PRESSED = 203;
    public static final short EVENT_MOUSE_RELEASED = 204;
    public static final short EVENT_MOUSE_MOVED = 205;
    public static final short EVENT_MOUSE_DRAGGED = 206;
    public static final short EVENT_MOUSE_WHEEL_MOVED = 207;

    public static final short getClickTimeout() {
        return 300;
    }

    public MouseEvent(short s, Object object, long l, int n, int n2, int n3, short s2, short s3, float f) {
        super(s, object, l, n);
        this.x = new int[]{n2};
        this.y = new int[]{n3};
        this.pressure = new float[]{0.0f};
        this.pointerids = new short[]{-1};
        this.clickCount = s2;
        this.button = s3;
        this.wheelRotation = f;
    }

    public MouseEvent(short s, Object object, long l, int n, int[] nArray, int[] nArray2, float[] fArray, short[] sArray, short s2, short s3, float f) {
        super(s, object, l, n);
        this.x = nArray;
        this.y = nArray2;
        if (sArray.length != fArray.length || sArray.length != nArray.length || sArray.length != nArray2.length) {
            throw new IllegalArgumentException("All multiple pointer arrays must be of same size");
        }
        this.pressure = fArray;
        this.pointerids = sArray;
        this.clickCount = s2;
        this.button = s3;
        this.wheelRotation = f;
    }

    public int getPointerCount() {
        return this.x.length;
    }

    public short getPointerId(int n) {
        if (n >= this.pointerids.length) {
            return -1;
        }
        return this.pointerids[n];
    }

    public short getButton() {
        return this.button;
    }

    public short getClickCount() {
        return this.clickCount;
    }

    public int getX() {
        return this.x[0];
    }

    public int getY() {
        return this.y[0];
    }

    public int getX(int n) {
        return this.x[n];
    }

    public int getY(int n) {
        return this.y[n];
    }

    public float getPressure() {
        return this.pressure[0];
    }

    public float getPressure(int n) {
        return this.pressure[n];
    }

    public float getWheelRotation() {
        return this.wheelRotation;
    }

    @Override
    public String toString() {
        return this.toString(null).toString();
    }

    @Override
    public StringBuilder toString(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("MouseEvent[").append(MouseEvent.getEventTypeString(this.getEventType())).append(", ").append(this.x).append("/").append(this.y).append(", button ").append(this.button).append(", count ").append(this.clickCount).append(", wheel rotation ").append(this.wheelRotation);
        if (this.pointerids.length > 0) {
            stringBuilder.append(", pointer<").append(this.pointerids.length).append(">[");
            for (int i = 0; i < this.pointerids.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.pointerids[i]).append(": ").append(this.x[i]).append(" / ").append(this.y[i]).append(" ").append(this.pressure[i]).append("p");
            }
            stringBuilder.append("]");
        }
        stringBuilder.append(", ");
        return super.toString(stringBuilder).append("]");
    }

    public static String getEventTypeString(short s) {
        switch (s) {
            case 200: {
                return "EVENT_MOUSE_CLICKED";
            }
            case 201: {
                return "EVENT_MOUSE_ENTERED";
            }
            case 202: {
                return "EVENT_MOUSE_EXITED";
            }
            case 203: {
                return "EVENT_MOUSE_PRESSED";
            }
            case 204: {
                return "EVENT_MOUSE_RELEASED";
            }
            case 205: {
                return "EVENT_MOUSE_MOVED";
            }
            case 206: {
                return "EVENT_MOUSE_DRAGGED";
            }
            case 207: {
                return "EVENT_MOUSE_WHEEL_MOVED";
            }
        }
        return "unknown (" + s + ")";
    }
}

