/*
 * Very simple PDB file reader-viewer 
 */

#define PDBSUCCESS    0
#define PDBFILEERROR -1
#define PDBMEMOERROR -2


typedef struct _ATOM {
   float px;
   float py;
   float pz;
} ATOM;

typedef struct _PDB {
   unsigned long atomnum;
   ATOM *atoms;

   GLfloat *vertices;
   GLfloat *normals;
   GLfloat *colors;
   GLuint  *indices;
   unsigned int vcount;
   unsigned int ncount;
   unsigned int ccount;
   unsigned int icount;

   unsigned int vmax;
   unsigned int imax;

   GLuint vao;
   GLuint vbo[4];
} PDB;

int loadPDB(PDB *pdb, const char *filename);
void freePDB(PDB *pdb);
void generateMesh(PDB *pdb);
void drawPDB(PDB pdb);
