#define GL_GLEXT_PROTOTYPES
#include <GL/gl.h>
#include <math.h>
#include "shader.h"
#include "matrix.h"
#include "mesh3d.h"
#include "texture.h"
#include "greetings.h"

#define ARCNUM 20
#define IMGNUM 8

float *perspective;
Mesh3D *arc;
Mesh3D *keperno;

GLuint greetshaders[2];
GLuint greetprg;
GLuint msgshaders[2];
GLuint msgprg;

float arcypos[ARCNUM];
float imgypos[IMGNUM];
GLuint imgarr[IMGNUM];

void initGreetings(float *pmatrix){
   int i;

   perspective = pmatrix;

   arc = loadOBJ("data/arc.obj");
   keperno = loadOBJ("data/keperno.obj");

   for(i = 0; i < ARCNUM; i++){
      arcypos[i] = (float)i * -10.0;
   }

   for(i = 0; i < IMGNUM; i++){
      imgypos[i] = (1200 + (750 / IMGNUM * i)) * -1;
   }

   greetshaders[0] = loadShader(GL_VERTEX_SHADER,   "shaders/greet.vs");
   greetshaders[1] = loadShader(GL_FRAGMENT_SHADER, "shaders/greet.fs");
   greetprg        = createProgram(2, greetshaders);

   msgshaders[0]   = loadShader(GL_VERTEX_SHADER, "shaders/msg.vs");
   msgshaders[1]   = loadShader(GL_FRAGMENT_SHADER, "shaders/msg.fs");
   msgprg          = createProgram(2, msgshaders);

   glBindVertexArray(arc->vao);
   bindVarToBuff(greetprg, "vertex", arc->vbo[MESHVERTEXINDEX], 3);
   bindVarToBuff(greetprg, "normal", arc->vbo[MESHNORMALINDEX], 3);
   bindVarToBuff(greetprg, "texco",  arc->vbo[MESHTEXINDEX], 2);

   imgarr[0]    = loadPNGTexture("data/texture/chorus.png");
   imgarr[1]    = loadPNGTexture("data/texture/dilemma.png");
   imgarr[2]    = loadPNGTexture("data/texture/united_force.png");
   imgarr[3]    = loadPNGTexture("data/texture/los_angeles_lamers.png");
   imgarr[4]    = loadPNGTexture("data/texture/rebels.png");
   imgarr[5]    = loadPNGTexture("data/texture/resource.png");
   imgarr[6]    = loadPNGTexture("data/texture/singular_crew.png");
   imgarr[7]    = loadPNGTexture("data/texture/fresh_mindworkz.png");

   glBindVertexArray(keperno->vao);
   bindVarToBuff(msgprg, "vertex", keperno->vbo[MESHVERTEXINDEX], 3);
   bindVarToBuff(msgprg, "normals", keperno->vbo[MESHNORMALINDEX], 3);
   bindVarToBuff(msgprg, "tcoord", keperno->vbo[MESHTEXINDEX], 2);

}

void greetingsScene(double time){
   GLint loc;
   float camera[16];
   float pos[]    = {0.0, 0.0, 0.0};
   float target[] = {0.0, -100.0, 0.0};
   float up[]     = {0.0, 0.0, -1.0};
   float tr[16];
   float rot[16];
   float modelm[16];
   int i;
   float ori;

   pos[1] = time * -10.0;
   target[1] = pos[1] - 100.0;

   lookAt(camera, pos, target, up);

   glUseProgram(greetprg);
   loc = glGetUniformLocation(greetprg, "pmatrix");
   glUniformMatrix4fv(loc, 1, GL_FALSE, perspective);
   loc = glGetUniformLocation(greetprg, "camera");
   glUniformMatrix4fv(loc, 1, GL_FALSE, camera);
   loc = glGetUniformLocation(greetprg, "model");

   for(i = 0; i < ARCNUM; i++){
      ori = (i % 2) == 0 ? 1 : -1;
      if(arcypos[i] > pos[1] && time < 180.0){
         arcypos[i] -= 10.0 * ARCNUM;
      }
      translate(tr, 0.0, arcypos[i], 0.0);
      rotate(rot, 0.0, ori * (time +  (float)i * 18.0), 0.0);
      matrixMultiply4x4(tr, rot, modelm);
      glUniformMatrix4fv(loc, 1, GL_FALSE, modelm);
      drawMesh3D(arc);
   }


   glUseProgram(msgprg);
   loc = glGetUniformLocation(msgprg, "pmatrix");
   glUniformMatrix4fv(loc, 1, GL_FALSE, perspective);
   loc = glGetUniformLocation(msgprg, "camera");
   glUniformMatrix4fv(loc, 1, GL_FALSE, camera);

   for(i = 0; i < IMGNUM; i++){
      translate(tr, 0.0, imgypos[i], 0.0);
      rotate(rot, 0.0, M_PI, 0.0);
      loc = glGetUniformLocation(msgprg, "model");
      matrixMultiply4x4(tr, rot, modelm);

      glUniformMatrix4fv(loc, 1, GL_FALSE, modelm);
      loc = glGetUniformLocation(msgprg, "image");

      glActiveTexture(GL_TEXTURE0);
      glBindTexture(GL_TEXTURE_2D, imgarr[i]);
      glUniform1i(loc, 0);
      drawMesh3D(keperno);
   }

}

void freeGreetings(){
   freeMesh3D(arc);
   deleteProgram(greetprg, 3, greetshaders);
}
