#define GL_GLEXT_PROTOTYPES
#include <GL/gl.h>
#include <math.h>
#include "mesh3d.h"
#include "shader.h"
#include "texture.h"
#include "sky.h"
#include "embryo.h"
#include "matrix.h"

Mesh3D *embryo;
Mesh3D *earth;

GLuint earthtex;

GLuint embryoshaders[2];
GLuint embryoprg;
GLuint earthshaders[2];
GLuint earthprg;

float *perspective;

void initEmbryoScene(float *pm){
   embryo   = loadOBJ("data/embryo.obj");
   earth    = loadOBJ("data/earth.obj");
   earthtex = loadPNGTexture("data/texture/earth.png");

   embryoshaders[0] = loadShader(GL_VERTEX_SHADER, "shaders/embryo.vs");
   embryoshaders[1] = loadShader(GL_FRAGMENT_SHADER, "shaders/embryo.fs");
   embryoprg        = createProgram(2, embryoshaders);
   glBindFragDataLocation(embryoprg, 0, "FragColor");
   glBindFragDataLocation(embryoprg, 1, "BloomColor");
   glLinkProgram(embryoprg);

   glBindVertexArray(embryo->vao);
   bindVarToBuff(embryoprg, "vertex", embryo->vbo[MESHVERTEXINDEX], 3);
   bindVarToBuff(embryoprg, "tcoord", embryo->vbo[MESHTEXINDEX], 2);

   earthshaders[0] = loadShader(GL_VERTEX_SHADER, "shaders/earth.vs");
   earthshaders[1] = loadShader(GL_FRAGMENT_SHADER, "shaders/earth.fs");
   earthprg        = createProgram(2, earthshaders);
   glBindVertexArray(earth->vao);
   bindVarToBuff(earthprg, "vertex", earth->vbo[MESHVERTEXINDEX], 3);
   bindVarToBuff(earthprg, "tcoord", earth->vbo[MESHTEXINDEX], 2);

   perspective = pm;
}

void embryoScene(double time){
   float camera[16];
   float rot[16];
   float pos[3] = {0.0, 0.0, 0.0},
         target[3] = {0.0, 0.0, 0.0},
         up[3] = {0.0, 1.0, 0.0};
   GLint loc;

   pos[0] = sin(time) * 30.0;
   pos[2] = cos(time) * 30.0;

   if(time < 315.0){
      rotate(rot, 0.0, time - M_PI / 2.0, 0.0);
   }
   else{
      pos[0] = sin(315.0) * 30.0;
      pos[2] = cos(315.0) * 30.0;
      rotate(rot, 0.0, time - M_PI / 2.0, time - 315.0 * -1.0);
   }

   lookAt(camera, pos, target, up);

   drawSky(perspective, camera, 1.0);

   glUseProgram(embryoprg);
   loc = glGetUniformLocation(embryoprg, "camera");
   glUniformMatrix4fv(loc, 1, GL_FALSE, camera);
   loc = glGetUniformLocation(embryoprg, "pmatrix");
   glUniformMatrix4fv(loc, 1, GL_FALSE, perspective);
   drawMesh3D(embryo);

   glUseProgram(earthprg);
   loc = glGetUniformLocation(earthprg, "camera");
   glUniformMatrix4fv(loc, 1, GL_FALSE, camera);
   loc = glGetUniformLocation(earthprg, "pmatrix");
   glUniformMatrix4fv(loc, 1, GL_FALSE, perspective);
   loc = glGetUniformLocation(earthprg, "model");
   glUniformMatrix4fv(loc, 1, GL_FALSE, rot);

   glActiveTexture(GL_TEXTURE0);
   glBindTexture(GL_TEXTURE_2D, earthtex);
   loc = glGetUniformLocation(earthprg, "image");
   glUniform1i(loc, 0);
   drawMesh3D(earth);
}

void freeEmbryoScene(){
   freeMesh3D(embryo);
   freeMesh3D(earth);
}
