#define GL_GLEXT_PROTOTYPES
#include <GL/gl.h>
#include <math.h>
#include <stdlib.h>
#include "atomscene.h"
#include "shader.h"
#include "matrix.h"
#include "sky.h"
#include "mesh3d.h"

#define LIGHTNUM 8

float *perspective;
Mesh3D *nucleus;

GLuint atomshaders[3];
GLuint atomprg;
GLuint ppshaders[3];
GLuint ppprg;

GLfloat *lightpos;
GLuint lightvao, lightvbo;

void initAtomScene(float *pmatrix){

  atomshaders[0] = loadShader(GL_GEOMETRY_SHADER, "shaders/atom.gs");
  atomshaders[1] = loadShader(GL_VERTEX_SHADER, "shaders/atom.vs");
  atomshaders[2] = loadShader(GL_FRAGMENT_SHADER, "shaders/atom.fs");
  atomprg        = createProgram(3, atomshaders);

  ppshaders[0] = loadShader(GL_VERTEX_SHADER, "shaders/pp.vs");
  ppshaders[1] = loadShader(GL_GEOMETRY_SHADER, "shaders/pp.gs");
  ppshaders[2] = loadShader(GL_FRAGMENT_SHADER, "shaders/pp.fs");
  ppprg        = createProgram(3, ppshaders);

  nucleus = loadOBJ("data/atom.obj");
  glBindVertexArray(nucleus->vao);
  bindVarToBuff(atomprg, "vertex", nucleus->vbo[MESHVERTEXINDEX], 3);
  bindVarToBuff(atomprg, "normal", nucleus->vbo[MESHNORMALINDEX], 3);
  bindVarToBuff(atomprg, "tcoord", nucleus->vbo[MESHTEXINDEX], 2);

  lightpos = malloc(sizeof(GLfloat) * LIGHTNUM * 3);

  glGenVertexArrays(1, &lightvao);
  glBindVertexArray(lightvao);
  glGenBuffers(1, &lightvbo);
  glBindBuffer(GL_ARRAY_BUFFER, lightvbo);
  glBufferData(GL_ARRAY_BUFFER, sizeof(GLfloat) * LIGHTNUM * 3, lightpos, GL_DYNAMIC_DRAW);
  glVertexAttribPointer(0, 3, GL_FLOAT, GL_FALSE, 0, 0);
  glEnableVertexAttribArray(0);

  perspective = pmatrix;
}

void atomScene(double time){
   GLuint loc;
   float camera[16];
   float pos[] = {10.0, 10.0, 10.0};
   float target[] = {0.0, 0.0, 0.0};
   float up[] = {0.0, 1.0, 0.0};
   int i;
   float o[] = {0.0, 1.570796, M_PI, 4.8, 0.0, 1.57, M_PI, 4.8};

   pos[0] = sin(time) * 10.0;
   pos[1] = cos(time) * 10.0;
   lookAt(camera, pos, target, up);

   glBindVertexArray(lightvao);
   glBindBuffer(GL_ARRAY_BUFFER, lightvbo);
   lightpos = (GLfloat*)glMapBuffer(GL_ARRAY_BUFFER, GL_WRITE_ONLY);

   glUseProgram(atomprg);
   loc = glGetUniformLocation(atomprg, "pmatrix");
   glUniformMatrix4fv(loc, 1, GL_FALSE, perspective);
   loc = glGetUniformLocation(atomprg, "camera");
   glUniformMatrix4fv(loc, 1, GL_FALSE, camera);
   loc = glGetUniformLocation(atomprg, "lightpos");

   time = time * 3.0;
   for(i = 0; i < LIGHTNUM; i++){
      if(i < 4) time = time * -1.0;
      lightpos[i * 3 + 0] = sin(time) * 5.0;
      lightpos[i * 3 + 1] = sin(time + o[i]) * 5.0;
      lightpos[i * 3 + 2] = cos(time) * 5.0;
   }

   glUnmapBuffer(GL_ARRAY_BUFFER);

   glUniform3fv(loc, LIGHTNUM, lightpos);

   drawMesh3D(nucleus);
   drawSky(perspective, camera, 1.0);

   glUseProgram(ppprg);
   loc = glGetUniformLocation(ppprg, "pmatrix");
   glUniformMatrix4fv(loc, 1, GL_FALSE, perspective);
   loc = glGetUniformLocation(ppprg, "camera");
   glUniformMatrix4fv(loc, 1, GL_FALSE, camera);
   glBindVertexArray(lightvao);
   glBindBuffer(GL_ARRAY_BUFFER, lightvbo);
   glDrawArrays(GL_POINTS, 0, LIGHTNUM);
}

void freeAtomScene(){
   freeMesh3D(nucleus);
   /*free(lightpos); FIXME I can not understand why do not working this */
   glDeleteBuffers(1, &lightvbo);
   glDeleteVertexArrays(1, &lightvao);
}
