#version 150

layout (points) in;
layout (points, max_vertices = 21) out;

uniform mat4 pmatrix;
uniform mat4 camera;

const float pi = 3.1415926535;

void main(void){

   /* atom in the centre */
   gl_Position = pmatrix * camera * gl_in[0].gl_Position;
   gl_PointSize = 5.0;
   EmitVertex();
   EndPrimitive();

   /* additional atoms */
   for(float i = -pi/2.0; i < pi/2.0; i += pi/20.0){
      vec4 pos = gl_in[0].gl_Position;
      pos.x = pos.x + sin(i) * -30.0;
      pos.y = pos.y + cos(i * 54.5) * 30.0;
      pos.z = pos.z + cos(i) * -30.0;
      gl_Position = pmatrix * camera * pos;
      gl_PointSize = 2.0;
      EmitVertex();
      EndPrimitive();
   }
}
