#version 150

in vec3 vertex;
in vec3 normal;
in vec2 texco;

uniform mat4 pmatrix;
uniform mat4 camera;
uniform mat4 model;

out vec3 lightint;
out vec2 tc;

const vec4 lightpos = vec4(0.0, 110.0, 0.0, 1.0);
const vec3 la = vec3(0.2, 0.2, 0.2);
const vec3 ld = vec3(1.0, 1.0, 1.0);
const vec3 ls = vec3(1.0, 1.0, 1.0);

const vec3 ma = vec3(0.25, 0.25, 0.25);
const vec3 md = vec3(0.4, 0.4, 0.4);
const vec3 ms = vec3(0.7745, 0.7745, 0.7745);
const float shininess = 0.6;

void main(void){
   vec3 tnorm = normalize(normal);
   vec4 ec = camera * model * vec4(vertex, 1.0);
   vec3 s = normalize(vec3(lightpos - ec));
   vec3 v = normalize(-ec.xyz);
   vec3 r = reflect(-s, tnorm);
   vec3 ambient = la * ma;
   float sDotN = max( dot(s, tnorm), 0.0);
   vec3 diffuse = ld * md * sDotN;
   vec3 spec = vec3(0.0);
   if(sDotN > 0.0){
      spec = ls * ms * pow( max( dot(r,v), 0.0), shininess);
   }
   lightint = ambient + diffuse + spec;

   tc = texco;
   gl_Position = pmatrix * camera * model *vec4(vertex,1.0);
}
