#version 150

in vec3 vertex;
in vec3 normal;
in vec2 tcoord;

uniform vec3 lightpos[8];

out vec2 texc;
out vec3 vertexcolor;

void main(void){
   gl_Position = vec4(vertex, 1.0);
   float sum = 0.0;

   for(int i = 0; i < 8; i++){
      vec3 nlp = normalize(lightpos[i]);
      float d = dot(nlp, normalize(normal)) / 8.0;
      sum += d;
   }

   vertexcolor = vec3(sum);
   texc = tcoord;
}
