#version 150

layout (triangles) in;
layout (triangle_strip, max_vertices = 123) out;

in vec2 texc[3];
out vec2 tc;

uniform mat4 pmatrix;
uniform mat4 camera;
uniform int clone;

void main(void){

   for(int j = 0; j < gl_in.length(); j++){
      gl_Position = pmatrix * camera * gl_in[j].gl_Position;
      tc = texc[j];
      EmitVertex();
   }
   EndPrimitive();

   if(clone == 0) return;

   for(int i = 0; i < 40; i++){
      for(int j = 0; j < gl_in.length(); j++){
         vec4 pos = gl_in[j].gl_Position + vec4(sin(i) * i * 10.0, i * 10.0 - 60.0, 0.0, 1.0);
         gl_Position = pmatrix * camera * pos;
         tc = texc[j];
         EmitVertex();
      }
      EndPrimitive();
   }

}
