#version 150 compatibility
#extension GL_EXT_gpu_shader4: require
uniform sampler2D in_Normal;
uniform sampler2D in_VPos;
uniform sampler2D in_MaterialMap;
uniform sampler2D in_rnm;
uniform float in_sample_rad;
uniform float in_intensity;
uniform float in_scale;
uniform float in_bias;
in vec2 uv;
float SampleRadius;
float Intensity;
float DistanceScale;
int   MaterialIndex;
const int MaterialMap_PixelsPerMaterial = 3;
const int MaterialMap_MaterialsCount    = 16;
vec4 GetMaterialData(int DataItem)
{
return texelFetch(in_MaterialMap, ivec2(0, MaterialIndex *  MaterialMap_PixelsPerMaterial + DataItem), 0);
}
float doAmbientOcclusion(vec2 tcoord, vec2 uv, vec3 p, vec3 cnorm)
{
vec3  diff = texture2D(in_VPos, tcoord + uv).xyz - p;
vec3  v    = normalize(diff);
float d    = length(diff) * DistanceScale ;
return max(0.0, dot(cnorm, v) - in_bias) * ( 1.0 / (1.0 + d)) * Intensity;
}
void main()
{
vec2 vec[8] = vec2[8](vec2(1., 0.), vec2(-1., 0.), vec2(0., 1.), vec2(0., -1.), vec2(0.707, 0.707), vec2(-0.707, 0.707), vec2(-0.707, -0.707), vec2(0.707, -0.707));
vec4 vpos_matID = texture2D(in_VPos, uv);
vec3 p = vpos_matID.xyz;
MaterialIndex = int(vpos_matID.w + .5);
vec4 AOStruct = GetMaterialData(2);
Intensity = in_intensity * AOStruct.z;
DistanceScale = in_scale * AOStruct.w;
vec3 n = texture2D(in_Normal, uv).xyz;
vec2 rand = normalize(texture2D(in_rnm, vec2(800., 600.) * uv / 64.).xy);
float ao = 0.;
float rad = AOStruct.y  * in_sample_rad / p.z;
int iterations = 7;
for (int j = 0; j < iterations; ++j)
{
vec2 coord1 = reflect(vec[j], rand)*rad;
vec2 coord2 = vec2(coord1.x*0.707 - coord1.y*0.707,
coord1.x*0.707 + coord1.y*0.707)*.8;
ao += doAmbientOcclusion(uv, coord1*0.1, p, n);
ao += doAmbientOcclusion(uv, coord2*0.2, p, n);
ao += doAmbientOcclusion(uv, coord1*0.3, p, n);
ao += doAmbientOcclusion(uv, coord2*0.4, p, n);
ao += doAmbientOcclusion(uv, coord1*0.5, p, n);
gl_FragData[0] = vec4(-4.2*texture2D(in_VPos, uv + coord1 * 0.01).xyz, 1);
}
ao /= float(iterations)*4.0;
gl_FragData[0] = vec4(1. - ao, 1. - ao, 1. - ao, 1.);
}