#extension GL_EXT_gpu_shader4: require
uniform float     Time;
uniform sampler2D InSpeed;
uniform sampler2D InSpeedIIR;
uniform sampler2D InPosition;
uniform sampler2D InAcc;
uniform usampler2D CellInfo;
uniform float CenterX;
uniform float CenterY;
uniform float CenterZ;
varying vec2 uv;
float rand(vec2 co, float f)
{
return fract(sin(dot(co.xy ,vec2(12.9898,78.233) * f)) * 43758.5453) - 0.5;
}
void main(void)
{
vec3 OfsPos = texture2D(InPosition, uv).xyz;
float O2P_Dist   = length(OfsPos);
vec3  O2P_Normal = normalize(OfsPos);
vec3 OriginPos  = vec3(texture2D(CellInfo, uv).xyz) * 2.;
vec3 SpherePos  = vec3(CenterX, CenterY, CenterZ);
vec3 ShiftedPos = OriginPos + OfsPos;
vec3  S2P        = ShiftedPos - SpherePos;
float S2P_Dist   = length(S2P);
vec3  S2P_Normal = normalize(S2P);
vec3 ForceVector = vec3(0.);
if (S2P_Dist > 0.00001) ForceVector += S2P_Normal * (4000. / pow(S2P_Dist, 2.));
if (O2P_Dist > 0.00001) ForceVector -= O2P_Normal * O2P_Dist * 0.01;
vec3 speed = texture2D(InSpeed, uv).xyz;
speed += ForceVector * 10.1;
speed *= 0.98;
float speedlen = length(speed);
OfsPos += speed * 0.1;
gl_FragData[0] = vec4(OfsPos, 1.0);
gl_FragData[1] = vec4(speed, 1.0);
gl_FragData[2] = vec4( mix(texture2D(InAcc,      uv).xyz, ForceVector, 0.05), 1.);
gl_FragData[3] = vec4( mix(texture2D(InSpeedIIR, uv).xyz, speed,       0.05), 1.);
}