#version 330 compatibility
uniform sampler2D AnimationMap;
uniform float     AniValueOffset;
uniform float time;
uniform mat4 ModelMatrix;
uniform mat4 ModelViewMatrix;
uniform mat4 ProjectionMatrix;
uniform mat3 NormalMatrix;
layout(lines_adjacency) in;
layout(triangle_strip, max_vertices = 4) out;
in vData
{
float MatIndex;
vec3  normal;
vec3  wpos;
vec3  diffuse;
vec3  emission;
vec2  texcoord1;
vec2  texcoord2;
}vertices[];
out fData
{
float MatIndex;
vec3  normal;
vec3  vpos;
vec3  diffuse;
vec3  emission;
vec4  hpos;
vec2  texcoord1;
vec2  texcoord2;
}frag;
vec3 wPosCenter;
vec3 mPosCenter;
vec3 new_wpos[4];
void emit(int index)
{
frag.MatIndex  = vertices[index].MatIndex;
frag.diffuse   = vertices[index].diffuse ;
frag.emission  = vertices[index].emission + vec3(1);
frag.texcoord1 = vertices[index].texcoord1;
frag.texcoord2 = vertices[index].texcoord2;
vec3 wpos = new_wpos[index];
vec3 normal = normalize(vec3(wpos.x, 0., wpos.z));
frag.normal = normalize(NormalMatrix * normal);
frag.vpos     = (ModelViewMatrix * vec4(wpos, 1.)).xyz;
frag.hpos = gl_Position = ProjectionMatrix * ModelViewMatrix * vec4(wpos, 1.);
EmitVertex();
}
void main()
{
mPosCenter = vec3(0);
for (int i=0; i<4; i++)
mPosCenter += vertices[i].wpos / 4;
wPosCenter = (ModelMatrix * vec4(mPosCenter, 1.)).xyz;
vec3 normal = normalize(vec3(wPosCenter.x, 0, wPosCenter.z));
float Animation = (1 - texelFetch(AnimationMap, ivec2(vertices[0].texcoord2.yx) - ivec2(40, 0), 0).a) + AniValueOffset;
if (Animation > 0.9) Animation = 1;
for (int i=0; i<4; i++)
new_wpos[i] = mix(vertices[i].wpos, mPosCenter, Animation);
emit(0); emit(1); emit(3); emit(2);
EndPrimitive();
}