uniform sampler2D InputMap;
uniform sampler2D BloomMap1;
uniform sampler2D BloomMap2;
uniform sampler2D BloomMap3;
uniform sampler2D BloomMap4;
varying vec2 uv;
uniform float BloomFactor;
uniform float Exposure;
void main(void)
{
vec4 color = texture2D(BloomMap1, uv);
color += texture2D(BloomMap2, uv);
color += texture2D(BloomMap3, uv);
color += texture2D(BloomMap4, uv);
color = texture2D(InputMap, uv) * Exposure + (color * BloomFactor);
color = clamp(color, 0., 1.);
color.a = dot(sqrt(color.rgb), vec3(0.299, 0.587, 0.114));
gl_FragColor = color;
}