;; --- ENGINE -----

alias dmDrawFrame {

    set %dm.c $calc($ticks - %dm.ticks.main)

    drawdot @demo
    if (%dm.fs == 1) {
        drawcopy @demo 0 0 %dm.screen.w %dm.screen.h @demo.fs 0 0 %dm.fs.w %dm.fs.h
    }
    drawrect -nrf @demo 0 0 0 0 %dm.screen.w %dm.screen.h
    .timerdmDrawFrame -tmh 1 0 noop $!dmStartDraw( $1 )
    set %dm.frt $calc(%dm.c - %dm.frt.start)
}


alias dmStartDraw {
    set %dm.frt.start %dm.c
    $1
}

alias dmInit {
    noop $findfile($scriptdir, *.mrc, 0, 1, loadPart $1-)
    set %dm.screen.x 1280
    set %dm.screen.y 0
    set %dm.screen.w 320
    set %dm.screen.h 180
    window -dak0pfboB +b @demo %dm.screen.x %dm.screen.y %dm.screen.w %dm.screen.h
    if ($1 == fs) {
        set %dm.fs.w $window(-1).w
        set %dm.fs.h $window(-1).h
        window -dak0pfBbo +d @demo.fs 0 0 %dm.fs.w %dm.fs.h
        set %dm.fs 1
        tokenize 32 $2-
    }
    elseif ($1 == fs2) {
        set %dm.fs.w 1280
        set %dm.fs.h 800
        window -dak0pfBbo +d @demo.fs 1920 0 %dm.fs.w %dm.fs.h
        set %dm.fs 1
        tokenize 32 $2-
    }
    set %dm.flags $1-

    set %dm.ticks.main $ticks
    set %dm.fps.ticks.start $ticks
    set %dm.fps.count 0

    set %dm.precalc.cnt 1
    window -h @dmPreloadLog
    clear @dmPreLoadLog
    dmPreload
}

alias partyhack1 {
    dmInit $1 disclaimer
}

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; --- Preloader ---
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

alias dmPreload {
    var %read $($read($scriptdirprecalc.dss, %dm.precalc.cnt), 2)
    %read
    :error
    inc %dm.precalc.cnt

    echo @dmPreloadLog %read
    dmPrintLog

    var %tot $lines($scriptdirprecalc.dss)
    var %pct $calc((%dm.precalc.cnt / %tot) * 100)
    var %txt Precalculationizing... .. . $+($round(%pct, 0),$(%))

    var %x $calc(160 - $width(%txt, fixedsys, 18) / 2)
    drawtext -nr @demo 8421504 fixedsys 18 %x 160 %txt
    drawrect -nrfi @demo 8421504 0 5 160 $calc($+(0.,$iif(%pct < 10, $+(0,%pct), %pct)) * 305) 15
    break
    if (%dm.precalc.cnt <= %tot) {
        dmDrawFrame dmPreload
    }
    else {
        window -c @dmPreloadLog
        if (%dm.music != $null) {
            splay -w $qt(%dm.music)
        }
        .signal -n dmSelectPart %dm.flags
    }
}


alias dmPrintLog {
    var %cnt 1
    var %tot 15
    while (%cnt <= %tot) {
        drawtext -nrb @demo $rgb(255,0,0) 0 console 10 0 $calc((%tot - (%cnt * 11)) + 138) $line(@dmPreloadLog, $calc($line(@dmPreloadLog, 0) - %cnt))
        inc %cnt
    }
}

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Global functions
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

alias dinc {
    inc $+(%,$1) $calc(%dm.frt * $2)
}

alias ddec {
    dec $+(%,$1) $calc(%dm.frt * $2)
}

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; ---- EVENTS ----
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


on *:SIGNAL:dmSelectPart: {
    signal -n $+(demo_,$1) init
    set %dm.ticks.main $ticks
    set %dm.fps.ticks.start $ticks
    ;set %dm.fps.count 0
    set %dm.c 0
    set %dm.frt.start 0
    $+(demo_,$1)
}


on *:CLOSE:@demo*: {
    splay stop
    drawpic -c
    unset %dm.*
}

on *:KEYDOWN:*:32: {
    echo -s %dm.c
}

on *:LOAD: {
    noop $findfile($scriptdir, *.mrc, 0, 1, loadPart $1-)
}

alias loadPart {
    var %file $1-
    if ($nopath(%file) != demo.mrc) {
        load -rs $qt(%file)
    }
}
