// mog
/*jslint devel: true, browser: true */
var Demo = (function () {
    "use strict";

    var _audio,
        _sceneList,
        _model,
        BPM = 123,
        BEAT_OFFSET = 0,
        AUDIO_URL = 'data/alpha_c_-_apophenia.ogg',
        AUDIO_VOLUME = 1,
        ROWS_PER_BEAT = 8,
        ROW_RATE = BPM / 60 * ROWS_PER_BEAT,
        _demoMode = true,
        _row = 0,
        LOOP_POSITION = 0,
        _syncDevice = new JSRocket.SyncDevice();

    var _readyToRoll = false;

    function start() {
        if (_demoMode) {
            _syncDevice.setConfig({'rocketXML': 'data/apophenia.rocket'});
            _syncDevice.init('demo');
        } else {
            _syncDevice.init();
        }

        _syncDevice.on('ready', syncReady);
        _syncDevice.on('update', onSyncUpdate);
        _syncDevice.on('play', onPlay);
        _syncDevice.on('pause', onPause);
    }

    function syncReady() {

        initAudio();
        initScenes();
    }

    function initAudio() {

        _audio = new Tune();
        _audio.loopPoint(LOOP_POSITION);
        _audio.on('play', onAudioReady);
        _audio.on('ended', onEnded);
        _audio.create(AUDIO_URL);
        //_audio.play();
    }

    function initScenes() {

        setModel();

        _sceneList = new SceneList(_model);
        _sceneList.setBPM(BPM);
        _sceneList.setBeatOffsetMs(BEAT_OFFSET);
        _sceneList.add(WakeyWakey, 0, 15609);
        _sceneList.add(Twirl, 15609, 46829);
        _sceneList.add(Polyfield, 46829, 103414);
        _sceneList.add(Kaleido, 103414, 158767);
        _sceneList.add(Hexa, 158767, 171463);
        _sceneList.add(Plasma, 171463, 220487);
        _sceneList.add(Credits, 220487, 224390);
        _sceneList.on('ready', onPreflightDone);
        _sceneList.preflight();
    }

    function setModel() {

        _model = new Model();
        _model.stage = document.createElement('div');
        _model.stage.setAttribute('class', 'demo');
        document.getElementById('root').appendChild(_model.stage);
        _model.scale(false);
        _model.width(1920 / 1080 * window.innerHeight);
        _model.height(window.innerHeight);

        _model.stage.style.cssText = 'margin-left:' + (window.innerWidth - _model.width()) / 2 + 'px;';

        _model.BPM = BPM;
        _model.volume = AUDIO_VOLUME;
        _model.sync = _syncDevice;

        var canvas = document.createElement('canvas');
        canvas.style.cssText = 'position:absolute;top:0;background:#fff;left:' + (window.innerWidth - _model.width()) / 2 + 'px;';
        canvas.width = _model.width();
        canvas.height = _model.height();
        _model.twoDeeRenderer = canvas.getContext('2d');
        _model.stage.appendChild(canvas);

        addVignetteLayer(_model.stage, canvas);
    }

    function addVignetteLayer(holder, canvas) {

        var v = document.createElement('canvas');
        v.width = _model.width();
        v.height = _model.height();
        v.style.cssText = canvas.style.cssText + 'z-index:1;background:none;';

        _model.vignette = v.getContext('2d');

        holder.appendChild(v);
    }

    function onAudioReady() {

        //console.log("Duration:", _audio.duration(), "Rows:", _audio.duration() * ROW_RATE);

        if (_readyToRoll === false) {
            return;
        }

        //nuke callback
        _audio.on("play", function () {
        });

        loop();
    }

    function onEnded() {
        document.getElementById('root').classList.remove('cursorHidden');
        //document.getElementById('root').style.backgroundColor = "#fff";
        //_model.stage.style.display = "none";
    }

    function onSyncUpdate(row) {
        //on interpolation change, we don't get a valid row
        if (!isNaN(row)) {
            _row = row;
        }

        _audio.position(_row / ROW_RATE);

        loop();
    }

    function onPlay() {
        _audio.volume(AUDIO_VOLUME);
        _audio.position(_row / ROW_RATE);
        _audio.play();
        loop();
    }

    function onPause() {
        _audio.pause();

        _row = _audio.position() * ROW_RATE;
    }

    function loop() {

        var position = _audio.position();

        if (_audio.isPaused() === false) {
            window.requestAnimationFrame(loop, document);
            _syncDevice.update(position * ROW_RATE);
        }

        if (position < _audio.duration()) {
            _sceneList.update(position);
        }
    }

    function pause(setPaused) {

        if ((setPaused === true) && (!_audio.isPaused())) {
            _audio.pause();
        } else if (_audio.isPaused()) {
            _audio.play();
            loop();
        }
    }

    function onPreflightDone() {
        _readyToRoll = true;

        if (_demoMode)
            _audio.play();
    }

    function getAudio() {
        return _audio;
    }

    function getSceneList() {
        return _sceneList.getList();
    }

    function getModel() {
        return _model;
    }

    function getSceneListClass() {
        return _sceneList;
    }

    return {
        pause: pause,
        start: start,
        audio: getAudio,
        sceneList: getSceneList,
        model: getModel,
        sceneController: getSceneListClass
    };
}());
