/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim;

import ddf.minim.AudioSignal;
import ddf.minim.AudioSource;
import ddf.minim.NoteManager;
import ddf.minim.Polyphonic;
import ddf.minim.SignalChain;
import ddf.minim.spi.AudioOut;
import ddf.minim.ugens.DefaultInstrument;
import ddf.minim.ugens.Frequency;
import ddf.minim.ugens.Instrument;
import ddf.minim.ugens.Summer;

public class AudioOutput
extends AudioSource
implements Polyphonic {
    private AudioOut synth;
    private SignalChain signals;
    private NoteManager noteManager;
    Summer bus;

    public AudioOutput(AudioOut audioOut) {
        super(audioOut);
        this.synth = audioOut;
        this.signals = new SignalChain();
        this.noteManager = new NoteManager(this.getFormat().getSampleRate());
        this.bus = new Summer();
        this.bus.setSampleRate(this.getFormat().getSampleRate());
        this.bus.setChannelCount(this.getFormat().getChannels());
        this.synth.setAudioSignal(new SampleGenerator());
    }

    @Override
    public void addSignal(AudioSignal audioSignal) {
        this.signals.add(audioSignal);
    }

    @Override
    public AudioSignal getSignal(int n) {
        return this.signals.get(n);
    }

    @Override
    public void removeSignal(AudioSignal audioSignal) {
        this.signals.remove(audioSignal);
    }

    @Override
    public AudioSignal removeSignal(int n) {
        return this.signals.remove(n);
    }

    @Override
    public void clearSignals() {
        this.signals.clear();
    }

    @Override
    public void disableSignal(int n) {
        this.signals.disable(n);
    }

    @Override
    public void disableSignal(AudioSignal audioSignal) {
        this.signals.disable(audioSignal);
    }

    @Override
    public void enableSignal(int n) {
        this.signals.enable(n);
    }

    @Override
    public void enableSignal(AudioSignal audioSignal) {
        this.signals.enable(audioSignal);
    }

    @Override
    public boolean isEnabled(AudioSignal audioSignal) {
        return this.signals.isEnabled(audioSignal);
    }

    @Override
    public boolean isSounding() {
        for (int i = 1; i < this.signals.size(); ++i) {
            if (!this.signals.isEnabled(this.signals.get(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void noSound() {
        for (int i = 1; i < this.signals.size(); ++i) {
            this.signals.disable(i);
        }
    }

    @Override
    public int signalCount() {
        return this.signals.size();
    }

    @Override
    public void sound() {
        for (int i = 1; i < this.signals.size(); ++i) {
            this.signals.enable(i);
        }
    }

    @Override
    public boolean hasSignal(AudioSignal audioSignal) {
        return this.signals.contains(audioSignal);
    }

    public void playNote(float f, float f2, Instrument instrument) {
        this.noteManager.addEvent(f, f2, instrument);
    }

    public void playNote(float f, float f2, float f3) {
        this.noteManager.addEvent(f, f2, new DefaultInstrument(f3, this));
    }

    public void playNote(float f, float f2, String string) {
        this.noteManager.addEvent(f, f2, new DefaultInstrument(Frequency.ofPitch(string).asHz(), this));
    }

    public void playNote(float f, float f2) {
        this.noteManager.addEvent(f, 1.0f, new DefaultInstrument(f2, this));
    }

    public void playNote(float f, String string) {
        this.noteManager.addEvent(f, 1.0f, new DefaultInstrument(Frequency.ofPitch(string).asHz(), this));
    }

    public void playNote(float f) {
        this.noteManager.addEvent(0.0f, 1.0f, new DefaultInstrument(f, this));
    }

    public void playNote(String string) {
        this.noteManager.addEvent(0.0f, 1.0f, new DefaultInstrument(Frequency.ofPitch(string).asHz(), this));
    }

    public void playNote() {
        this.noteManager.addEvent(0.0f, 1.0f, new DefaultInstrument(Frequency.ofPitch("").asHz(), this));
    }

    public void setTempo(float f) {
        this.noteManager.setTempo(f);
    }

    public void setNoteOffset(float f) {
        this.noteManager.setNoteOffset(f);
    }

    public void setDurationFactor(float f) {
        this.noteManager.setDurationFactor(f);
    }

    public void pauseNotes() {
        this.noteManager.pause();
    }

    public void resumeNotes() {
        this.noteManager.resume();
    }

    private class SampleGenerator
    implements AudioSignal {
        private SampleGenerator() {
        }

        @Override
        public void generate(float[] fArray) {
            if (AudioOutput.this.signals.size() > 0) {
                AudioOutput.this.signals.generate(fArray);
            }
            float[] fArray2 = new float[1];
            int n = 0;
            while (n < fArray.length) {
                AudioOutput.this.noteManager.tick();
                AudioOutput.this.bus.tick(fArray2);
                int n2 = n++;
                fArray[n2] = fArray[n2] + fArray2[0];
            }
        }

        @Override
        public void generate(float[] fArray, float[] fArray2) {
            if (AudioOutput.this.signals.size() > 0) {
                AudioOutput.this.signals.generate(fArray, fArray2);
            }
            float[] fArray3 = new float[2];
            int n = 0;
            while (n < fArray.length) {
                AudioOutput.this.noteManager.tick();
                AudioOutput.this.bus.tick(fArray3);
                int n2 = n;
                fArray[n2] = fArray[n2] + fArray3[0];
                int n3 = n++;
                fArray2[n3] = fArray2[n3] + fArray3[1];
            }
        }
    }
}

