/*
 * Decompiled with CFR 0.152.
 */
package seltar.unzipit;

import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PImage;

public class UnZipIt {
    PApplet parent;
    File zip;

    public UnZipIt(String string, PApplet pApplet) {
        this.parent = pApplet;
        pApplet.registerDispose((Object)this);
        this.zip = new File(string);
    }

    public File getZip() {
        return this.zip;
    }

    public ZipEntry getZipEntry(String string) {
        try {
            ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(this.zip.getAbsolutePath()));
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null && !zipEntry.getName().toLowerCase().equals(string.toLowerCase())) {
                zipInputStream.closeEntry();
                zipEntry = zipInputStream.getNextEntry();
            }
            if (zipEntry == null) {
                System.out.println("No such file: " + string);
                return null;
            }
            return zipEntry;
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            return null;
        }
    }

    public String[] getFilenames() {
        try {
            ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(this.zip.getAbsolutePath()));
            String[] stringArray = new String[]{};
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                stringArray = PApplet.append((String[])stringArray, (String)zipEntry.getName());
                zipInputStream.closeEntry();
                zipEntry = zipInputStream.getNextEntry();
            }
            return stringArray;
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            return null;
        }
    }

    public void loadZip(String string) {
        this.zip = new File(string);
    }

    public byte[] loadBytes(String string) {
        try {
            int n;
            ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(this.zip.getAbsolutePath()));
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null && !zipEntry.getName().toLowerCase().equals(string.toLowerCase())) {
                zipInputStream.closeEntry();
                zipEntry = zipInputStream.getNextEntry();
            }
            if (zipEntry == null) {
                System.out.println("No such file: " + string);
                return null;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            while ((n = zipInputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            zipInputStream.close();
            byteArrayOutputStream.close();
            return byArray2;
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            return null;
        }
    }

    public String loadString(String string) {
        byte[] byArray = this.loadBytes(string);
        return new String(byArray);
    }

    public PImage loadImage(String string) {
        byte[] byArray = this.loadBytes(string);
        if (byArray != null) {
            Image image = Toolkit.getDefaultToolkit().createImage(byArray);
            MediaTracker mediaTracker = new MediaTracker((Component)this.parent);
            mediaTracker.addImage(image, 0);
            try {
                mediaTracker.waitForAll();
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            int n = string.lastIndexOf(46);
            String string2 = string.substring(n + 1);
            PImage pImage = new PImage(image);
            if ((string2.equals("gif") || string2.equals("png")) && pImage.pixels != null) {
                for (int i = 0; i < pImage.pixels.length; ++i) {
                    if ((pImage.pixels[n] & 0xFF000000) == -16777216) continue;
                    pImage.format = 2;
                    break;
                }
            }
            return pImage;
        }
        return null;
    }

    public PFont loadFont(String string) {
        try {
            ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(this.zip.getAbsolutePath()));
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null && !zipEntry.getName().toLowerCase().equals(string.toLowerCase())) {
                zipInputStream.closeEntry();
                zipEntry = zipInputStream.getNextEntry();
            }
            if (zipEntry == null) {
                System.out.println("No such file: " + string);
                return null;
            }
            if (!zipEntry.getName().toLowerCase().endsWith(".vlw")) {
                System.out.println("Only works with fonts ending with .vlw");
                return null;
            }
            return new PFont((InputStream)zipInputStream);
        }
        catch (Exception exception) {
            System.out.println(exception);
            return null;
        }
    }

    public String unpackFile(String string, String string2) {
        byte[] byArray = this.loadBytes(string);
        if (byArray != null) {
            File file = new File(string2);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file.getAbsolutePath());
                ((OutputStream)fileOutputStream).write(byArray, 0, byArray.length);
                ((OutputStream)fileOutputStream).close();
            }
            catch (Exception exception) {
                return exception.toString();
            }
            return file.getAbsolutePath();
        }
        return null;
    }

    public void dispose() {
    }
}

