/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.x11;

import com.jogamp.nativewindow.x11.X11GraphicsDevice;
import com.jogamp.nativewindow.x11.X11GraphicsScreen;
import com.jogamp.newt.event.KeyEvent;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.VisualIDHolder;
import javax.media.nativewindow.util.Insets;
import javax.media.nativewindow.util.Point;
import jogamp.nativewindow.x11.X11Lib;
import jogamp.nativewindow.x11.X11Util;
import jogamp.newt.DisplayImpl;
import jogamp.newt.WindowImpl;
import jogamp.newt.driver.x11.DisplayDriver;
import jogamp.newt.driver.x11.ScreenDriver;

public class WindowDriver
extends WindowImpl {
    private static final String WINDOW_CLASS_NAME = "NewtWindow";
    private static final int X11_WHEEL_ONE_UP_BUTTON = 4;
    private static final int X11_WHEEL_ONE_DOWN_BUTTON = 5;
    private static final int X11_WHEEL_TWO_UP_BUTTON = 6;
    private static final int X11_WHEEL_TWO_DOWN_BUTTON = 7;
    private long windowHandleClose;
    private X11GraphicsDevice renderDevice;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createNativeImpl() {
        ScreenDriver screenDriver = (ScreenDriver)this.getScreen();
        DisplayDriver displayDriver = (DisplayDriver)screenDriver.getDisplay();
        AbstractGraphicsDevice abstractGraphicsDevice = displayDriver.getGraphicsDevice();
        long l = X11Util.openDisplay(abstractGraphicsDevice.getConnection());
        if (0L == l) {
            throw new RuntimeException("Error creating display(GfxCfg/Render): " + abstractGraphicsDevice.getConnection());
        }
        this.renderDevice = new X11GraphicsDevice(l, 0, true);
        X11GraphicsScreen x11GraphicsScreen = new X11GraphicsScreen(this.renderDevice, screenDriver.getIndex());
        GraphicsConfigurationFactory graphicsConfigurationFactory = GraphicsConfigurationFactory.getFactory(displayDriver.getGraphicsDevice(), this.capsRequested);
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = graphicsConfigurationFactory.chooseGraphicsConfiguration(this.capsRequested, this.capsRequested, this.capabilitiesChooser, x11GraphicsScreen, 0);
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("X11Window.createNativeImpl() factory: " + graphicsConfigurationFactory + ", chosen config: " + abstractGraphicsConfiguration);
        }
        if (null == abstractGraphicsConfiguration) {
            throw new NativeWindowException("Error choosing GraphicsConfiguration creating window: " + this);
        }
        int n = abstractGraphicsConfiguration.getVisualID(VisualIDHolder.VIDType.NATIVE);
        if (0 == n) {
            throw new NativeWindowException("Chosen Configuration w/o native visual ID: " + abstractGraphicsConfiguration);
        }
        this.setGraphicsConfiguration(abstractGraphicsConfiguration);
        int n2 = this.getReconfigureFlags(0, true) & 0x1200;
        abstractGraphicsDevice.lock();
        try {
            this.setWindowHandle(this.CreateWindow0(this.getParentWindowHandle(), abstractGraphicsDevice.getHandle(), screenDriver.getIndex(), n, displayDriver.getJavaObjectAtom(), displayDriver.getWindowDeleteAtom(), this.getX(), this.getY(), this.getWidth(), this.getHeight(), this.autoPosition(), n2));
        }
        finally {
            abstractGraphicsDevice.unlock();
        }
        this.windowHandleClose = this.getWindowHandle();
        if (0L == this.windowHandleClose) {
            throw new NativeWindowException("Error creating window");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeNativeImpl() {
        if (0L != this.windowHandleClose && null != this.getScreen()) {
            DisplayDriver displayDriver = (DisplayDriver)this.getScreen().getDisplay();
            AbstractGraphicsDevice abstractGraphicsDevice = displayDriver.getGraphicsDevice();
            abstractGraphicsDevice.lock();
            try {
                this.CloseWindow0(abstractGraphicsDevice.getHandle(), this.windowHandleClose, displayDriver.getJavaObjectAtom(), displayDriver.getWindowDeleteAtom());
            }
            catch (Throwable throwable) {
                if (DEBUG_IMPLEMENTATION) {
                    Exception exception = new Exception("Warning: closeNativeImpl failed - " + Thread.currentThread().getName(), throwable);
                    exception.printStackTrace();
                }
            }
            finally {
                abstractGraphicsDevice.unlock();
                this.windowHandleClose = 0L;
            }
        }
        if (null != this.renderDevice) {
            this.renderDevice.close();
            this.renderDevice = null;
        }
    }

    @Override
    protected boolean reconfigureWindowImpl(int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        Object object;
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("X11Window reconfig: " + n + "/" + n2 + " " + n3 + "x" + n4 + ", " + WindowDriver.getReconfigureFlagsAsString(null, n5));
        }
        if (0 == (0x200 & n5)) {
            object = this.getInsets();
            n7 = n - object.getLeftWidth();
            n6 = n2 - object.getTopHeight();
        } else {
            n7 = n;
            n6 = n2;
        }
        object = (DisplayDriver)this.getScreen().getDisplay();
        this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<Object>((DisplayDriver)object, n7, n6, n3, n4, n5){
            final /* synthetic */ DisplayDriver val$display;
            final /* synthetic */ int val$_x;
            final /* synthetic */ int val$_y;
            final /* synthetic */ int val$width;
            final /* synthetic */ int val$height;
            final /* synthetic */ int val$flags;
            {
                this.val$display = displayDriver;
                this.val$_x = n;
                this.val$_y = n2;
                this.val$width = n3;
                this.val$height = n4;
                this.val$flags = n5;
            }

            @Override
            public Object run(long l) {
                WindowDriver.this.reconfigureWindow0(l, WindowDriver.this.getScreenIndex(), WindowDriver.this.getParentWindowHandle(), WindowDriver.this.getWindowHandle(), this.val$display.getWindowDeleteAtom(), this.val$_x, this.val$_y, this.val$width, this.val$height, this.val$flags);
                return null;
            }
        });
        return true;
    }

    protected void reparentNotify(long l) {
        if (DEBUG_IMPLEMENTATION) {
            long l2 = this.getParentWindowHandle();
            System.err.println("Window.reparentNotify (" + WindowDriver.getThreadName() + "): " + WindowDriver.toHexString(l2) + " -> " + WindowDriver.toHexString(l));
        }
    }

    @Override
    protected void requestFocusImpl(final boolean bl) {
        this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<Object>(){

            @Override
            public Object run(long l) {
                WindowDriver.this.requestFocus0(l, WindowDriver.this.getWindowHandle(), bl);
                return null;
            }
        });
    }

    @Override
    protected void setTitleImpl(final String string) {
        this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<Object>(){

            @Override
            public Object run(long l) {
                WindowDriver.setTitle0(l, WindowDriver.this.getWindowHandle(), string);
                return null;
            }
        });
    }

    @Override
    protected boolean setPointerVisibleImpl(final boolean bl) {
        return this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<Boolean>(){

            @Override
            public Boolean run(long l) {
                return WindowDriver.setPointerVisible0(l, WindowDriver.this.getWindowHandle(), bl);
            }
        });
    }

    @Override
    protected boolean confinePointerImpl(final boolean bl) {
        return this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<Boolean>(){

            @Override
            public Boolean run(long l) {
                return WindowDriver.confinePointer0(l, WindowDriver.this.getWindowHandle(), bl);
            }
        });
    }

    @Override
    protected void warpPointerImpl(final int n, final int n2) {
        this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<Object>(){

            @Override
            public Object run(long l) {
                WindowDriver.warpPointer0(l, WindowDriver.this.getWindowHandle(), n, n2);
                return null;
            }
        });
    }

    @Override
    protected Point getLocationOnScreenImpl(final int n, final int n2) {
        return this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<Point>(){

            @Override
            public Point run(long l) {
                return X11Lib.GetRelativeLocation(l, WindowDriver.this.getScreenIndex(), WindowDriver.this.getWindowHandle(), 0L, n, n2);
            }
        });
    }

    @Override
    protected void updateInsetsImpl(Insets insets) {
    }

    @Override
    protected final void doMouseEvent(boolean bl, boolean bl2, short s, int n, int n2, int n3, short s2, float[] fArray, float f) {
        block0 : switch (s) {
            case 203: {
                switch (s2) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        return;
                    }
                }
                break;
            }
            case 204: {
                switch (s2) {
                    case 4: {
                        s = (short)207;
                        s2 = 1;
                        fArray[1] = 1.0f;
                        break block0;
                    }
                    case 5: {
                        s = (short)207;
                        s2 = 1;
                        fArray[1] = -1.0f;
                        break block0;
                    }
                    case 6: {
                        s = (short)207;
                        s2 = 1;
                        fArray[0] = 1.0f;
                        n |= 1;
                        break block0;
                    }
                    case 7: {
                        s = (short)207;
                        s2 = 1;
                        fArray[0] = -1.0f;
                        n |= 1;
                    }
                }
            }
        }
        super.doMouseEvent(bl, bl2, s, n, n2, n3, s2, fArray, f);
    }

    protected final void sendKeyEvent(short s, int n, short s2, short s3, char c, String string) {
        char c2;
        boolean bl = KeyEvent.isModifierKey(s2);
        boolean bl2 = 0 != (0x20000000 & n);
        char c3 = c2 = null != string ? string.charAt(0) : c;
        if (!bl2 || !bl) {
            switch (s) {
                case 300: {
                    super.sendKeyEvent((short)300, n, s2, s3, c2);
                    break;
                }
                case 301: {
                    super.sendKeyEvent((short)301, n, s2, s3, c2);
                }
            }
        }
    }

    @Override
    public final void sendKeyEvent(short s, int n, short s2, short s3, char c) {
        throw new InternalError("XXX: Adapt Java Code to Native Code Changes");
    }

    @Override
    public final void enqueueKeyEvent(boolean bl, short s, int n, short s2, short s3, char c) {
        throw new InternalError("XXX: Adapt Java Code to Native Code Changes");
    }

    private static final String getCurrentThreadName() {
        return Thread.currentThread().getName();
    }

    private static final void dumpStack() {
        Thread.dumpStack();
    }

    private final <T> T runWithLockedDisplayDevice(DisplayImpl.DisplayRunnable<T> displayRunnable) {
        return ((DisplayDriver)this.getScreen().getDisplay()).runWithLockedDisplayDevice(displayRunnable);
    }

    protected static native boolean initIDs0();

    private native long CreateWindow0(long var1, long var3, int var5, int var6, long var7, long var9, int var11, int var12, int var13, int var14, boolean var15, int var16);

    private native void CloseWindow0(long var1, long var3, long var5, long var7);

    private native void reconfigureWindow0(long var1, int var3, long var4, long var6, long var8, int var10, int var11, int var12, int var13, int var14);

    private native void requestFocus0(long var1, long var3, boolean var5);

    private static native void setTitle0(long var0, long var2, String var4);

    private static native long getParentWindow0(long var0, long var2);

    private static native boolean setPointerVisible0(long var0, long var2, boolean var4);

    private static native boolean confinePointer0(long var0, long var2, boolean var4);

    private static native void warpPointer0(long var0, long var2, int var4, int var5);

    static {
        DisplayDriver.initSingleton();
    }
}

