/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl;

import com.jogamp.common.GlueGenVersion;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.JogampVersion;
import com.jogamp.common.util.VersionUtil;
import java.util.List;
import java.util.jar.Manifest;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.opengl.GL;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;

public class JoglVersion
extends JogampVersion {
    protected static volatile JoglVersion jogampCommonVersionInfo;

    protected JoglVersion(String string, Manifest manifest) {
        super(string, manifest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JoglVersion getInstance() {
        if (null != jogampCommonVersionInfo) return jogampCommonVersionInfo;
        Class<JoglVersion> clazz = JoglVersion.class;
        synchronized (JoglVersion.class) {
            if (null != jogampCommonVersionInfo) return jogampCommonVersionInfo;
            Manifest manifest = VersionUtil.getManifest((ClassLoader)JoglVersion.class.getClassLoader(), (String)"javax.media.opengl");
            jogampCommonVersionInfo = new JoglVersion("javax.media.opengl", manifest);
            // ** MonitorExit[var0] (shouldn't be in output)
            return jogampCommonVersionInfo;
        }
    }

    public StringBuilder toString(GL gL, StringBuilder stringBuilder) {
        stringBuilder = super.toString(stringBuilder).append(Platform.getNewline());
        JoglVersion.getGLInfo(gL, stringBuilder);
        return stringBuilder;
    }

    public String toString(GL gL) {
        return this.toString(gL, null).toString();
    }

    public static StringBuilder getAvailableCapabilitiesInfo(GLDrawableFactory gLDrawableFactory, AbstractGraphicsDevice abstractGraphicsDevice, StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        boolean bl = false;
        if (null != gLDrawableFactory) {
            try {
                List<GLCapabilitiesImmutable> list = gLDrawableFactory.getAvailableCapabilities(abstractGraphicsDevice);
                if (null != list && list.size() > 0) {
                    for (int i = 0; i < list.size(); ++i) {
                        stringBuilder.append("\t").append(list.get(i)).append(Platform.getNewline());
                    }
                    bl = true;
                }
            }
            catch (GLException gLException) {
                // empty catch block
            }
        }
        if (!bl) {
            stringBuilder.append("\tnone").append(Platform.getNewline());
        }
        stringBuilder.append(Platform.getNewline());
        return stringBuilder;
    }

    public static StringBuilder getAllAvailableCapabilitiesInfo(AbstractGraphicsDevice abstractGraphicsDevice, StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        if (null == abstractGraphicsDevice) {
            abstractGraphicsDevice = GLProfile.getDefaultDevice();
        }
        stringBuilder.append(Platform.getNewline()).append(Platform.getNewline());
        stringBuilder.append("Desktop Capabilities: ").append(Platform.getNewline());
        JoglVersion.getAvailableCapabilitiesInfo(GLDrawableFactory.getDesktopFactory(), abstractGraphicsDevice, stringBuilder);
        stringBuilder.append("EGL Capabilities: ").append(Platform.getNewline());
        JoglVersion.getAvailableCapabilitiesInfo(GLDrawableFactory.getEGLFactory(), abstractGraphicsDevice, stringBuilder);
        return stringBuilder;
    }

    public static StringBuilder getDefaultOpenGLInfo(AbstractGraphicsDevice abstractGraphicsDevice, StringBuilder stringBuilder, boolean bl) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        if (null == abstractGraphicsDevice) {
            abstractGraphicsDevice = GLProfile.getDefaultDevice();
        }
        stringBuilder.append("Default Profiles on device ").append(abstractGraphicsDevice).append(Platform.getNewline());
        if (null != abstractGraphicsDevice) {
            GLProfile.glAvailabilityToString(abstractGraphicsDevice, stringBuilder, "\t", 1);
        } else {
            stringBuilder.append("none");
        }
        if (bl) {
            stringBuilder = JoglVersion.getAllAvailableCapabilitiesInfo(abstractGraphicsDevice, stringBuilder);
        }
        return stringBuilder;
    }

    public static StringBuilder getGLInfo(GL gL, StringBuilder stringBuilder) {
        return JoglVersion.getGLInfo(gL, stringBuilder, false);
    }

    public static StringBuilder getGLInfo(GL gL, StringBuilder stringBuilder, boolean bl) {
        AbstractGraphicsDevice abstractGraphicsDevice = gL.getContext().getGLDrawable().getNativeSurface().getGraphicsConfiguration().getScreen().getDevice();
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("-----------------------------------------------------------------------------------------------------").append(Platform.getNewline());
        stringBuilder.append(abstractGraphicsDevice.getClass().getSimpleName()).append("[type ").append(abstractGraphicsDevice.getType()).append(", connection ").append(abstractGraphicsDevice.getConnection()).append("]: ").append(Platform.getNewline());
        GLProfile.glAvailabilityToString(abstractGraphicsDevice, stringBuilder, "\t", 1);
        stringBuilder.append(Platform.getNewline());
        stringBuilder = JoglVersion.getGLStrings(gL, stringBuilder);
        if (bl) {
            stringBuilder = JoglVersion.getAllAvailableCapabilitiesInfo(abstractGraphicsDevice, stringBuilder);
        }
        return stringBuilder;
    }

    public static StringBuilder getGLStrings(GL gL, StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        GLContext gLContext = gL.getContext();
        stringBuilder.append("Swap Interval  ").append(gL.getSwapInterval());
        stringBuilder.append(Platform.getNewline());
        stringBuilder.append("GL Profile     ").append(gL.getGLProfile());
        stringBuilder.append(Platform.getNewline());
        stringBuilder.append("GL Version     ").append(gLContext.getGLVersion()).append(" [GL ").append(gLContext.getGLVersionNumber()).append(", vendor ").append(gLContext.getGLVendorVersionNumber()).append("]");
        stringBuilder.append(Platform.getNewline());
        stringBuilder.append("Quirks         ").append(gLContext.getRendererQuirks());
        stringBuilder.append(Platform.getNewline());
        stringBuilder.append("Impl. class    ").append(gL.getClass().getCanonicalName());
        stringBuilder.append(Platform.getNewline());
        stringBuilder.append("GL_VENDOR      ").append(gL.glGetString(7936));
        stringBuilder.append(Platform.getNewline());
        stringBuilder.append("GL_RENDERER    ").append(gL.glGetString(7937));
        stringBuilder.append(Platform.getNewline());
        stringBuilder.append("GL_VERSION     ").append(gL.glGetString(7938));
        stringBuilder.append(Platform.getNewline());
        stringBuilder.append("GLSL           ").append(gL.hasGLSL()).append(", has-compiler-func: ").append(gL.isFunctionAvailable("glCompileShader"));
        if (gL.hasGLSL()) {
            stringBuilder.append(", version: ").append(gL.glGetString(35724)).append(" / ").append(gLContext.getGLSLVersionNumber());
        }
        stringBuilder.append(Platform.getNewline());
        stringBuilder.append("GL_EXTENSIONS  ").append(gLContext.getGLExtensionCount());
        stringBuilder.append(Platform.getNewline());
        stringBuilder.append("               ").append(gLContext.getGLExtensionsString());
        stringBuilder.append(Platform.getNewline());
        stringBuilder.append("GLX_EXTENSIONS ").append(gLContext.getPlatformExtensionCount());
        stringBuilder.append(Platform.getNewline());
        stringBuilder.append("               ").append(gLContext.getPlatformExtensionsString());
        stringBuilder.append(Platform.getNewline());
        stringBuilder.append("-----------------------------------------------------------------------------------------------------");
        return stringBuilder;
    }

    public StringBuilder getBriefOSGLBuildInfo(GL gL, StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("OS: ").append(Platform.getOSName()).append(", version ").append(Platform.getOSVersion()).append(", arch ").append(Platform.getArchName());
        stringBuilder.append(Platform.getNewline());
        stringBuilder.append("GL_VENDOR     ").append(gL.glGetString(7936));
        stringBuilder.append(Platform.getNewline());
        stringBuilder.append("GL_RENDERER   ").append(gL.glGetString(7937));
        stringBuilder.append(Platform.getNewline());
        stringBuilder.append("GL_VERSION    ").append(gL.glGetString(7938));
        stringBuilder.append(Platform.getNewline());
        stringBuilder.append("JOGL GIT sha1 ").append(this.getImplementationCommit());
        stringBuilder.append(Platform.getNewline());
        return stringBuilder;
    }

    public static void main(String[] stringArray) {
        System.err.println(VersionUtil.getPlatformInfo());
        System.err.println(GlueGenVersion.getInstance());
        System.err.println((Object)JoglVersion.getInstance());
    }
}

