/*
 * Decompiled with CFR 0.152.
 */
package org.taongad.utils;

import com.badlogic.gdx.math.MathUtils;
import java.util.logging.Logger;

public class FastMath {
    static Logger log = Logger.getLogger(FastMath.class.getName());
    static boolean initialized = false;
    static float[] sincosLookup;
    static final int MAX_CIRCLE_ANGLE = 512;
    static final int HALF_MAX_CIRCLE_ANGLE = 256;
    static final int QUARTER_MAX_CIRCLE_ANGLE = 128;
    static final int MASK_MAX_CIRCLE_ANGLE = 511;
    public static final float PI = (float)Math.PI;
    public static final float TWO_PI = (float)Math.PI * 2;
    static final float rad = (float)Math.PI / 180;

    public static void init() {
        if (!initialized) {
            log.info("Generate lookups...");
            sincosLookup = new float[512];
            int i = 0;
            while (i < sincosLookup.length) {
                FastMath.sincosLookup[i] = MathUtils.sin((float)i * (float)Math.PI / 256.0f);
                ++i;
            }
        } else {
            return;
        }
        log.info("Done generating lookups...");
        initialized = true;
    }

    public static float radToDeg(float rad) {
        return rad * 57.295776f;
    }

    public static float degToRad(float deg) {
        return deg * ((float)Math.PI / 180);
    }

    public static float cos(float n) {
        int i = (int)(n * 256.0f / (float)Math.PI);
        if ((i %= 512) < 0) {
            return sincosLookup[-i + 128 & 0x1FF];
        }
        return sincosLookup[i + 128 & 0x1FF];
    }

    public static float sin(float n) {
        int i = (int)(n * 256.0f / (float)Math.PI);
        if ((i %= 512) < 0) {
            return sincosLookup[-(-i & 0x1FF) + 512];
        }
        return sincosLookup[i & 0x1FF];
    }

    public static float sinAbs(float n) {
        return 0.5f + FastMath.sin(n) * 0.5f;
    }

    public static float cosAbs(float n) {
        return 0.5f + FastMath.cos(n) * 0.5f;
    }

    public static int floatSinToAbsUChar(float value) {
        return (int)(128.0f + value * 127.0f);
    }
}

