/*
 * Decompiled with CFR 0.152.
 */
package org.taongad.utils;

import com.badlogic.gdx.graphics.Color;

public class ColorUtil {
    static final float MAX_UNSIGNED_BYTE_VAL = 255.0f;

    public static Color createColorFromByteValues(int red, int green, int blue, int alpha) {
        return new Color((float)ColorUtil.ensureUnsignedByteRange(red) / 255.0f, (float)ColorUtil.ensureUnsignedByteRange(green) / 255.0f, (float)ColorUtil.ensureUnsignedByteRange(blue) / 255.0f, (float)alpha / 255.0f);
    }

    private static int ensureUnsignedByteRange(int value) {
        if (value > 255) {
            value = 255;
        } else if (value < 0) {
            value = 0;
        }
        return value;
    }

    public static Color lerpColors(Color colorA, Color colorB, float factor) {
        float colorGroundDiffR = colorA.r - colorB.r;
        float colorGroundDiffG = colorA.g - colorB.g;
        float colorGroundDiffB = colorA.b - colorB.b;
        Color newColor = new Color(colorB.r + colorGroundDiffR * factor, colorB.g + colorGroundDiffG * factor, colorB.b + colorGroundDiffB * factor, 1.0f);
        return newColor;
    }
}

