/*
 * Decompiled with CFR 0.152.
 */
package org.taongad.scene.entities;

import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Disposable;
import java.util.Random;
import java.util.logging.Logger;
import org.taongad.anim.AnimationEvent;
import org.taongad.anim.AnimationSequence;
import org.taongad.anim.drivers.DriverObserver;
import org.taongad.anim.drivers.LerpXYDriver;
import org.taongad.scene.Scene;
import org.taongad.scene.entities.Entity;

public class FieldAnimator<T extends Entity>
implements AnimationEvent.OnCompletedListener,
Disposable {
    Scene parent;
    T microbe;
    Rectangle bounds;
    float pixelsPerFrame;
    float speedPerFrame;
    Random rng;
    AnimationSequence anim;
    Vector2 lastPos;
    boolean running = false;
    Logger log = Logger.getLogger(FieldAnimator.class.getName());
    final float MAX_TRAVEL_DISTANCE = 100.0f;

    public FieldAnimator(Scene parent, AnimationSequence anim, T microbe, Rectangle bounds, float speedInPixelsPerFrame, int randomSeed) {
        parent.addDisposable(this);
        this.parent = parent;
        this.anim = anim;
        this.microbe = microbe;
        this.rng = new Random(randomSeed);
        this.bounds = bounds;
        this.pixelsPerFrame = speedInPixelsPerFrame;
        this.lastPos = new Vector2(this.randomXPos(bounds.x, bounds.width), this.randomYPos(bounds.y, bounds.height));
    }

    public void play() {
        if (!this.running) {
            this.running = true;
            this.createNextDestination();
        }
    }

    private Vector2 createTravelPos() {
        float minX = this.lastPos.x - 50.0f;
        minX = minX < this.bounds.x ? this.bounds.x : minX;
        float rangeX = minX + 100.0f > this.bounds.x + this.bounds.width ? this.bounds.x + this.bounds.width - minX : 100.0f;
        float minY = this.lastPos.y - 50.0f;
        minY = minY < this.bounds.y ? this.bounds.y : minY;
        float rangeY = minY + 100.0f > this.bounds.y + this.bounds.height ? this.bounds.y + this.bounds.height - minY : 100.0f;
        return new Vector2(this.randomXPos(minX, rangeX), this.randomYPos(minY, rangeY));
    }

    private void createNextDestination() {
        Vector2 newPos = this.createTravelPos();
        float time = this.anim.getTotalRunningTime();
        float distance = this.lastPos.dst(newPos);
        float interval = distance / this.pixelsPerFrame * 16.666666f;
        LerpXYDriver lerpDriver = new LerpXYDriver(time, time + interval, this.lastPos, newPos);
        this.lastPos = newPos;
        lerpDriver.registerObserver(new DriverObserver<Vector2>(){

            @Override
            public void publishValue(Vector2 value) {
                ((Entity)FieldAnimator.this.microbe).setPosition(value.x, value.y);
            }
        });
        this.anim.addEvent(lerpDriver);
        lerpDriver.registerOnCompletedListener(this);
    }

    private float randomXPos(float startMinPos, float range) {
        return this.rng.nextFloat() * range + startMinPos;
    }

    private float randomYPos(float startMinPos, float range) {
        return this.rng.nextFloat() * range + startMinPos;
    }

    @Override
    public void onCompleted(float completedTime) {
        if (this.running) {
            this.createNextDestination();
        }
    }

    @Override
    public void dispose() {
        this.running = false;
    }
}

