/*
 * Decompiled with CFR 0.152.
 */
package org.taongad.scene;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import org.taongad.anim.AnimationSequence;
import org.taongad.anim.drivers.Driver;
import org.taongad.anim.drivers.DriverObserver;
import org.taongad.anim.drivers.LerpDriver;
import org.taongad.gfx.PixTex;
import org.taongad.gfx.PixTexSprite;
import org.taongad.scene.FieldAnimationManager;
import org.taongad.scene.SceneManager;
import org.taongad.scene.StringTheoryScene;
import org.taongad.scene.entities.Microbe;
import org.taongad.scene.entities.YellyFish;
import org.taongad.utils.ColorUtil;
import org.taongad.utils.FastMath;

public class WaterScene
extends StringTheoryScene {
    PixTexSprite shark;
    PixTexSprite meteor;
    PixTex land;
    PixTexSprite croc;
    Vector2 crocPos = new Vector2(0.0f, 0.0f);
    Vector2 crocStart = new Vector2(-100.0f, 100.0f);
    Vector2 crocStop = new Vector2(Gdx.graphics.getWidth() + 100, 700.0f);
    float waveScale = 0.0f;
    Color waveColor = Color.WHITE.cpy();
    float tankPos;
    float landTime;
    float landAlpha;
    private DriverObserver<Float> landTimeListener;
    private Driver<Float> driver;
    FieldAnimationManager<Microbe> microbeManager;
    private FieldAnimationManager<YellyFish> yellyfishManager;
    float sharkPos = -10.0f;

    public WaterScene(float startTimeMSec) {
        super(startTimeMSec);
    }

    @Override
    public void onSceneEnterEvent(SceneManager manager) {
        super.onSceneEnterEvent(manager);
        manager.setFadeColor(Color.WHITE);
    }

    @Override
    public void load() {
        this.anim = new AnimationSequence();
        this.land = new PixTex(this, 102, 76, Pixmap.Format.RGBA8888);
        this.shark = new PixTexSprite(this, Gdx.files.internal("gfx/HajUtanBakgrund2.png"));
        this.croc = new PixTexSprite(this, Gdx.files.internal("gfx/krokodil/krokodil.png"));
        this.croc.getSprite().flip(true, false);
        this.croc.getSprite().setRotation(23.0f);
        float lifeTimeOffset = 9000.0f;
        this.microbeManager = new FieldAnimationManager<Microbe>(this, new Rectangle(0.0f, 50.0f, Gdx.graphics.getWidth(), 350.0f), 70, lifeTimeOffset, lifeTimeOffset + 3000.0f, Microbe.class, 123);
        this.microbeManager.play();
        this.yellyfishManager = new FieldAnimationManager<YellyFish>(this, new Rectangle(200.0f, 150.0f, 880.0f, 200.0f), 10, lifeTimeOffset + 8000.0f, lifeTimeOffset + 15000.0f, YellyFish.class, 31311);
        this.yellyfishManager.play();
        this.setupLerpObserver(3000.0f, lifeTimeOffset, 0.0f, 1.0f, new DriverObserver<Float>(){

            @Override
            public void publishValue(Float value) {
                WaterScene.this.waveScale = value.floatValue();
            }
        });
        float sharkStart = lifeTimeOffset + 13000.0f;
        this.setupShark(sharkStart);
        float startLand = sharkStart + 11000.0f;
        float stopLand = startLand + 3000.0f;
        this.setupLerpObserver(startLand, stopLand, 0.0f, 1.0f, new DriverObserver<Float>(){

            @Override
            public void publishValue(Float value) {
                WaterScene.this.landAlpha = value.floatValue();
            }
        });
        this.setupLerpObserver(startLand, stopLand, 0.0f, Gdx.graphics.getWidth() * 33, new DriverObserver<Float>(){

            @Override
            public void publishValue(Float value) {
                WaterScene.this.landTime = value.floatValue();
            }
        });
        float stopCroc = stopLand + 14000.0f;
        this.setupLerpObserver(stopLand, stopCroc, 0.0f, 1.0f, new DriverObserver<Float>(){

            @Override
            public void publishValue(Float value) {
                WaterScene.this.crocPos = WaterScene.this.crocStart.cpy().lerp(WaterScene.this.crocStop, value.floatValue());
            }
        });
        this.setupLerpObserver(stopCroc - 6000.0f, stopCroc, 24.0f, 0.0f, new DriverObserver<Float>(){

            @Override
            public void publishValue(Float value) {
                WaterScene.this.croc.getSprite().setRotation(value.floatValue());
            }
        });
    }

    private void setupLerpObserver(float startTime, float stopTime, float startVal, float endVal, DriverObserver<Float> obs) {
        LerpDriver driver = new LerpDriver(startTime, stopTime, startVal, endVal);
        driver.registerObserver(obs);
        this.anim.addEvent(driver);
    }

    private void setupShark(float startTime) {
        float segTime = 2000.0f;
        int latestPos = -10;
        int firstPos = 160;
        int secondPos = 380;
        int thirdPos = 460;
        int fourthPos = 700;
        int fifthPos = 850;
        int sixthPos = 1100;
        int lastPos = (int)((float)Gdx.graphics.getWidth() + (float)this.shark.getWidth() * 5.0f);
        this.setupLerpObserver(startTime, startTime + segTime, latestPos, firstPos, new DriverObserver<Float>(){

            @Override
            public void publishValue(Float value) {
                WaterScene.this.sharkPos = value.floatValue();
            }
        });
        latestPos = firstPos;
        this.setupLerpObserver(startTime += segTime, startTime + segTime, latestPos, secondPos, new DriverObserver<Float>(){

            @Override
            public void publishValue(Float value) {
                WaterScene.this.sharkPos = value.floatValue();
            }
        });
        latestPos = secondPos;
        this.setupLerpObserver(startTime += segTime, startTime + segTime, latestPos, thirdPos, new DriverObserver<Float>(){

            @Override
            public void publishValue(Float value) {
                WaterScene.this.sharkPos = value.floatValue();
            }
        });
        latestPos = thirdPos;
        this.setupLerpObserver(startTime += segTime, startTime + segTime, latestPos, fourthPos, new DriverObserver<Float>(){

            @Override
            public void publishValue(Float value) {
                WaterScene.this.sharkPos = value.floatValue();
            }
        });
        latestPos = fourthPos;
        this.setupLerpObserver(startTime += segTime, startTime + segTime, latestPos, fifthPos, new DriverObserver<Float>(){

            @Override
            public void publishValue(Float value) {
                WaterScene.this.sharkPos = value.floatValue();
            }
        });
        latestPos = fifthPos;
        this.setupLerpObserver(startTime += segTime, startTime + segTime, latestPos, sixthPos, new DriverObserver<Float>(){

            @Override
            public void publishValue(Float value) {
                WaterScene.this.sharkPos = value.floatValue();
            }
        });
        latestPos = sixthPos;
        this.setupLerpObserver(startTime += segTime, startTime + segTime, latestPos, lastPos, new DriverObserver<Float>(){

            @Override
            public void publishValue(Float value) {
                WaterScene.this.sharkPos = value.floatValue();
            }
        });
    }

    @Override
    protected void draw(float deltaTimeMSec) {
        this.time += deltaTimeMSec;
        this.anim.update(deltaTimeMSec);
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.batch.begin();
        this.bg.clearPix();
        this.waveColor.r = 1.0f - this.waveScale;
        this.waveColor.g = 1.0f - this.waveScale;
        this.drawLand();
        this.land.drawPixToTex();
        Sprite crocSprite = this.croc.getSprite();
        crocSprite.setScale(5.0f);
        crocSprite.setOrigin(crocSprite.getWidth() * 0.6f, crocSprite.getHeight() * 0.4f);
        crocSprite.setPosition(this.crocPos.x, this.crocPos.y);
        crocSprite.draw(this.batch, 1.0f);
        this.blitAndScaleTex(this.land);
        this.drawWave(this.waveColor, (1.0f - this.waveScale) * 15.0f, 172.5f);
        this.bg.drawPixToTex();
        this.blitAndScaleBG();
        Sprite sharkSprite = this.shark.getSprite();
        sharkSprite.setScale(5.0f);
        sharkSprite.setOrigin(sharkSprite.getWidth(), sharkSprite.getHeight() / 2.0f);
        sharkSprite.setPosition(this.sharkPos, 300.0f);
        sharkSprite.draw(this.batch, 0.8f);
        int w = 90;
        int h = 35;
        this.microbeManager.draw(deltaTimeMSec);
        this.yellyfishManager.draw(deltaTimeMSec);
        this.batch.end();
    }

    private void drawLand() {
        this.land.clearPix();
        Pixmap landPix = this.land.getPixmap();
        float amp = 25.0f;
        int yOffs = 40;
        int xOffs = 29;
        float scaledTime = this.landTime * ((1.0f - (this.landAlpha < 0.0f ? 0.0f : this.landAlpha) / 2.0f) * 0.1f);
        Color landColor = Color.ORANGE.cpy();
        float tint = 0.4f;
        Color ground = ColorUtil.createColorFromByteValues(218, 165, 32, 255);
        landColor.r = ground.r * tint;
        landColor.g = ground.g * tint;
        landColor.b = ground.b * tint;
        landColor.a = this.landAlpha;
        landPix.setColor(landColor);
        int x = 0;
        while (x < 204) {
            float yPos = FastMath.sin((scaledTime + (float)x + (float)xOffs) / 204.0f * ((float)Math.PI * 2) * 0.75f) * amp;
            landPix.drawLine(x, (int)yPos + yOffs, x, 152);
            ++x;
        }
        this.land.drawPixToTex();
    }

    private void drawWave(Color waveColor, float nudgeY, float periodOffs) {
        float wave1 = FastMath.sin(this.time * 0.003f);
        float wave2 = FastMath.sin(this.time * 0.003f);
        float wave5 = FastMath.sin(this.time * 0.0025f);
        float wave6 = FastMath.sin(this.time * 0.0035f);
        float wave7 = FastMath.sin(this.time * 2.5E-4f);
        float wave8 = FastMath.sin(this.time * 3.5E-4f);
        float wave9 = FastMath.sin(this.time * 2.8E-4f);
        float SCREENH_OFFS1 = 4.75f;
        float SCREENH_OFFS2 = 2.375f;
        float amp = SCREENH_OFFS2 + SCREENH_OFFS2 * wave1;
        float offsetY = 76.0f + SCREENH_OFFS1 * wave2;
        float timeScale = 5.0E-4f;
        float freq = 8.0f;
        Pixmap bgPix = this.bg.getPixmap();
        int x = 0;
        while (x < bgPix.getWidth()) {
            float wave3 = FastMath.sin((this.time + (float)(x * 100)) * 0.001f);
            float wave4 = FastMath.sin((this.time + (float)(x * 10)) * 0.001f);
            offsetY = nudgeY + 57.0f + SCREENH_OFFS2 * wave3 * this.waveScale;
            amp = SCREENH_OFFS2 + SCREENH_OFFS2 * wave4;
            float waveX = (float)x + periodOffs;
            float timeX = this.time * timeScale;
            float sinY = FastMath.sin((waveX / 204.0f + timeX) * freq * ((float)Math.PI * 2));
            int y = (int)(sinY * amp * this.waveScale);
            y = (int)(offsetY - (float)y);
            bgPix.setColor(waveColor);
            bgPix.drawPixel(x, y);
            bgPix.setColor(0.0f, 0.0f, 0.0f, 1.0f);
            float waterFade = this.waveScale;
            float colHeight = 121.6f;
            int i = y;
            while (i < 152) {
                bgPix.setColor(waveColor.r, waveColor.g, waveColor.b, (colHeight / 152.0f * 1.05f - (float)(i - y) / colHeight * 1.0f) * waterFade);
                bgPix.drawPixel(x, i);
                ++i;
            }
            ++x;
        }
    }
}

