/*
 * Decompiled with CFR 0.152.
 */
package org.taongad.scene;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.utils.Disposable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.taongad.anim.AnimationSequence;
import org.taongad.scene.SceneManager;

public abstract class Scene
implements Disposable {
    Logger log = Logger.getLogger(Scene.class.getName());
    List<Disposable> disposables = new ArrayList<Disposable>();
    SpriteBatch batch;
    private float time;
    public static final int LOWRES_TEX_W = 102;
    public static final int LOWRES_TEX_H = 76;
    protected AnimationSequence anim;
    final int SCREEN_W;
    final int SCREEN_H;
    final int SCREEN_W_HALF;
    final int SCREEN_H_HALF;
    final float startTimeMSec;
    float lastDrawTimeMSec = 0.0f;
    Color fadeColor = Color.BLACK.cpy();

    public Scene(float startTimeMSec) {
        this.SCREEN_W = Gdx.graphics.getWidth();
        this.SCREEN_H = Gdx.graphics.getHeight();
        this.SCREEN_W_HALF = this.SCREEN_W / 2;
        this.SCREEN_H_HALF = this.SCREEN_H / 2;
        this.startTimeMSec = startTimeMSec;
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
    }

    public abstract void load();

    public abstract void onSceneEnterEvent(SceneManager var1);

    public abstract void onSceneExitEvent(SceneManager var1);

    public Color getFadeInColor() {
        return this.fadeColor;
    }

    protected float getSceneTime() {
        return this.time;
    }

    public float getStartTime() {
        return this.startTimeMSec;
    }

    public SpriteBatch getBatch() {
        return this.batch;
    }

    public void addDisposable(Disposable disposable) {
        this.disposables.add(disposable);
    }

    public void update(float deltaTimeMSec) {
        if (this.anim != null) {
            this.anim.update(deltaTimeMSec);
        }
    }

    public void drawScene(float globalTimeMSec) {
        float sceneTime = globalTimeMSec - this.startTimeMSec;
        float f = this.time = sceneTime < 0.0f ? 0.0f : sceneTime;
        if (this.time > 0.0f) {
            this.draw(this.time - this.lastDrawTimeMSec);
        }
        this.lastDrawTimeMSec = this.time;
    }

    protected abstract void draw(float var1);

    @Override
    public void dispose() {
        for (Disposable disposable : this.disposables) {
            disposable.dispose();
        }
    }
}

