/*
 * Decompiled with CFR 0.152.
 */
package org.taongad.scene;

import com.badlogic.gdx.math.Rectangle;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.taongad.anim.drivers.DriverObserver;
import org.taongad.anim.drivers.LerpDriver;
import org.taongad.scene.Scene;
import org.taongad.scene.entities.Entity;
import org.taongad.scene.entities.FieldAnimator;

class FieldAnimationManager<T extends Entity> {
    private final Scene parent;
    List<Entity> entities;
    List<FieldAnimator<Entity>> entityAnimators;
    Random rng;

    public FieldAnimationManager(Scene parent, Rectangle field, int numObjects, float fadeInTimeMSec, float fadeOutTimeMSec, Class<T> classType, int seed) {
        this.parent = parent;
        this.rng = new Random(seed);
        this.createEntities(numObjects, classType, fadeInTimeMSec, fadeOutTimeMSec);
        this.createAnimators(field);
    }

    private void createAnimators(Rectangle field) {
        this.entityAnimators = new ArrayList<FieldAnimator<Entity>>();
        int i = 0;
        while (i < this.entities.size()) {
            this.entityAnimators.add(new FieldAnimator<Entity>(this.parent, this.parent.anim, this.entities.get(i), field, 0.3f, this.rng.nextInt()));
            ++i;
        }
    }

    private void createEntities(int numObjects, Class<T> classType, float fadeInTimeMSec, float fadeOutTimeMSec) {
        this.entities = new ArrayList<Entity>();
        Random rand = new Random(1L);
        int i = 0;
        while (i < numObjects) {
            try {
                final Entity entity = (Entity)classType.getConstructor(Scene.class, Float.TYPE).newInstance(this.parent, Float.valueOf(rand.nextFloat() * 15000.0f));
                float startTime = fadeInTimeMSec + rand.nextFloat() * 8000.0f;
                float fadeTime = 1500.0f;
                float showDuration = fadeOutTimeMSec - fadeInTimeMSec;
                LerpDriver driver = new LerpDriver(startTime, startTime + fadeTime, 0.0f, 0.9f);
                driver.registerObserver(new DriverObserver<Float>(){

                    @Override
                    public void publishValue(Float value) {
                        entity.setAlpha(value.floatValue());
                    }
                });
                this.parent.anim.addEvent(driver);
                startTime = startTime + fadeTime + showDuration;
                driver = new LerpDriver(startTime, startTime + fadeTime, 0.9f, 0.0f);
                driver.registerObserver(new DriverObserver<Float>(){

                    @Override
                    public void publishValue(Float value) {
                        entity.setAlpha(value.floatValue());
                    }
                });
                this.parent.anim.addEvent(driver);
                this.entities.add(entity);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public void play() {
        for (FieldAnimator<Entity> animator : this.entityAnimators) {
            animator.play();
        }
    }

    public void draw(float deltaTimeMSec) {
        for (Entity entity : this.entities) {
            entity.draw(this.parent.batch, deltaTimeMSec);
        }
    }
}

