/*
 * Decompiled with CFR 0.152.
 */
package org.taongad.scene;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.math.Vector2;
import java.util.Random;
import org.taongad.gfx.PixTexSprite;
import org.taongad.scene.StringTheoryScene;

public abstract class FallingScene
extends StringTheoryScene {
    PixTexSprite fallingObject;
    String fileName;
    LineAnimator lineAnimator;
    float rotation;

    public FallingScene(String fileName, float startTimeMSec) {
        super(startTimeMSec);
        this.fileName = fileName;
    }

    @Override
    public void load() {
        this.fallingObject = new PixTexSprite(this, Gdx.files.internal(this.fileName));
        this.fallingObject.drawPixToTex();
        this.lineAnimator = new LineAnimator(20);
    }

    @Override
    protected void draw(float deltaTimeMSec) {
        this.time += deltaTimeMSec;
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.batch.begin();
        this.bg.getPixmap().setColor(Color.BLACK);
        this.bg.getPixmap().fill();
        this.bg.getPixmap().setColor(Color.WHITE);
        this.lineAnimator.draw(this.bg.getPixmap(), deltaTimeMSec);
        this.bg.drawPixToTex();
        this.blitAndScaleBG();
        Sprite fallingSprite = this.fallingObject.getSprite();
        fallingSprite.setScale(5.0f);
        fallingSprite.setRotation(this.rotation);
        fallingSprite.setPosition(Gdx.graphics.getWidth() / 2 - this.fallingObject.getWidth() / 2, Gdx.graphics.getHeight() / 2 - this.fallingObject.getHeight() / 2);
        fallingSprite.draw(this.batch);
        this.batch.end();
    }

    class LineAnimator {
        Line[] lines;
        Random rng = new Random(123L);
        final int lineLenMin = 5;
        final int lineLenMax = 20;

        public LineAnimator(int numLines) {
            this.lines = new Line[numLines];
            this.init();
        }

        public void init() {
            int i = 0;
            while (i < this.lines.length) {
                this.lines[i] = new Line((int)(this.rng.nextFloat() * 204.0f), (int)(this.rng.nextFloat() * 152.0f), (int)(5.0f + this.rng.nextFloat() * 15.0f));
                ++i;
            }
        }

        public void draw(Pixmap drawTarget, float deltaTimeMSec) {
            int i = 0;
            while (i < this.lines.length) {
                this.lines[i].move(deltaTimeMSec);
                this.lines[i].draw(drawTarget);
                ++i;
            }
        }

        class Line {
            Vector2 pos;
            int len;
            final Vector2 SPEED_PER_FRAME = new Vector2(4.0f, -4.0f);
            static final float FRAME_TIME = 16.666666f;

            public Line(int x, int y, int len) {
                this.pos = new Vector2(x, y);
                this.len = len;
            }

            public void move(float deltaTimeMSec) {
                this.pos.add(this.SPEED_PER_FRAME.cpy().mul(deltaTimeMSec / 16.666666f));
                if (this.pos.x > 204.0f || this.pos.x < 0.0f || this.pos.y < 0.0f || this.pos.y > 152.0f) {
                    if (LineAnimator.this.rng.nextBoolean()) {
                        this.pos.x = (int)(LineAnimator.this.rng.nextFloat() * 204.0f);
                        this.pos.y = 152.0f;
                    } else {
                        this.pos.x = 0.0f;
                        this.pos.y = (int)(LineAnimator.this.rng.nextFloat() * 152.0f);
                    }
                    this.len = (int)(5.0f + LineAnimator.this.rng.nextFloat() * 15.0f);
                }
            }

            public void draw(Pixmap drawTarget) {
                drawTarget.drawLine((int)this.pos.x, (int)this.pos.y, (int)(this.pos.x + (float)this.len), (int)(this.pos.y - (float)this.len));
            }

            public int getX() {
                return (int)this.pos.x;
            }

            public int getY() {
                return (int)this.pos.x;
            }
        }
    }
}

