/*
 * Decompiled with CFR 0.152.
 */
package org.taongad.scene;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.taongad.anim.AnimationEvent;
import org.taongad.anim.AnimationSequence;
import org.taongad.anim.drivers.DriverObserver;
import org.taongad.gfx.PixTex;
import org.taongad.gfx.PixTexSprite;
import org.taongad.scene.StringTheoryScene;
import org.taongad.utils.ColorUtil;
import org.taongad.utils.DriverUtil;
import org.taongad.utils.FastMath;

public class EggScene
extends StringTheoryScene {
    float time;
    PixTex eggTex;
    PixTexSprite eggSprite;
    static final int tailWidth = 40;
    static final int tailHeight = 6;
    BitmapFont greetFont;
    int[] ySpawnPos = new int[]{40, 90, 54, 105};
    Egg[] eggs = new Egg[this.ySpawnPos.length * 3];
    List<String> greets = new ArrayList<String>();
    Random rng = new Random(1415L);

    public EggScene(float startTimeMSec) {
        super(startTimeMSec);
    }

    @Override
    public void load() {
        this.anim = new AnimationSequence();
        this.bg = new PixTex(this, 204, 152, Pixmap.Format.RGBA8888);
        this.eggTex = new PixTex(this, 40, 6, Pixmap.Format.RGBA8888);
        this.eggSprite = new PixTexSprite(this, Gdx.files.internal("gfx/sp_head.png"));
        FreeTypeFontGenerator generator = new FreeTypeFontGenerator(Gdx.files.internal("fonts/alien_encounters/Alien-Encounters-Regular.ttf"));
        this.greetFont = generator.generateFont(36);
        generator.dispose();
        this.disposables.add(this.greetFont);
        this.greets.add("JDW");
        this.greets.add("Velinje");
        this.greets.add("Lowebo");
        this.greets.add("OrreBorre");
        this.greets.add("PeterW");
        this.greets.add("Moa");
        this.greets.add("Atli");
        this.greets.add("Tomas");
        this.greets.add("Tommislav");
        this.greets.add("Simon S");
        this.greets.add("Dev");
        this.greets.add("Abbe");
        this.greets.add("Sara");
        this.greets.add("Shorti");
        this.greets.add("Zodiac");
        this.greets.add("Ollhax");
        this.greets.add("Marcus S");
        this.greets.add("Daniel R");
        this.greets.add("Mathias R");
        this.greets.add("Scenesat");
        this.greets.add("Ziphoid");
        this.greets.add("Sir Garbagetruck");
        this.greets.add("RadiantX");
        this.greets.add("Frost");
        this.greets.add("EDIS");
        this.greets.add("Whazzah");
        this.greets.add("Jolt");
        this.greets.add("Tulou");
        this.greets.add("Fairlight");
        this.greets.add("Candela");
        this.greets.add("Brandon Walsh");
        this.greets.add("Wiklund");
        this.greets.add("Pantaloon");
        this.greets.add("Pixelknights");
        this.greets.add("Ekoli");
        this.greets.add("Malmen");
        int i = 0;
        while (i < this.eggs.length) {
            this.eggs[i] = new Egg(i, false, this.greets.remove(0), this.ySpawnPos[i % this.ySpawnPos.length], (float)(i * 1800 + 0) + 1000.0f * this.rng.nextFloat());
            ++i;
        }
        this.time = 0.0f;
    }

    @Override
    protected void draw(float deltaTimeMSec) {
        this.time += deltaTimeMSec;
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.batch.begin();
        this.bg.clearPix();
        this.anim.update(deltaTimeMSec);
        int i = 0;
        while (i < this.eggs.length) {
            this.eggs[i].draw(deltaTimeMSec);
            ++i;
        }
        this.drawEggScene(false, "Greetings to:", 102.0f, 76.0f);
        this.bg.drawPixToTex();
        this.blitAndScaleBG();
        this.batch.end();
    }

    private void drawEggScene(boolean doTint, String greetTxt, float posX, float posY) {
        this.eggTex.getPixmap().setColor(Color.alpha(0.0f));
        this.eggTex.getPixmap().fill();
        float wave1 = FastMath.sin(this.time * 0.01f);
        float freq = 2.0f;
        float timeX = this.time * 0.01f / ((float)Math.PI * 2);
        float amp = 2.0f;
        int tailLen = 40;
        Color eggColor = doTint ? ColorUtil.createColorFromByteValues(30, 100, 100, 255) : ColorUtil.createColorFromByteValues(49, 226, 226, 255);
        int tailOffsY = -1;
        int tailOffsX = -3;
        int x = 0;
        while (x < tailLen) {
            float sinY = FastMath.sin(((float)x * freq / (float)tailLen + timeX) * ((float)Math.PI * 2));
            float scale = 1.0f - (float)(tailLen - x) / (float)tailLen * 0.9f;
            int yPos = (int)((float)(this.eggTex.getHeight() / 2) + (sinY *= scale) * amp);
            this.eggTex.getPixmap().setColor(eggColor.r, eggColor.g, eggColor.b, scale);
            this.eggTex.getPixmap().drawPixel(x, yPos);
            ++x;
        }
        float scale = 5.0f;
        this.bg.getPixmap().drawPixmap(this.eggTex.getPixmap(), (int)(posX - (float)this.eggTex.getWidth() + (float)tailOffsX), (int)(posY - (float)(this.eggTex.getHeight() / 2) + (float)tailOffsY));
        this.eggSprite.getSprite().setScale(4.0f);
        this.eggSprite.getSprite().setRotation(-90.0f + 20.0f * wave1);
        this.eggSprite.getSprite().setOrigin(6.0f, 6.0f);
        this.eggSprite.getSprite().setPosition(posX * scale, (float)Gdx.graphics.getHeight() - posY * scale);
        if (doTint) {
            this.eggSprite.getSprite().setColor(Color.GRAY);
        } else {
            this.eggSprite.getSprite().setColor(Color.WHITE);
        }
        this.eggSprite.getSprite().draw(this.batch);
        BitmapFont.TextBounds bounds = this.greetFont.getBounds(greetTxt);
        this.greetFont.draw(this.batch, greetTxt, posX * scale - bounds.width / 2.0f + 15.0f, (float)Gdx.graphics.getHeight() - (posY * scale - bounds.height / 2.0f) + 55.0f);
    }

    class Egg
    implements AnimationEvent.OnCompletedListener {
        String txt;
        Vector2 pos;
        boolean doTint;
        String greetTxt;
        float posX = -40.0f;
        float posY;
        final float duration = 10000.0f;
        int slot;
        float time;

        public Egg(int slot, boolean doTint, String greetTxt, float posY, float startTime) {
            this.slot = slot;
            this.doTint = doTint;
            this.greetTxt = greetTxt;
            this.posY = posY;
            DriverUtil.setupLerpObserver(EggScene.this.anim, this, startTime, startTime + 10000.0f, 204.0f, -40.0f, new DriverObserver<Float>(){

                @Override
                public void publishValue(Float value) {
                    Egg.this.posX = value.floatValue();
                }
            });
        }

        public void draw(float deltaTimeMSec) {
            this.time += deltaTimeMSec;
            EggScene.this.eggTex.getPixmap().setColor(Color.alpha(0.0f));
            EggScene.this.eggTex.getPixmap().fill();
            float wave1 = FastMath.sin(this.time * 0.01f);
            float freq = 2.0f;
            float timeX = this.time * 0.01f / ((float)Math.PI * 2);
            float amp = 2.0f;
            int tailLen = 40;
            Color eggColor = this.doTint ? ColorUtil.createColorFromByteValues(30, 100, 100, 255) : ColorUtil.createColorFromByteValues(49, 226, 226, 255);
            int tailOffsY = -1;
            int tailOffsX = -3;
            int x = 0;
            while (x < tailLen) {
                float sinY = FastMath.sin(((float)x * freq / (float)tailLen + timeX) * ((float)Math.PI * 2));
                float scale = 1.0f - (float)(tailLen - x) / (float)tailLen * 0.9f;
                int yPos = (int)((float)(EggScene.this.eggTex.getHeight() / 2) + (sinY *= scale) * amp);
                EggScene.this.eggTex.getPixmap().setColor(eggColor.r, eggColor.g, eggColor.b, scale);
                EggScene.this.eggTex.getPixmap().drawPixel(x, yPos);
                ++x;
            }
            float scale = 5.0f;
            EggScene.this.bg.getPixmap().drawPixmap(EggScene.this.eggTex.getPixmap(), (int)(this.posX - (float)EggScene.this.eggTex.getWidth() + (float)tailOffsX), (int)(this.posY - (float)(EggScene.this.eggTex.getHeight() / 2) + (float)tailOffsY));
            EggScene.this.eggSprite.getSprite().setScale(4.0f);
            EggScene.this.eggSprite.getSprite().setRotation(-90.0f + 20.0f * wave1);
            EggScene.this.eggSprite.getSprite().setOrigin(6.0f, 6.0f);
            EggScene.this.eggSprite.getSprite().setPosition(this.posX * scale, (float)Gdx.graphics.getHeight() - this.posY * scale);
            if (this.doTint) {
                EggScene.this.eggSprite.getSprite().setColor(Color.GRAY);
            } else {
                EggScene.this.eggSprite.getSprite().setColor(Color.WHITE);
            }
            EggScene.this.eggSprite.getSprite().draw(EggScene.this.batch);
            BitmapFont.TextBounds bounds = EggScene.this.greetFont.getBounds(this.greetTxt);
            EggScene.this.greetFont.draw(EggScene.this.batch, this.greetTxt, this.posX * scale - bounds.width / 2.0f + 15.0f, (float)Gdx.graphics.getHeight() - (this.posY * scale - bounds.height / 2.0f) + 55.0f);
        }

        @Override
        public void onCompleted(float completedTime) {
            if (EggScene.this.greets.size() > 0) {
                String greeting = EggScene.this.greets.remove(0);
                EggScene.this.eggs[this.slot] = new Egg(this.slot, this.doTint, greeting, EggScene.this.ySpawnPos[this.slot % EggScene.this.ySpawnPos.length], completedTime + 2000.0f + 0.0f * EggScene.this.rng.nextFloat());
            }
        }
    }
}

