/*
 * Decompiled with CFR 0.152.
 */
package org.taongad.scene;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Sprite;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.taongad.anim.AnimationEvent;
import org.taongad.anim.AnimationSequence;
import org.taongad.anim.drivers.DriverObserver;
import org.taongad.gfx.PixTexSprite;
import org.taongad.scene.StringTheoryScene;
import org.taongad.scene.entities.Explosion;
import org.taongad.scene.entities.Tank;
import org.taongad.utils.ColorUtil;
import org.taongad.utils.DriverUtil;

public class CityScene
extends StringTheoryScene {
    PixTexSprite plant;
    PixTexSprite bush;
    PixTexSprite hut;
    PixTexSprite city;
    PixTexSprite djungle;
    PixTexSprite road;
    Explosion explosion;
    List<PixTexSprite> huts = new ArrayList<PixTexSprite>();
    List<Tank> tanks = new ArrayList<Tank>();
    float scrollOffs;
    float endOffs = 3876.0f;
    float skyColorFactor = 1.0f;
    float groundColorFactor = 1.0f;
    Color skyForestColor = new Color(0.0f, 0.6f, 0.9f, 1.0f);
    Color skyCityColor = ColorUtil.createColorFromByteValues(65, 65, 104, 255);
    Color skyColor = this.skyForestColor;
    Color forestColor = ColorUtil.createColorFromByteValues(165, 120, 9, 255);
    Color cityColor = Color.GRAY;
    Color groundColor = this.forestColor.cpy();
    Random rng = new Random(5151L);
    Random hutRNG = new Random(5151L);
    float bombPosX = -30.0f;
    float bombPosY = -30.0f;

    public CityScene(float startTimeMSec) {
        super(startTimeMSec);
    }

    @Override
    public void load() {
        this.anim = new AnimationSequence();
        this.huts.add(new PixTexSprite(this, Gdx.files.internal("gfx/by/hydda bakifr\u00e5n.png")));
        this.huts.add(new PixTexSprite(this, Gdx.files.internal("gfx/by/hydda framifr\u00e5n.png")));
        this.huts.add(new PixTexSprite(this, Gdx.files.internal("gfx/by/hydda fr\u00e5n sidan1.png")));
        this.huts.add(new PixTexSprite(this, Gdx.files.internal("gfx/by/hydda fr\u00e5n sidan2.png")));
        this.road = new PixTexSprite(this, Gdx.files.internal("gfx/stad/v\u00e4g.png"));
        this.road.drawPixToTex();
        this.explosion = new Explosion(this, 0.0f);
        this.plant = new PixTexSprite(this, Gdx.files.internal("gfx/Vegetation/gr\u00e4stuva.png"));
        this.plant.drawPixToTex();
        this.hut = new PixTexSprite(this, Gdx.files.internal("gfx/Vegetation/kaktus.png"));
        this.hut.drawPixToTex();
        this.bush = new PixTexSprite(this, Gdx.files.internal("gfx/Vegetation/buske.png"));
        this.bush.drawPixToTex();
        this.city = new PixTexSprite(this, Gdx.files.internal("gfx/stad/stad.png"));
        this.city.drawPixToTex();
        this.djungle = new PixTexSprite(this, Gdx.files.internal("gfx/djungel/heldjungel.png"));
        this.djungle.drawPixToTex();
        this.tanks.add(new Tank(this, 0.0f));
        this.tanks.add(new Tank(this, 0.0f));
        this.tanks.add(new Tank(this, 0.0f));
        this.tanks.add(new Tank(this, 0.0f));
        this.tanks.add(new Tank(this, 0.0f));
        float scrollTime = 35000.0f;
        DriverUtil.setupLerpObserver(this.anim, 0.0f, scrollTime, 0.0f, -this.endOffs, new DriverObserver<Float>(){

            @Override
            public void publishValue(Float value) {
                CityScene.this.scrollOffs = value.floatValue();
            }
        });
        DriverUtil.setupLerpObserver(this.anim, 0.0f, scrollTime, 1.0f, 0.0f, new DriverObserver<Float>(){

            @Override
            public void publishValue(Float value) {
                CityScene.this.skyColorFactor = value.floatValue();
            }
        });
        DriverUtil.setupLerpObserver(this.anim, new AnimationEvent.OnCompletedListener(){

            @Override
            public void onCompleted(float completedTime) {
                CityScene.this.setupTanks(completedTime);
            }
        }, 9500.0f, 13000.0f, 1.0f, 0.0f, new DriverObserver<Float>(){

            @Override
            public void publishValue(Float value) {
                CityScene.this.groundColor = ColorUtil.lerpColors(CityScene.this.forestColor, CityScene.this.cityColor, value.floatValue());
                CityScene.this.skyColor = ColorUtil.lerpColors(CityScene.this.skyForestColor, CityScene.this.skyCityColor, value.floatValue());
            }
        });
    }

    private void setupBomb(float startTime) {
        this.bombPosX = this.rng.nextFloat() * (float)Gdx.graphics.getWidth() * 5.0f;
        this.explosion = new Explosion(this, 0.0f);
        this.explosion.setPosition(this.bombPosX + this.scrollOffs, 320.0f);
        DriverUtil.setupLerpObserver(this.anim, new AnimationEvent.OnCompletedListener(){

            @Override
            public void onCompleted(float completedTime) {
                CityScene.this.setupBomb(completedTime + 500.0f);
            }
        }, startTime, startTime + this.explosion.getMaxLoopTime(), 1.0f, 0.0f, new DriverObserver<Float>(){

            @Override
            public void publishValue(Float value) {
                CityScene.this.explosion.setPosition(CityScene.this.bombPosX + CityScene.this.scrollOffs / 5.0f, 320.0f);
            }
        });
    }

    private void setupTanks(float startTime) {
        float endTime = startTime + 30000.0f;
        DriverUtil.setupLerpObserver(this.anim, startTime, endTime, 2800.0f, 420.0f, new DriverObserver<Float>(){

            @Override
            public void publishValue(Float value) {
                float xPos = -(value.floatValue() / 4.0f) - CityScene.this.scrollOffs / 3.0f;
                int i = 0;
                while (i < CityScene.this.tanks.size()) {
                    CityScene.this.tanks.get(i).setPosition(xPos + (CityScene.this.tanks.get(0).getWidth() - 50.0f) * 300.0f * (float)i, Gdx.graphics.getHeight() / 2 - 45);
                    ++i;
                }
            }
        });
    }

    @Override
    protected void draw(float deltaTimeMSec) {
        this.time += deltaTimeMSec;
        this.anim.update(deltaTimeMSec);
        Gdx.gl.glClearColor(this.skyColor.r, this.skyColor.g, this.skyColor.b, 1.0f);
        Gdx.gl.glClear(16384);
        this.batch.begin();
        Color drawColor = this.groundColor;
        this.bg.getPixmap().setColor(drawColor);
        this.bg.getPixmap().fillRectangle(0, 76, 204, 152);
        this.bg.drawPixToTex();
        this.blitAndScaleBG();
        int horizon1 = 76;
        int horizon2 = 75;
        float scale1 = Gdx.graphics.getWidth() / 204;
        float startPos = this.endOffs / scale1;
        this.drawSprite(this.city, startPos + 0.0f, horizon1, scale1);
        this.drawSprite(this.city, startPos + (float)this.city.getWidth(), horizon1, scale1);
        this.drawSprite(this.city, startPos + (float)(this.city.getWidth() * 2), horizon1, scale1);
        float offset = -0.0f;
        float scale2 = 3.0f;
        this.drawSprite(this.city, startPos + offset, (float)horizon2 * (scale1 / scale2), scale2);
        this.drawSprite(this.city, startPos + (float)this.city.getWidth() + offset, (float)horizon2 * (scale1 / scale2), scale2);
        this.drawSprite(this.city, startPos + (float)(this.city.getWidth() * 2) + offset, (float)horizon2 * (scale1 / scale2), scale2);
        this.drawSprite(this.djungle, 0.0f, horizon1, scale1);
        this.drawSprite(this.djungle, this.djungle.getWidth(), horizon1, scale1);
        this.drawSprite(this.djungle, this.djungle.getWidth() * 2, horizon1, scale1);
        float djungleStart = 0.0f;
        int horizon3 = horizon2 - 4;
        float forestOffsX = -20.0f;
        this.drawSprite(this.djungle, djungleStart, horizon3, scale1);
        this.drawSprite(this.djungle, djungleStart + ((float)this.djungle.getWidth() + forestOffsX) * 1.0f, horizon3, scale1);
        this.drawSprite(this.djungle, djungleStart + ((float)this.djungle.getWidth() + forestOffsX) * 2.0f, horizon3, scale1);
        this.drawSprite(this.djungle, djungleStart + ((float)this.djungle.getWidth() + forestOffsX) * 3.0f, horizon3, scale1);
        int i = 0;
        while (i < 3) {
            this.drawSprite(this.road, 500 + this.road.getWidth() * i, 76 - this.road.getHeight(), scale1);
            ++i;
        }
        this.rng = new Random(5151L);
        this.drawRandomPos(this.bush, 20, 0.0f, 440.0f);
        this.drawRandomPos(this.bush, 10, 50.0f, 440.0f);
        this.rng = new Random(5159L);
        this.drawRandomPos(this.bush, 10, 160.0f, 440.0f);
        this.rng = new Random(5153L);
        this.drawRandomPos(this.plant, 10, 0.0f, 470.0f);
        this.rng = new Random(5157L);
        this.hutRNG = new Random(5157L);
        this.drawRandomHutPos(8, 0.0f, 520.0f);
        i = 0;
        while (i < this.tanks.size()) {
            this.tanks.get(i).draw(this.batch, deltaTimeMSec);
            ++i;
        }
        this.batch.end();
    }

    private void drawRandomPos(PixTexSprite sprite, int count, float minX, float maxX) {
        float minY = 0.0f;
        float maxY = 120.0f;
        int i = 0;
        while (i < count) {
            this.drawSprite(sprite, minX + this.rng.nextFloat() * maxX, minY + this.rng.nextFloat() * maxY, 3.0f);
            ++i;
        }
    }

    private void drawRandomHutPos(int count, float minX, float maxX) {
        float minY = 10.0f;
        float maxY = 80.0f;
        int i = 0;
        while (i < count) {
            this.drawSprite(this.huts.get((int)(this.hutRNG.nextFloat() * (float)(this.huts.size() - 1))), minX + this.rng.nextFloat() * maxX, minY + this.rng.nextFloat() * maxY, 4.0f);
            ++i;
        }
    }

    private void drawSprite(PixTexSprite sprite, float x, float y, float scale) {
        Sprite mySprite = sprite.getSprite();
        mySprite.setScale(scale);
        mySprite.setOrigin(mySprite.getWidth() / 2.0f, 2.0f);
        mySprite.setPosition(this.scrollOffs + x * mySprite.getScaleX(), y * mySprite.getScaleX());
        mySprite.draw(this.batch, 1.0f);
    }
}

