/*
 * Decompiled with CFR 0.152.
 */
package org.taongad.gfx;

import com.badlogic.gdx.graphics.g2d.Sprite;

public class SpriteAnimation {
    float time;
    Sprite[] frames;
    int currFrameIdx;
    float frameTime;
    boolean looping = true;
    boolean isDone = false;

    public SpriteAnimation(Sprite[] frames, float frameTime, float timeOffset, boolean looping) {
        this.frames = frames;
        this.frameTime = frameTime;
        this.time = timeOffset;
        this.looping = looping;
    }

    public float getMaxLoopTime() {
        return this.frameTime * (float)this.frames.length;
    }

    public float getRemainingLoopTime() {
        float maxTime = this.frameTime * (float)this.frames.length;
        return maxTime - this.time % maxTime;
    }

    public Sprite getCurrentFrame() {
        Sprite currentFrame = this.frames[(int)(this.time / this.frameTime)];
        return currentFrame;
    }

    public boolean isDone() {
        return this.isDone;
    }

    public void update(float deltaTimeMSec) {
        this.time += deltaTimeMSec;
        if (this.looping) {
            this.time %= (float)this.frames.length * this.frameTime;
        } else if (this.time > (float)this.frames.length * this.frameTime) {
            this.isDone = true;
            this.time = (float)this.frames.length * this.frameTime - 1.0f;
        } else {
            this.time %= (float)this.frames.length * this.frameTime;
        }
    }
}

