/*
 * Decompiled with CFR 0.152.
 */
package org.taongad.anim;

import java.util.ArrayList;
import java.util.List;
import org.taongad.anim.AnimationEvent;
import org.taongad.anim.AnimationEventFactory;
import org.taongad.anim.DrawableAnimationEvent;

public class Metronome {
    final float intervalMSec;
    final AnimationEventFactory<? extends AnimationEvent> eventFactory;
    float startTime;
    float stopTime;
    float totalRunningTime = 0.0f;
    float iterationTime;
    List<AnimationEvent> ongoingEvents = new ArrayList<AnimationEvent>();
    float lastUpdateTimeMSec = 0.0f;

    public Metronome(float intervalMSec, AnimationEventFactory<? extends AnimationEvent> eventFactory) {
        this.intervalMSec = intervalMSec;
        this.eventFactory = eventFactory;
    }

    public void start(float startTime, float stopTime) {
        this.stopTime = stopTime;
        this.start(startTime);
    }

    public void start(float startTime) {
        this.startTime = startTime;
        this.iterationTime = 0.0f;
        this.totalRunningTime = 0.0f;
    }

    public void update(float musicTimeMSec) {
        if (musicTimeMSec >= this.startTime && this.stopTime != 0.0f && musicTimeMSec <= this.stopTime) {
            if (this.lastUpdateTimeMSec == 0.0f) {
                this.lastUpdateTimeMSec = musicTimeMSec;
            }
            this.iterationTime += musicTimeMSec - this.lastUpdateTimeMSec;
            float deltaTime = this.iterationTime;
            if (this.iterationTime >= this.intervalMSec) {
                this.iterationTime -= this.intervalMSec;
                this.ongoingEvents.add(this.eventFactory.createAndStartEvent());
            }
            int i = 0;
            while (i < this.ongoingEvents.size()) {
                AnimationEvent ongoingEvent = this.ongoingEvents.get(i);
                if (ongoingEvent.isDone(musicTimeMSec)) {
                    if (ongoingEvent.runningTime < ongoingEvent.endTime) {
                        ongoingEvent.update(ongoingEvent.endTime - ongoingEvent.runningTime);
                    }
                    ongoingEvent = this.ongoingEvents.remove(i);
                } else {
                    ongoingEvent.update(deltaTime);
                }
                ++i;
            }
            this.lastUpdateTimeMSec = musicTimeMSec;
        }
    }

    public void draw() {
        for (AnimationEvent ongoingEvent : this.ongoingEvents) {
            if (!(ongoingEvent instanceof DrawableAnimationEvent)) continue;
            ((DrawableAnimationEvent)ongoingEvent).draw();
        }
    }
}

