/*
 * Decompiled with CFR 0.152.
 */
package org.taongad.anim;

import java.util.ArrayList;
import java.util.List;
import org.taongad.anim.AnimationEvent;
import org.taongad.anim.DrawableAnimationEvent;
import org.taongad.anim.drivers.Driver;

public class AnimationSequence {
    float totalRunningTime = 0.0f;
    List<AnimationEvent> plannedEvents = new ArrayList<AnimationEvent>();
    List<AnimationEvent> ongoingEvents = new ArrayList<AnimationEvent>();

    public float getTotalRunningTime() {
        return this.totalRunningTime;
    }

    public void addEvent(AnimationEvent event) {
        this.plannedEvents.add(event);
    }

    public void update(float sceneTimeMSec) {
        this.totalRunningTime += sceneTimeMSec;
        int i = 0;
        while (i < this.plannedEvents.size()) {
            AnimationEvent plannedEvent = this.plannedEvents.get(i);
            if (plannedEvent.isStarting(this.totalRunningTime)) {
                this.ongoingEvents.add(this.plannedEvents.remove(i));
            }
            ++i;
        }
        i = 0;
        while (i < this.ongoingEvents.size()) {
            AnimationEvent ongoingEvent = this.ongoingEvents.get(i);
            if (ongoingEvent.isDone(this.totalRunningTime)) {
                this.updateAndNotify(ongoingEvent, ongoingEvent.runningTime);
                ongoingEvent = this.ongoingEvents.remove(i);
                ongoingEvent.dispose();
            } else {
                float delta = this.totalRunningTime - ongoingEvent.startTime;
                this.updateAndNotify(ongoingEvent, delta > ongoingEvent.runningTime ? ongoingEvent.runningTime : delta);
            }
            ++i;
        }
    }

    private void updateAndNotify(AnimationEvent ongoingEvent, float time) {
        ongoingEvent.update(time);
        if (ongoingEvent instanceof Driver) {
            ((Driver)ongoingEvent).notifyAllObservers();
        }
    }

    public void draw() {
        for (AnimationEvent ongoingEvent : this.ongoingEvents) {
            if (!(ongoingEvent instanceof DrawableAnimationEvent)) continue;
            ((DrawableAnimationEvent)ongoingEvent).draw();
        }
    }
}

