/*
 * Decompiled with CFR 0.152.
 */
package com.bitfire.utils;

public final class Hash {
    private Hash() {
    }

    public static long RSHash(String str) {
        int b = 378551;
        int a = 63689;
        long hash = 0L;
        int i = 0;
        while (i < str.length()) {
            hash = hash * (long)a + (long)str.charAt(i);
            a *= b;
            ++i;
        }
        return hash;
    }

    public static long JSHash(String str) {
        long hash = 1315423911L;
        int i = 0;
        while (i < str.length()) {
            hash ^= (hash << 5) + (long)str.charAt(i) + (hash >> 2);
            ++i;
        }
        return hash;
    }

    public static long PJWHash(String str) {
        long BitsInUnsignedInt = 32L;
        long ThreeQuarters = BitsInUnsignedInt * 3L / 4L;
        long OneEighth = BitsInUnsignedInt / 8L;
        long HighBits = -1L << (int)(BitsInUnsignedInt - OneEighth);
        long hash = 0L;
        long test = 0L;
        int i = 0;
        while (i < str.length()) {
            test = (hash = (hash << (int)OneEighth) + (long)str.charAt(i)) & HighBits;
            if (test != 0L) {
                hash = (hash ^ test >> (int)ThreeQuarters) & (HighBits ^ 0xFFFFFFFFFFFFFFFFL);
            }
            ++i;
        }
        return hash;
    }

    public static long ELFHash(String str) {
        long hash = 0L;
        long x = 0L;
        int i = 0;
        while (i < str.length()) {
            x = (hash = (hash << 4) + (long)str.charAt(i)) & 0xF0000000L;
            if (x != 0L) {
                hash ^= x >> 24;
            }
            hash &= x ^ 0xFFFFFFFFFFFFFFFFL;
            ++i;
        }
        return hash;
    }

    public static long BKDRHash(String str) {
        long seed = 131L;
        long hash = 0L;
        int i = 0;
        while (i < str.length()) {
            hash = hash * seed + (long)str.charAt(i);
            ++i;
        }
        return hash;
    }

    public static long SDBMHash(String str) {
        long hash = 0L;
        int i = 0;
        while (i < str.length()) {
            hash = (long)str.charAt(i) + (hash << 6) + (hash << 16) - hash;
            ++i;
        }
        return hash;
    }

    public static long DJBHash(String str) {
        long hash = 5381L;
        int i = 0;
        while (i < str.length()) {
            hash = (hash << 5) + hash + (long)str.charAt(i);
            ++i;
        }
        return hash;
    }

    public static long DEKHash(String str) {
        long hash = str.length();
        int i = 0;
        while (i < str.length()) {
            hash = hash << 5 ^ hash >> 27 ^ (long)str.charAt(i);
            ++i;
        }
        return hash;
    }

    public static long BPHash(String str) {
        long hash = 0L;
        int i = 0;
        while (i < str.length()) {
            hash = hash << 7 ^ (long)str.charAt(i);
            ++i;
        }
        return hash;
    }

    public static long FNVHash(String str) {
        long fnv_prime = -2128831035L;
        long hash = 0L;
        int i = 0;
        while (i < str.length()) {
            hash *= fnv_prime;
            hash ^= (long)str.charAt(i);
            ++i;
        }
        return hash;
    }

    public static long APHash(String str) {
        long hash = -1431655766L;
        int i = 0;
        while (i < str.length()) {
            hash = (i & 1) == 0 ? (hash ^= hash << 7 ^ (long)str.charAt(i) * (hash >> 3)) : (hash ^= (hash << 11) + (long)str.charAt(i) ^ hash >> 5 ^ 0xFFFFFFFFFFFFFFFFL);
            ++i;
        }
        return hash;
    }
}

