/*
 * Decompiled with CFR 0.152.
 */
package com.bitfire.postprocessing.filters;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Vector3;
import com.bitfire.postprocessing.filters.Filter;
import com.bitfire.utils.ShaderLoader;

public final class CrtScreen
extends Filter<CrtScreen> {
    private float elapsedSecs;
    private float offset;
    private float zoom;
    private final Vector3 vtint;
    private final Color tint;
    private float distortion;
    private boolean dodistortion;

    public CrtScreen(boolean barrelDistortion) {
        super(ShaderLoader.fromFile("screenspace", "crt-screen", barrelDistortion ? "#define ENABLE_BARREL_DISTORTION" : ""));
        this.dodistortion = barrelDistortion;
        this.vtint = new Vector3();
        this.tint = new Color();
        this.rebind();
        this.setTime(0.0f);
        this.setTint(0.8f, 1.0f, 0.7f);
        this.setDistortion(0.3f);
        this.setZoom(1.0f);
        this.setColorOffset(0.003f);
    }

    public void setTime(float elapsedSecs) {
        this.elapsedSecs = elapsedSecs;
        this.setParam((Filter.Parameter)Param.Time, elapsedSecs);
    }

    public void setColorOffset(float offset) {
        this.offset = offset;
        this.setParam((Filter.Parameter)Param.ColorOffset, this.offset);
    }

    public void setTint(Color color) {
        this.tint.set(color);
        this.vtint.set(this.tint.r, this.tint.g, this.tint.b);
        this.setParam((Filter.Parameter)Param.Tint, this.vtint);
    }

    public void setTint(float r, float g, float b) {
        this.tint.set(r, g, b, 1.0f);
        this.vtint.set(this.tint.r, this.tint.g, this.tint.b);
        this.setParam((Filter.Parameter)Param.Tint, this.vtint);
    }

    public void setDistortion(float distortion) {
        this.distortion = distortion;
        if (this.dodistortion) {
            this.setParam((Filter.Parameter)Param.Distortion, this.distortion);
        }
    }

    public void setZoom(float zoom) {
        this.zoom = zoom;
        if (this.dodistortion) {
            this.setParam((Filter.Parameter)Param.Zoom, this.zoom);
        }
    }

    public float getOffset() {
        return this.offset;
    }

    public float getZoom() {
        return this.zoom;
    }

    public Color getTint() {
        return this.tint;
    }

    @Override
    protected void onBeforeRender() {
        this.inputTexture.bind(0);
    }

    @Override
    public void rebind() {
        this.setParams((Filter.Parameter)Param.Texture0, 0);
        this.setParams((Filter.Parameter)Param.Time, this.elapsedSecs);
        this.setParams((Filter.Parameter)Param.ColorOffset, this.offset);
        this.vtint.set(this.tint.r, this.tint.g, this.tint.b);
        this.setParams((Filter.Parameter)Param.Tint, this.vtint);
        if (this.dodistortion) {
            this.setParams((Filter.Parameter)Param.Distortion, this.distortion);
            this.setParams((Filter.Parameter)Param.Zoom, this.zoom);
        }
        this.endParams();
    }

    public static enum Param implements Filter.Parameter
    {
        Texture0("u_texture0", 0),
        Time("time", 0),
        Tint("tint", 3),
        ColorOffset("offset", 0),
        Distortion("Distortion", 0),
        Zoom("zoom", 0);

        private final String mnemonic;
        private int elementSize;

        private Param(String m, int elementSize) {
            this.mnemonic = m;
            this.elementSize = elementSize;
        }

        @Override
        public String mnemonic() {
            return this.mnemonic;
        }

        @Override
        public int arrayElementSize() {
            return this.elementSize;
        }
    }
}

