/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.OrderedMap;
import com.badlogic.gdx.utils.SerializationException;
import com.badlogic.gdx.utils.StringBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class JsonReader {
    private static final byte[] _json_actions = JsonReader.init__json_actions_0();
    private static final short[] _json_key_offsets = JsonReader.init__json_key_offsets_0();
    private static final char[] _json_trans_keys = JsonReader.init__json_trans_keys_0();
    private static final byte[] _json_single_lengths = JsonReader.init__json_single_lengths_0();
    private static final byte[] _json_range_lengths = JsonReader.init__json_range_lengths_0();
    private static final short[] _json_index_offsets = JsonReader.init__json_index_offsets_0();
    private static final byte[] _json_trans_targs = JsonReader.init__json_trans_targs_0();
    private static final byte[] _json_trans_actions = JsonReader.init__json_trans_actions_0();
    private static final byte[] _json_eof_actions = JsonReader.init__json_eof_actions_0();
    static final int json_start = 1;
    static final int json_first_final = 76;
    static final int json_error = 0;
    static final int json_en_object = 9;
    static final int json_en_array = 49;
    static final int json_en_main = 1;
    private final Array elements = new Array(8);
    private Object root;
    private Object current;

    public Object parse(String json) {
        char[] data = json.toCharArray();
        return this.parse(data, 0, data.length);
    }

    public Object parse(Reader reader) {
        try {
            int length;
            char[] data = new char[1024];
            int offset = 0;
            while ((length = reader.read(data, offset, data.length - offset)) != -1) {
                if (length == 0) {
                    char[] newData = new char[data.length * 2];
                    System.arraycopy(data, 0, newData, 0, data.length);
                    data = newData;
                    continue;
                }
                offset += length;
            }
            Object object = this.parse(data, 0, offset);
            return object;
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ignored) {}
        }
    }

    public Object parse(InputStream input) {
        try {
            return this.parse(new InputStreamReader(input, "ISO-8859-1"));
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
    }

    public Object parse(FileHandle file) {
        try {
            return this.parse(file.read());
        }
        catch (Exception ex) {
            throw new SerializationException("Error parsing file: " + file, ex);
        }
    }

    /*
     * Unable to fully structure code
     */
    public Object parse(char[] data, int offset, int length) {
        p = offset;
        eof = pe = length;
        top = 0;
        stack = new int[4];
        s = 0;
        names = new Array<String>(8);
        needsUnescape = false;
        discardBuffer = false;
        parseRuntimeEx = null;
        debug = false;
        if (debug) {
            System.out.println();
        }
        try {
            cs = 1;
            top = 0;
            _trans = 0;
            _goto_targ = 0;
            block29: while (true) {
                switch (_goto_targ) {
                    case 0: {
                        if (p == pe) {
                            _goto_targ = 4;
                            continue block29;
                        }
                        if (cs == 0) {
                            _goto_targ = 5;
                            continue block29;
                        }
                    }
                    case 1: {
                        _keys = JsonReader._json_key_offsets[cs];
                        _trans = JsonReader._json_index_offsets[cs];
                        _klen = JsonReader._json_single_lengths[cs];
                        if (_klen <= 0) ** GOTO lbl46
                        _lower = _keys;
                        _upper = _keys + _klen - 1;
                        while (_upper >= _lower) {
                            _mid = _lower + (_upper - _lower >> 1);
                            if (data[p] < JsonReader._json_trans_keys[_mid]) {
                                _upper = _mid - 1;
                                continue;
                            }
                            if (data[p] > JsonReader._json_trans_keys[_mid]) {
                                _lower = _mid + 1;
                                continue;
                            }
                            _trans += _mid - _keys;
                            ** GOTO lbl60
                        }
                        _keys += _klen;
                        _trans += _klen;
lbl46:
                        // 2 sources

                        if ((_klen = JsonReader._json_range_lengths[cs]) > 0) {
                            _lower = _keys;
                            _upper = _keys + (_klen << 1) - 2;
                            while (_upper >= _lower) {
                                _mid = _lower + (_upper - _lower >> 1 & -2);
                                if (data[p] < JsonReader._json_trans_keys[_mid]) {
                                    _upper = _mid - 2;
                                    continue;
                                }
                                if (data[p] > JsonReader._json_trans_keys[_mid + 1]) {
                                    _lower = _mid + 2;
                                    continue;
                                }
                                _trans += _mid - _keys >> 1;
                                ** GOTO lbl60
                            }
                            _trans += _klen;
                        }
lbl60:
                        // 5 sources

                        cs = JsonReader._json_trans_targs[_trans];
                        if (JsonReader._json_trans_actions[_trans] != 0) {
                            _acts = JsonReader._json_trans_actions[_trans];
                            _nacts = JsonReader._json_actions[_acts++];
                            while (_nacts-- > 0) {
                                switch (JsonReader._json_actions[_acts++]) {
                                    case 0: {
                                        s = p;
                                        needsUnescape = false;
                                        discardBuffer = false;
                                        break;
                                    }
                                    case 1: {
                                        needsUnescape = true;
                                        break;
                                    }
                                    case 2: {
                                        name = new String(data, s, p - s);
                                        s = p;
                                        if (needsUnescape) {
                                            name = this.unescape(name);
                                        }
                                        if (debug) {
                                            System.out.println("name: " + name);
                                        }
                                        names.add(name);
                                        break;
                                    }
                                    case 3: {
                                        if (discardBuffer) break;
                                        value = new String(data, s, p - s);
                                        s = p;
                                        if (needsUnescape) {
                                            value = this.unescape(value);
                                        }
                                        v0 = name = names.size > 0 ? (String)names.pop() : null;
                                        if (debug) {
                                            System.out.println("string: " + name + "=" + value);
                                        }
                                        this.string(name, value);
                                        break;
                                    }
                                    case 4: {
                                        value = new String(data, s, p - s);
                                        s = p;
                                        v1 = name = names.size > 0 ? (String)names.pop() : null;
                                        if (debug) {
                                            System.out.println("number: " + name + "=" + Float.parseFloat(value));
                                        }
                                        this.number(name, Float.parseFloat(value));
                                        break;
                                    }
                                    case 5: {
                                        v2 = name = names.size > 0 ? (String)names.pop() : null;
                                        if (debug) {
                                            System.out.println("boolean: " + name + "=true");
                                        }
                                        this.bool(name, true);
                                        discardBuffer = true;
                                        break;
                                    }
                                    case 6: {
                                        v3 = name = names.size > 0 ? (String)names.pop() : null;
                                        if (debug) {
                                            System.out.println("boolean: " + name + "=false");
                                        }
                                        this.bool(name, false);
                                        discardBuffer = true;
                                        break;
                                    }
                                    case 7: {
                                        v4 = name = names.size > 0 ? (String)names.pop() : null;
                                        if (debug) {
                                            System.out.println("null: " + name);
                                        }
                                        this.string(name, null);
                                        discardBuffer = true;
                                        break;
                                    }
                                    case 8: {
                                        v5 = name = names.size > 0 ? (String)names.pop() : null;
                                        if (debug) {
                                            System.out.println("startObject: " + name);
                                        }
                                        this.startObject(name);
                                        if (top == stack.length) {
                                            newStack = new int[stack.length * 2];
                                            System.arraycopy(stack, 0, newStack, 0, stack.length);
                                            stack = newStack;
                                        }
                                        stack[top++] = cs;
                                        cs = 9;
                                        _goto_targ = 2;
                                        continue block29;
                                    }
                                    case 9: {
                                        if (debug) {
                                            System.out.println("endObject");
                                        }
                                        this.pop();
                                        cs = stack[--top];
                                        _goto_targ = 2;
                                        continue block29;
                                    }
                                    case 10: {
                                        v6 = name = names.size > 0 ? (String)names.pop() : null;
                                        if (debug) {
                                            System.out.println("startArray: " + name);
                                        }
                                        this.startArray(name);
                                        if (top == stack.length) {
                                            newStack = new int[stack.length * 2];
                                            System.arraycopy(stack, 0, newStack, 0, stack.length);
                                            stack = newStack;
                                        }
                                        stack[top++] = cs;
                                        cs = 49;
                                        _goto_targ = 2;
                                        continue block29;
                                    }
                                    case 11: {
                                        if (debug) {
                                            System.out.println("endArray");
                                        }
                                        this.pop();
                                        cs = stack[--top];
                                        _goto_targ = 2;
                                        continue block29;
                                    }
                                }
                            }
                        }
                    }
                    case 2: {
                        if (cs == 0) {
                            _goto_targ = 5;
                            continue block29;
                        }
                        if (++p != pe) {
                            _goto_targ = 1;
                            continue block29;
                        }
                    }
                    case 4: {
                        if (p != eof) break block29;
                        __acts = JsonReader._json_eof_actions[cs];
                        __nacts = JsonReader._json_actions[__acts++];
                        while (__nacts-- > 0) {
                            switch (JsonReader._json_actions[__acts++]) {
                                case 3: {
                                    if (discardBuffer) break;
                                    value = new String(data, s, p - s);
                                    s = p;
                                    if (needsUnescape) {
                                        value = this.unescape(value);
                                    }
                                    v7 = name = names.size > 0 ? (String)names.pop() : null;
                                    if (debug) {
                                        System.out.println("string: " + name + "=" + value);
                                    }
                                    this.string(name, value);
                                    break;
                                }
                                case 4: {
                                    value = new String(data, s, p - s);
                                    s = p;
                                    v8 = name = names.size > 0 ? (String)names.pop() : null;
                                    if (debug) {
                                        System.out.println("number: " + name + "=" + Float.parseFloat(value));
                                    }
                                    this.number(name, Float.parseFloat(value));
                                    break;
                                }
                                case 5: {
                                    v9 = name = names.size > 0 ? (String)names.pop() : null;
                                    if (debug) {
                                        System.out.println("boolean: " + name + "=true");
                                    }
                                    this.bool(name, true);
                                    discardBuffer = true;
                                    break;
                                }
                                case 6: {
                                    v10 = name = names.size > 0 ? (String)names.pop() : null;
                                    if (debug) {
                                        System.out.println("boolean: " + name + "=false");
                                    }
                                    this.bool(name, false);
                                    discardBuffer = true;
                                    break;
                                }
                                case 7: {
                                    v11 = name = names.size > 0 ? (String)names.pop() : null;
                                    if (debug) {
                                        System.out.println("null: " + name);
                                    }
                                    this.string(name, null);
                                    discardBuffer = true;
                                }
                            }
                        }
                        break block29;
                    }
                }
                break;
            }
        }
        catch (RuntimeException ex) {
            parseRuntimeEx = ex;
        }
        if (p < pe) {
            lineNumber = 1;
            for (i = 0; i < p; ++i) {
                if (data[i] != '\n') continue;
                ++lineNumber;
            }
            throw new SerializationException("Error parsing JSON on line " + lineNumber + " near: " + new String(data, p, pe - p), parseRuntimeEx);
        }
        if (this.elements.size != 0) {
            element = this.elements.peek();
            this.elements.clear();
            if (element instanceof OrderedMap) {
                throw new SerializationException("Error parsing JSON, unmatched brace.");
            }
            throw new SerializationException("Error parsing JSON, unmatched bracket.");
        }
        root = this.root;
        this.root = null;
        return root;
    }

    private static byte[] init__json_actions_0() {
        return new byte[]{0, 1, 0, 1, 1, 1, 2, 1, 3, 1, 4, 1, 8, 1, 9, 1, 10, 1, 11, 2, 0, 2, 2, 0, 3, 2, 3, 9, 2, 3, 11, 2, 4, 9, 2, 4, 11, 2, 5, 3, 2, 6, 3, 2, 7, 3, 3, 5, 3, 9, 3, 5, 3, 11, 3, 6, 3, 9, 3, 6, 3, 11, 3, 7, 3, 9, 3, 7, 3, 11};
    }

    private static short[] init__json_key_offsets_0() {
        return new short[]{0, 0, 18, 20, 22, 31, 33, 35, 39, 41, 56, 58, 60, 64, 82, 84, 86, 91, 105, 112, 114, 123, 125, 133, 137, 139, 145, 154, 161, 163, 173, 175, 184, 188, 190, 197, 205, 213, 221, 229, 236, 244, 252, 260, 267, 275, 283, 291, 298, 307, 327, 329, 331, 336, 355, 362, 364, 374, 376, 385, 389, 391, 398, 406, 414, 422, 430, 437, 445, 453, 461, 468, 476, 484, 492, 499, 508, 511, 518, 526, 533, 538, 546, 554, 562, 570, 577, 585, 593, 601, 608, 616, 624, 632, 639, 639};
    }

    private static char[] init__json_trans_keys_0() {
        return new char[]{' ', '\"', '$', '-', '[', '_', 'f', 'n', 't', '{', '\t', '\r', '0', '9', 'A', 'Z', 'a', 'z', '\"', '\\', '\"', '\\', '\"', '/', '\\', 'b', 'f', 'n', 'r', 't', 'u', '0', '9', '0', '9', '+', '-', '0', '9', '0', '9', ' ', '\"', '$', ',', '-', '_', '}', '\t', '\r', '0', '9', 'A', 'Z', 'a', 'z', '\"', '\\', '\"', '\\', ' ', ':', '\t', '\r', ' ', '\"', '$', '-', '[', '_', 'f', 'n', 't', '{', '\t', '\r', '0', '9', 'A', 'Z', 'a', 'z', '\"', '\\', '\"', '\\', ' ', ',', '}', '\t', '\r', ' ', '\"', '$', '-', '_', '}', '\t', '\r', '0', '9', 'A', 'Z', 'a', 'z', ' ', ',', ':', ']', '}', '\t', '\r', '0', '9', ' ', '.', ':', 'E', 'e', '\t', '\r', '0', '9', '0', '9', ' ', ':', 'E', 'e', '\t', '\r', '0', '9', '+', '-', '0', '9', '0', '9', ' ', ':', '\t', '\r', '0', '9', '\"', '/', '\\', 'b', 'f', 'n', 'r', 't', 'u', ' ', ',', ':', ']', '}', '\t', '\r', '0', '9', ' ', ',', '.', 'E', 'e', '}', '\t', '\r', '0', '9', '0', '9', ' ', ',', 'E', 'e', '}', '\t', '\r', '0', '9', '+', '-', '0', '9', '0', '9', ' ', ',', '}', '\t', '\r', '0', '9', ' ', ',', ':', ']', 'a', '}', '\t', '\r', ' ', ',', ':', ']', 'l', '}', '\t', '\r', ' ', ',', ':', ']', 's', '}', '\t', '\r', ' ', ',', ':', ']', 'e', '}', '\t', '\r', ' ', ',', ':', ']', '}', '\t', '\r', ' ', ',', ':', ']', 'u', '}', '\t', '\r', ' ', ',', ':', ']', 'l', '}', '\t', '\r', ' ', ',', ':', ']', 'l', '}', '\t', '\r', ' ', ',', ':', ']', '}', '\t', '\r', ' ', ',', ':', ']', 'r', '}', '\t', '\r', ' ', ',', ':', ']', 'u', '}', '\t', '\r', ' ', ',', ':', ']', 'e', '}', '\t', '\r', ' ', ',', ':', ']', '}', '\t', '\r', '\"', '/', '\\', 'b', 'f', 'n', 'r', 't', 'u', ' ', '\"', '$', ',', '-', '[', ']', '_', 'f', 'n', 't', '{', '\t', '\r', '0', '9', 'A', 'Z', 'a', 'z', '\"', '\\', '\"', '\\', ' ', ',', ']', '\t', '\r', ' ', '\"', '$', '-', '[', ']', '_', 'f', 'n', 't', '{', '\t', '\r', '0', '9', 'A', 'Z', 'a', 'z', ' ', ',', ':', ']', '}', '\t', '\r', '0', '9', ' ', ',', '.', 'E', ']', 'e', '\t', '\r', '0', '9', '0', '9', ' ', ',', 'E', ']', 'e', '\t', '\r', '0', '9', '+', '-', '0', '9', '0', '9', ' ', ',', ']', '\t', '\r', '0', '9', ' ', ',', ':', ']', 'a', '}', '\t', '\r', ' ', ',', ':', ']', 'l', '}', '\t', '\r', ' ', ',', ':', ']', 's', '}', '\t', '\r', ' ', ',', ':', ']', 'e', '}', '\t', '\r', ' ', ',', ':', ']', '}', '\t', '\r', ' ', ',', ':', ']', 'u', '}', '\t', '\r', ' ', ',', ':', ']', 'l', '}', '\t', '\r', ' ', ',', ':', ']', 'l', '}', '\t', '\r', ' ', ',', ':', ']', '}', '\t', '\r', ' ', ',', ':', ']', 'r', '}', '\t', '\r', ' ', ',', ':', ']', 'u', '}', '\t', '\r', ' ', ',', ':', ']', 'e', '}', '\t', '\r', ' ', ',', ':', ']', '}', '\t', '\r', '\"', '/', '\\', 'b', 'f', 'n', 'r', 't', 'u', ' ', '\t', '\r', ' ', ',', ':', ']', '}', '\t', '\r', ' ', '.', 'E', 'e', '\t', '\r', '0', '9', ' ', 'E', 'e', '\t', '\r', '0', '9', ' ', '\t', '\r', '0', '9', ' ', ',', ':', ']', 'a', '}', '\t', '\r', ' ', ',', ':', ']', 'l', '}', '\t', '\r', ' ', ',', ':', ']', 's', '}', '\t', '\r', ' ', ',', ':', ']', 'e', '}', '\t', '\r', ' ', ',', ':', ']', '}', '\t', '\r', ' ', ',', ':', ']', 'u', '}', '\t', '\r', ' ', ',', ':', ']', 'l', '}', '\t', '\r', ' ', ',', ':', ']', 'l', '}', '\t', '\r', ' ', ',', ':', ']', '}', '\t', '\r', ' ', ',', ':', ']', 'r', '}', '\t', '\r', ' ', ',', ':', ']', 'u', '}', '\t', '\r', ' ', ',', ':', ']', 'e', '}', '\t', '\r', ' ', ',', ':', ']', '}', '\t', '\r', '\u0000'};
    }

    private static byte[] init__json_single_lengths_0() {
        return new byte[]{0, 10, 2, 2, 7, 0, 0, 2, 0, 7, 2, 2, 2, 10, 2, 2, 3, 6, 5, 0, 5, 0, 4, 2, 0, 2, 7, 5, 0, 6, 0, 5, 2, 0, 3, 6, 6, 6, 6, 5, 6, 6, 6, 5, 6, 6, 6, 5, 7, 12, 2, 2, 3, 11, 5, 0, 6, 0, 5, 2, 0, 3, 6, 6, 6, 6, 5, 6, 6, 6, 5, 6, 6, 6, 5, 7, 1, 5, 4, 3, 1, 6, 6, 6, 6, 5, 6, 6, 6, 5, 6, 6, 6, 5, 0, 0};
    }

    private static byte[] init__json_range_lengths_0() {
        return new byte[]{0, 4, 0, 0, 1, 1, 1, 1, 1, 4, 0, 0, 1, 4, 0, 0, 1, 4, 1, 1, 2, 1, 2, 1, 1, 2, 1, 1, 1, 2, 1, 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 0, 0, 1, 4, 1, 1, 2, 1, 2, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0};
    }

    private static short[] init__json_index_offsets_0() {
        return new short[]{0, 0, 15, 18, 21, 30, 32, 34, 38, 40, 52, 55, 58, 62, 77, 80, 83, 88, 99, 106, 108, 116, 118, 125, 129, 131, 136, 145, 152, 154, 163, 165, 173, 177, 179, 185, 193, 201, 209, 217, 224, 232, 240, 248, 255, 263, 271, 279, 286, 295, 312, 315, 318, 323, 339, 346, 348, 357, 359, 367, 371, 373, 379, 387, 395, 403, 411, 418, 426, 434, 442, 449, 457, 465, 473, 480, 489, 492, 499, 506, 512, 516, 524, 532, 540, 548, 555, 563, 571, 579, 586, 594, 602, 610, 617, 618};
    }

    private static byte[] init__json_trans_targs_0() {
        return new byte[]{1, 2, 77, 5, 76, 77, 81, 86, 90, 76, 1, 78, 77, 77, 0, 76, 4, 3, 76, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 78, 0, 79, 0, 8, 8, 80, 0, 80, 0, 9, 10, 18, 17, 19, 18, 94, 9, 18, 18, 18, 0, 12, 48, 11, 12, 48, 11, 12, 13, 12, 0, 13, 14, 27, 28, 16, 27, 35, 40, 44, 16, 13, 29, 27, 27, 0, 16, 26, 15, 16, 26, 15, 16, 17, 94, 16, 0, 17, 10, 18, 19, 18, 94, 17, 18, 18, 18, 0, 12, 0, 13, 0, 0, 12, 18, 20, 0, 12, 21, 13, 23, 23, 12, 20, 0, 22, 0, 12, 13, 23, 23, 12, 22, 0, 24, 24, 25, 0, 25, 0, 12, 13, 12, 25, 0, 15, 15, 15, 15, 15, 15, 15, 15, 0, 16, 17, 0, 0, 94, 16, 27, 29, 0, 16, 17, 30, 32, 32, 94, 16, 29, 0, 31, 0, 16, 17, 32, 32, 94, 16, 31, 0, 33, 33, 34, 0, 34, 0, 16, 17, 94, 16, 34, 0, 16, 17, 0, 0, 36, 94, 16, 27, 16, 17, 0, 0, 37, 94, 16, 27, 16, 17, 0, 0, 38, 94, 16, 27, 16, 17, 0, 0, 39, 94, 16, 27, 16, 17, 0, 0, 94, 16, 27, 16, 17, 0, 0, 41, 94, 16, 27, 16, 17, 0, 0, 42, 94, 16, 27, 16, 17, 0, 0, 43, 94, 16, 27, 16, 17, 0, 0, 94, 16, 27, 16, 17, 0, 0, 45, 94, 16, 27, 16, 17, 0, 0, 46, 94, 16, 27, 16, 17, 0, 0, 47, 94, 16, 27, 16, 17, 0, 0, 94, 16, 27, 11, 11, 11, 11, 11, 11, 11, 11, 0, 49, 50, 54, 53, 55, 52, 95, 54, 62, 67, 71, 52, 49, 56, 54, 54, 0, 52, 75, 51, 52, 75, 51, 52, 53, 95, 52, 0, 53, 50, 54, 55, 52, 95, 54, 62, 67, 71, 52, 53, 56, 54, 54, 0, 52, 53, 0, 95, 0, 52, 54, 56, 0, 52, 53, 57, 59, 95, 59, 52, 56, 0, 58, 0, 52, 53, 59, 95, 59, 52, 58, 0, 60, 60, 61, 0, 61, 0, 52, 53, 95, 52, 61, 0, 52, 53, 0, 95, 63, 0, 52, 54, 52, 53, 0, 95, 64, 0, 52, 54, 52, 53, 0, 95, 65, 0, 52, 54, 52, 53, 0, 95, 66, 0, 52, 54, 52, 53, 0, 95, 0, 52, 54, 52, 53, 0, 95, 68, 0, 52, 54, 52, 53, 0, 95, 69, 0, 52, 54, 52, 53, 0, 95, 70, 0, 52, 54, 52, 53, 0, 95, 0, 52, 54, 52, 53, 0, 95, 72, 0, 52, 54, 52, 53, 0, 95, 73, 0, 52, 54, 52, 53, 0, 95, 74, 0, 52, 54, 52, 53, 0, 95, 0, 52, 54, 51, 51, 51, 51, 51, 51, 51, 51, 0, 76, 76, 0, 76, 0, 0, 0, 0, 76, 77, 76, 6, 7, 7, 76, 78, 0, 76, 7, 7, 76, 79, 0, 76, 76, 80, 0, 76, 0, 0, 0, 82, 0, 76, 77, 76, 0, 0, 0, 83, 0, 76, 77, 76, 0, 0, 0, 84, 0, 76, 77, 76, 0, 0, 0, 85, 0, 76, 77, 76, 0, 0, 0, 0, 76, 77, 76, 0, 0, 0, 87, 0, 76, 77, 76, 0, 0, 0, 88, 0, 76, 77, 76, 0, 0, 0, 89, 0, 76, 77, 76, 0, 0, 0, 0, 76, 77, 76, 0, 0, 0, 91, 0, 76, 77, 76, 0, 0, 0, 92, 0, 76, 77, 76, 0, 0, 0, 93, 0, 76, 77, 76, 0, 0, 0, 0, 76, 77, 0, 0, 0};
    }

    private static byte[] init__json_trans_actions_0() {
        return new byte[]{0, 0, 1, 1, 15, 1, 1, 1, 1, 11, 0, 1, 1, 1, 0, 22, 1, 1, 7, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 13, 0, 1, 1, 1, 0, 19, 1, 1, 5, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 15, 1, 1, 1, 1, 11, 0, 1, 1, 1, 0, 22, 1, 1, 7, 0, 0, 0, 0, 13, 0, 0, 0, 0, 1, 1, 1, 13, 0, 1, 1, 1, 0, 5, 0, 5, 0, 0, 5, 0, 0, 0, 5, 0, 5, 0, 0, 5, 0, 0, 0, 0, 5, 5, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 5, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 0, 7, 7, 0, 0, 25, 7, 0, 0, 0, 9, 9, 0, 0, 0, 31, 9, 0, 0, 0, 0, 9, 9, 0, 0, 31, 9, 0, 0, 0, 0, 0, 0, 0, 0, 9, 9, 31, 9, 0, 0, 7, 7, 0, 0, 0, 25, 7, 0, 7, 7, 0, 0, 0, 25, 7, 0, 7, 7, 0, 0, 0, 25, 7, 0, 7, 7, 0, 0, 0, 25, 7, 0, 40, 40, 0, 0, 54, 40, 0, 7, 7, 0, 0, 0, 25, 7, 0, 7, 7, 0, 0, 0, 25, 7, 0, 7, 7, 0, 0, 0, 25, 7, 0, 43, 43, 0, 0, 62, 43, 0, 7, 7, 0, 0, 0, 25, 7, 0, 7, 7, 0, 0, 0, 25, 7, 0, 7, 7, 0, 0, 0, 25, 7, 0, 37, 37, 0, 0, 46, 37, 0, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 1, 0, 1, 15, 17, 1, 1, 1, 1, 11, 0, 1, 1, 1, 0, 22, 1, 1, 7, 0, 0, 0, 0, 17, 0, 0, 0, 0, 1, 1, 15, 17, 1, 1, 1, 1, 11, 0, 1, 1, 1, 0, 7, 7, 0, 28, 0, 7, 0, 0, 0, 9, 9, 0, 0, 34, 0, 9, 0, 0, 0, 0, 9, 9, 0, 34, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 9, 9, 34, 9, 0, 0, 7, 7, 0, 28, 0, 0, 7, 0, 7, 7, 0, 28, 0, 0, 7, 0, 7, 7, 0, 28, 0, 0, 7, 0, 7, 7, 0, 28, 0, 0, 7, 0, 40, 40, 0, 58, 0, 40, 0, 7, 7, 0, 28, 0, 0, 7, 0, 7, 7, 0, 28, 0, 0, 7, 0, 7, 7, 0, 28, 0, 0, 7, 0, 43, 43, 0, 66, 0, 43, 0, 7, 7, 0, 28, 0, 0, 7, 0, 7, 7, 0, 28, 0, 0, 7, 0, 7, 7, 0, 28, 0, 0, 7, 0, 37, 37, 0, 50, 0, 37, 0, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 7, 0, 0, 0, 0, 7, 0, 9, 0, 0, 0, 9, 0, 0, 9, 0, 0, 9, 0, 0, 9, 9, 0, 0, 7, 0, 0, 0, 0, 0, 7, 0, 7, 0, 0, 0, 0, 0, 7, 0, 7, 0, 0, 0, 0, 0, 7, 0, 7, 0, 0, 0, 0, 0, 7, 0, 40, 0, 0, 0, 0, 40, 0, 7, 0, 0, 0, 0, 0, 7, 0, 7, 0, 0, 0, 0, 0, 7, 0, 7, 0, 0, 0, 0, 0, 7, 0, 43, 0, 0, 0, 0, 43, 0, 7, 0, 0, 0, 0, 0, 7, 0, 7, 0, 0, 0, 0, 0, 7, 0, 7, 0, 0, 0, 0, 0, 7, 0, 37, 0, 0, 0, 0, 37, 0, 0, 0, 0};
    }

    private static byte[] init__json_eof_actions_0() {
        return new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 9, 9, 9, 7, 7, 7, 7, 40, 7, 7, 7, 43, 7, 7, 7, 37, 0, 0};
    }

    private void set(String name, Object value) {
        if (this.current instanceof OrderedMap) {
            ((OrderedMap)this.current).put(name, value);
        } else if (this.current instanceof Array) {
            ((Array)this.current).add(value);
        } else {
            this.root = value;
        }
    }

    protected void startObject(String name) {
        OrderedMap value = new OrderedMap();
        if (this.current != null) {
            this.set(name, value);
        }
        this.elements.add(value);
        this.current = value;
    }

    protected void startArray(String name) {
        Array value = new Array();
        if (this.current != null) {
            this.set(name, value);
        }
        this.elements.add(value);
        this.current = value;
    }

    protected void pop() {
        this.root = this.elements.pop();
        this.current = this.elements.size > 0 ? this.elements.peek() : null;
    }

    protected void string(String name, String value) {
        this.set(name, value);
    }

    protected void number(String name, float value) {
        this.set(name, Float.valueOf(value));
    }

    protected void bool(String name, boolean value) {
        this.set(name, value);
    }

    private String unescape(String value) {
        int length = value.length();
        StringBuilder buffer = new StringBuilder(length + 16);
        int i = 0;
        while (i < length) {
            char c;
            if ((c = value.charAt(i++)) != '\\') {
                buffer.append(c);
                continue;
            }
            if (i == length) break;
            if ((c = value.charAt(i++)) == 'u') {
                buffer.append(Character.toChars(Integer.parseInt(value.substring(i, i + 4), 16)));
                i += 4;
                continue;
            }
            switch (c) {
                case '\"': 
                case '/': 
                case '\\': {
                    break;
                }
                case 'b': {
                    c = '\b';
                    break;
                }
                case 'f': {
                    c = '\f';
                    break;
                }
                case 'n': {
                    c = '\n';
                    break;
                }
                case 'r': {
                    c = '\r';
                    break;
                }
                case 't': {
                    c = '\t';
                    break;
                }
                default: {
                    throw new SerializationException("Illegal escaped character: \\" + c);
                }
            }
            buffer.append(c);
        }
        return buffer.toString();
    }
}

