/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Pools;

public class Slider
extends Widget {
    private SliderStyle style;
    private float min;
    private float max;
    private float stepSize;
    private float value;
    private float animateFromValue;
    private float sliderPos;
    private final boolean vertical;
    int draggingPointer = -1;
    private float animateDuration;
    private float animateTime;
    private Interpolation animateInterpolation = Interpolation.linear;

    public Slider(float min, float max, float stepSize, boolean vertical, Skin skin) {
        this(min, max, stepSize, vertical, skin.get("default-" + (vertical ? "vertical" : "horizontal"), SliderStyle.class));
    }

    public Slider(float min, float max, float stepSize, boolean vertical, Skin skin, String styleName) {
        this(min, max, stepSize, vertical, skin.get(styleName, SliderStyle.class));
    }

    public Slider(float min, float max, float stepSize, boolean vertical, SliderStyle style) {
        if (min > max) {
            throw new IllegalArgumentException("min must be > max: " + min + " > " + max);
        }
        if (stepSize <= 0.0f) {
            throw new IllegalArgumentException("stepSize must be > 0: " + stepSize);
        }
        this.setStyle(style);
        this.min = min;
        this.max = max;
        this.stepSize = stepSize;
        this.vertical = vertical;
        this.value = min;
        this.setWidth(this.getPrefWidth());
        this.setHeight(this.getPrefHeight());
        this.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                if (Slider.this.draggingPointer != -1) {
                    return false;
                }
                Slider.this.draggingPointer = pointer;
                Slider.this.calculatePositionAndValue(x, y);
                return true;
            }

            @Override
            public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
                if (pointer != Slider.this.draggingPointer) {
                    return;
                }
                Slider.this.draggingPointer = -1;
                Slider.this.calculatePositionAndValue(x, y);
            }

            @Override
            public void touchDragged(InputEvent event, float x, float y, int pointer) {
                Slider.this.calculatePositionAndValue(x, y);
            }
        });
    }

    public void setStyle(SliderStyle style) {
        if (style == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.style = style;
        this.invalidateHierarchy();
    }

    public SliderStyle getStyle() {
        return this.style;
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        this.animateTime -= delta;
    }

    @Override
    public void draw(SpriteBatch batch, float parentAlpha) {
        Drawable knob = this.style.knob;
        Drawable bg = this.style.background;
        Drawable knobBefore = this.style.knobBefore;
        Drawable knobAfter = this.style.knobAfter;
        Color color = this.getColor();
        float x = this.getX();
        float y = this.getY();
        float width = this.getWidth();
        float height = this.getHeight();
        float knobHeight = knob == null ? 0.0f : knob.getMinHeight();
        float knobWidth = knob == null ? 0.0f : knob.getMinWidth();
        float value = this.getVisualValue();
        batch.setColor(color.r, color.g, color.b, color.a * parentAlpha);
        if (this.vertical) {
            bg.draw(batch, x + (float)((int)((width - bg.getMinWidth()) * 0.5f)), y, bg.getMinWidth(), height);
            float sliderPosHeight = height - (bg.getTopHeight() + bg.getBottomHeight());
            this.sliderPos = (value - this.min) / (this.max - this.min) * (sliderPosHeight - knobHeight);
            this.sliderPos = Math.max(0.0f, this.sliderPos);
            this.sliderPos = Math.min(sliderPosHeight - knobHeight, this.sliderPos) + bg.getBottomHeight();
            float knobHeightHalf = knobHeight * 0.5f;
            if (knobBefore != null) {
                knobBefore.draw(batch, x + (float)((int)((width - knobBefore.getMinWidth()) * 0.5f)), y, knobBefore.getMinWidth(), (int)(this.sliderPos + knobHeightHalf));
            }
            if (knobAfter != null) {
                knobAfter.draw(batch, x + (float)((int)((width - knobAfter.getMinWidth()) * 0.5f)), y + (float)((int)(this.sliderPos + knobHeightHalf)), knobAfter.getMinWidth(), height - (float)((int)(this.sliderPos + knobHeightHalf)));
            }
            if (knob != null) {
                knob.draw(batch, x + (float)((int)((width - knobWidth) * 0.5f)), (int)(y + this.sliderPos), knobWidth, knobHeight);
            }
        } else {
            bg.draw(batch, x, y + (float)((int)((height - bg.getMinHeight()) * 0.5f)), width, bg.getMinHeight());
            float sliderPosWidth = width - (bg.getLeftWidth() + bg.getRightWidth());
            this.sliderPos = (value - this.min) / (this.max - this.min) * (sliderPosWidth - knobWidth);
            this.sliderPos = Math.max(0.0f, this.sliderPos);
            this.sliderPos = Math.min(sliderPosWidth - knobWidth, this.sliderPos) + bg.getLeftWidth();
            float knobHeightHalf = knobHeight * 0.5f;
            if (knobBefore != null) {
                knobBefore.draw(batch, x, y + (float)((int)((height - knobBefore.getMinHeight()) * 0.5f)), (int)(this.sliderPos + knobHeightHalf), knobBefore.getMinHeight());
            }
            if (knobAfter != null) {
                knobAfter.draw(batch, x + (float)((int)(this.sliderPos + knobHeightHalf)), y + (float)((int)((height - knobAfter.getMinHeight()) * 0.5f)), width - (float)((int)(this.sliderPos + knobHeightHalf)), knobAfter.getMinHeight());
            }
            if (knob != null) {
                knob.draw(batch, (int)(x + this.sliderPos), (int)(y + (height - knobHeight) * 0.5f), knobWidth, knobHeight);
            }
        }
    }

    void calculatePositionAndValue(float x, float y) {
        float value;
        Drawable knob = this.style.knob;
        Drawable bg = this.style.background;
        float oldPosition = this.sliderPos;
        if (this.vertical) {
            float height = this.getHeight() - bg.getTopHeight() - bg.getBottomHeight();
            float knobHeight = knob == null ? 0.0f : knob.getMinHeight();
            this.sliderPos = y - bg.getBottomHeight() - knobHeight * 0.5f;
            this.sliderPos = Math.max(0.0f, this.sliderPos);
            this.sliderPos = Math.min(height - knobHeight, this.sliderPos);
            value = this.min + (this.max - this.min) * (this.sliderPos / (height - knobHeight));
        } else {
            float width = this.getWidth() - bg.getLeftWidth() - bg.getRightWidth();
            float knobWidth = knob == null ? 0.0f : knob.getMinWidth();
            this.sliderPos = x - bg.getLeftWidth() - knobWidth * 0.5f;
            this.sliderPos = Math.max(0.0f, this.sliderPos);
            this.sliderPos = Math.min(width - knobWidth, this.sliderPos);
            value = this.min + (this.max - this.min) * (this.sliderPos / (width - knobWidth));
        }
        float oldValue = value;
        this.setValue(value);
        if (value == oldValue) {
            this.sliderPos = oldPosition;
        }
    }

    public boolean isDragging() {
        return this.draggingPointer != -1;
    }

    public float getValue() {
        return this.value;
    }

    public float getVisualValue() {
        if (this.animateTime > 0.0f) {
            return this.animateInterpolation.apply(this.animateFromValue, this.value, 1.0f - this.animateTime / this.animateDuration);
        }
        return this.value;
    }

    public void setValue(float value) {
        float oldValue;
        if (value < this.min || value > this.max) {
            throw new IllegalArgumentException("value must be >= min and <= max: " + value);
        }
        if ((value = MathUtils.clamp((float)Math.round(value / this.stepSize) * this.stepSize, this.min, this.max)) == (oldValue = this.value)) {
            return;
        }
        float oldVisualValue = this.getVisualValue();
        this.value = value;
        ChangeListener.ChangeEvent changeEvent = Pools.obtain(ChangeListener.ChangeEvent.class);
        if (this.fire(changeEvent)) {
            this.value = oldValue;
        } else if (this.animateDuration > 0.0f) {
            this.animateFromValue = oldVisualValue;
            this.animateTime = this.animateDuration;
        }
        Pools.free(changeEvent);
    }

    public void setRange(float min, float max) {
        if (min >= max) {
            throw new IllegalArgumentException("min must be < max");
        }
        this.min = min;
        this.max = max;
        this.setValue(min);
    }

    public void setStepSize(float stepSize) {
        if (stepSize <= 0.0f) {
            throw new IllegalArgumentException("steps must be > 0: " + stepSize);
        }
        this.stepSize = stepSize;
    }

    @Override
    public float getPrefWidth() {
        if (this.vertical) {
            return Math.max(this.style.knob == null ? 0.0f : this.style.knob.getMinWidth(), this.style.background.getMinWidth());
        }
        return 140.0f;
    }

    @Override
    public float getPrefHeight() {
        if (this.vertical) {
            return 140.0f;
        }
        return Math.max(this.style.knob == null ? 0.0f : this.style.knob.getMinHeight(), this.style.background.getMinHeight());
    }

    public float getMinValue() {
        return this.min;
    }

    public float getMaxValue() {
        return this.max;
    }

    public float getStepSize() {
        return this.stepSize;
    }

    public void setAnimateDuration(float duration) {
        this.animateDuration = duration;
    }

    public void setAnimateInterpolation(Interpolation animateInterpolation) {
        if (animateInterpolation == null) {
            throw new IllegalArgumentException("animateInterpolation cannot be null.");
        }
        this.animateInterpolation = animateInterpolation;
    }

    public static class SliderStyle {
        public Drawable background;
        public Drawable knob;
        public Drawable knobBefore;
        public Drawable knobAfter;

        public SliderStyle() {
        }

        public SliderStyle(Drawable background, Drawable knob) {
            this.background = background;
            this.knob = knob;
        }

        public SliderStyle(SliderStyle style) {
            this.background = style.background;
            this.knob = style.knob;
        }
    }
}

