/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.loaders.md2;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.g3d.ModelLoaderHints;
import com.badlogic.gdx.graphics.g3d.loaders.KeyframedModelLoader;
import com.badlogic.gdx.graphics.g3d.loaders.md2.MD2Frame;
import com.badlogic.gdx.graphics.g3d.loaders.md2.MD2Header;
import com.badlogic.gdx.graphics.g3d.loaders.md2.MD2Normals;
import com.badlogic.gdx.graphics.g3d.loaders.md2.MD2Triangle;
import com.badlogic.gdx.graphics.g3d.model.keyframe.Keyframe;
import com.badlogic.gdx.graphics.g3d.model.keyframe.KeyframedAnimation;
import com.badlogic.gdx.graphics.g3d.model.keyframe.KeyframedModel;
import com.badlogic.gdx.graphics.g3d.model.keyframe.KeyframedSubMesh;
import com.badlogic.gdx.utils.LittleEndianInputStream;
import com.badlogic.gdx.utils.ObjectMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class MD2Loader
implements KeyframedModelLoader {
    private final byte[] charBuffer = new byte[16];

    @Override
    public KeyframedModel load(FileHandle file, ModelLoaderHints hints) {
        float frameDuration = 0.2f;
        if (hints instanceof MD2LoaderHints) {
            frameDuration = ((MD2LoaderHints)hints).frameDuration;
        }
        return this.load(file, frameDuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyframedModel load(FileHandle fileHandle, float frameDuration) {
        InputStream in = fileHandle.read();
        try {
            KeyframedModel keyframedModel = this.load(in, frameDuration);
            return keyframedModel;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public KeyframedModel load(InputStream in, float frameDuration) {
        try {
            byte[] bytes = this.loadBytes(in);
            MD2Header header = this.loadHeader(bytes);
            float[] texCoords = this.loadTexCoords(header, bytes);
            MD2Triangle[] triangles = this.loadTriangles(header, bytes);
            MD2Frame[] frames = this.loadFrames(header, bytes);
            return this.buildModel(header, triangles, texCoords, frames, frameDuration);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private KeyframedModel buildModel(MD2Header header, MD2Triangle[] triangles, float[] texCoords, MD2Frame[] frames, float frameDuration) {
        int i;
        VertexIndices vIdx;
        ArrayList<VertexIndices> vertCombos = new ArrayList<VertexIndices>();
        short[] indices = new short[triangles.length * 3];
        int idx = 0;
        short vertIdx = 0;
        for (int i2 = 0; i2 < triangles.length; ++i2) {
            MD2Triangle triangle = triangles[i2];
            for (int j = 0; j < 3; ++j) {
                VertexIndices vert = null;
                boolean contains = false;
                for (int k = 0; k < vertCombos.size(); ++k) {
                    vIdx = (VertexIndices)vertCombos.get(k);
                    if (vIdx.vIdx != triangle.vertices[j] || vIdx.tIdx != triangle.texCoords[j]) continue;
                    vert = vIdx;
                    contains = true;
                    break;
                }
                if (!contains) {
                    vert = new VertexIndices(triangle.vertices[j], triangle.texCoords[j], vertIdx);
                    vertCombos.add(vert);
                    vertIdx = (short)(vertIdx + 1);
                }
                indices[idx++] = vert.nIdx;
            }
        }
        idx = 0;
        float[] uvs = new float[vertCombos.size() * 2];
        for (i = 0; i < vertCombos.size(); ++i) {
            VertexIndices vtI = (VertexIndices)vertCombos.get(i);
            uvs[idx++] = texCoords[vtI.tIdx * 2];
            uvs[idx++] = texCoords[vtI.tIdx * 2 + 1];
        }
        for (i = 0; i < frames.length; ++i) {
            MD2Frame frame = frames[i];
            idx = 0;
            float[] newVerts = new float[vertCombos.size() * 6];
            for (int j = 0; j < vertCombos.size(); ++j) {
                VertexIndices vIdx2 = (VertexIndices)vertCombos.get(j);
                newVerts[idx++] = frame.vertices[vIdx2.vIdx * 3];
                newVerts[idx++] = frame.vertices[vIdx2.vIdx * 3 + 1];
                newVerts[idx++] = frame.vertices[vIdx2.vIdx * 3 + 2];
                newVerts[idx++] = MD2Normals.normals[frame.normalIndices[vIdx2.vIdx]][1];
                newVerts[idx++] = MD2Normals.normals[frame.normalIndices[vIdx2.vIdx]][2];
                newVerts[idx++] = MD2Normals.normals[frame.normalIndices[vIdx2.vIdx]][0];
            }
            frame.vertices = newVerts;
        }
        header.numVertices = vertCombos.size();
        float[] blendedVertices = new float[header.numVertices * 8];
        MD2Frame frame = frames[0];
        idx = 0;
        int idxV = 0;
        int idxT = 0;
        for (int i3 = 0; i3 < header.numVertices; ++i3) {
            vIdx = (VertexIndices)vertCombos.get(i3);
            blendedVertices[idx++] = frame.vertices[idxV++];
            blendedVertices[idx++] = frame.vertices[idxV++];
            blendedVertices[idx++] = frame.vertices[idxV++];
            blendedVertices[idx++] = frame.vertices[idxV++];
            blendedVertices[idx++] = frame.vertices[idxV++];
            blendedVertices[idx++] = frame.vertices[idxV++];
            blendedVertices[idx++] = uvs[idxT++];
            blendedVertices[idx++] = uvs[idxT++];
        }
        ObjectMap<String, KeyframedAnimation> animations = new ObjectMap<String, KeyframedAnimation>();
        String lastName = frames[0].name;
        int beginFrame = 0;
        for (int frameNum = 1; frameNum < frames.length; ++frameNum) {
            if (frames[frameNum].name.equals(lastName) && frameNum != frames.length - 1) continue;
            int subAnimLen = frameNum - beginFrame;
            KeyframedAnimation subAnim = new KeyframedAnimation(lastName, frameDuration, new Keyframe[subAnimLen]);
            for (int subFrame = beginFrame; subFrame < frameNum; ++subFrame) {
                Keyframe keyFrame;
                int absFrameNum = subFrame - beginFrame;
                frame = frames[subFrame];
                float[] vertices = new float[header.numVertices * 6];
                idx = 0;
                idxV = 0;
                for (int i4 = 0; i4 < header.numVertices; ++i4) {
                    vertices[idx++] = frame.vertices[idxV++];
                    vertices[idx++] = frame.vertices[idxV++];
                    vertices[idx++] = frame.vertices[idxV++];
                    vertices[idx++] = frame.vertices[idxV++];
                    vertices[idx++] = frame.vertices[idxV++];
                    vertices[idx++] = frame.vertices[idxV++];
                }
                subAnim.keyframes[absFrameNum] = keyFrame = new Keyframe((float)absFrameNum * frameDuration, vertices);
                animations.put(subAnim.name, subAnim);
            }
            lastName = frames[frameNum].name;
            beginFrame = frameNum;
        }
        KeyframedAnimation animation = new KeyframedAnimation("all", frameDuration, new Keyframe[frames.length]);
        float timeStamp = 0.0f;
        for (int frameNum = 0; frameNum < frames.length; ++frameNum) {
            Keyframe keyFrame;
            frame = frames[frameNum];
            float[] vertices = new float[header.numVertices * 6];
            idx = 0;
            idxV = 0;
            for (int i5 = 0; i5 < header.numVertices; ++i5) {
                vertices[idx++] = frame.vertices[idxV++];
                vertices[idx++] = frame.vertices[idxV++];
                vertices[idx++] = frame.vertices[idxV++];
                vertices[idx++] = frame.vertices[idxV++];
                vertices[idx++] = frame.vertices[idxV++];
                vertices[idx++] = frame.vertices[idxV++];
            }
            animation.keyframes[frameNum] = keyFrame = new Keyframe((float)frameNum * frameDuration, vertices);
        }
        Mesh mesh = new Mesh(Mesh.VertexDataType.VertexArray, false, header.numVertices, indices.length, new VertexAttribute(0, 3, "a_position"), new VertexAttribute(2, 3, "a_normal"), new VertexAttribute(3, 2, "a_texCoord0"));
        mesh.setIndices(indices);
        animations.put("all", animation);
        KeyframedSubMesh subMesh = new KeyframedSubMesh("md2-mesh", mesh, blendedVertices, animations, 6, 4);
        KeyframedModel model = new KeyframedModel(new KeyframedSubMesh[]{subMesh});
        model.setAnimation("all", 0.0f, false);
        return model;
    }

    private float[] buildTexCoords(MD2Header header, MD2Triangle[] triangles, float[] texCoords) {
        float[] uvs = new float[header.numVertices * 2];
        for (int i = 0; i < triangles.length; ++i) {
            MD2Triangle triangle = triangles[i];
            for (int j = 0; j < 3; ++j) {
                short vertIdx = triangle.vertices[j];
                int uvIdx = vertIdx * 2;
                uvs[uvIdx] = texCoords[triangle.texCoords[j] * 2];
                uvs[uvIdx + 1] = texCoords[triangle.texCoords[j] * 2 + 1];
            }
        }
        return uvs;
    }

    private short[] buildIndices(MD2Triangle[] triangles) {
        short[] indices = new short[triangles.length * 3];
        int idx = 0;
        for (int i = 0; i < triangles.length; ++i) {
            MD2Triangle triangle = triangles[i];
            indices[idx++] = triangle.vertices[0];
            indices[idx++] = triangle.vertices[1];
            indices[idx++] = triangle.vertices[2];
        }
        return indices;
    }

    private MD2Frame[] loadFrames(MD2Header header, byte[] bytes) throws IOException {
        LittleEndianInputStream in = new LittleEndianInputStream(new ByteArrayInputStream(bytes));
        in.skip(header.offsetFrames);
        MD2Frame[] frames = new MD2Frame[header.numFrames];
        for (int i = 0; i < header.numFrames; ++i) {
            frames[i] = this.loadFrame(header, in);
        }
        in.close();
        return frames;
    }

    private MD2Frame loadFrame(MD2Header header, LittleEndianInputStream in) throws IOException {
        MD2Frame frame = new MD2Frame();
        frame.vertices = new float[header.numVertices * 3];
        frame.normalIndices = new int[header.numVertices];
        float scaleX = in.readFloat();
        float scaleY = in.readFloat();
        float scaleZ = in.readFloat();
        float transX = in.readFloat();
        float transY = in.readFloat();
        float transZ = in.readFloat();
        in.read(this.charBuffer);
        int len = 0;
        for (int i = 0; i < this.charBuffer.length; ++i) {
            if (this.charBuffer[i] != 0) continue;
            len = i;
            break;
        }
        frame.name = new String(this.charBuffer, 0, len);
        int vertIdx = 0;
        for (int i = 0; i < header.numVertices; ++i) {
            float x = (float)in.read() * scaleX + transX;
            float y = (float)in.read() * scaleY + transY;
            float z = (float)in.read() * scaleZ + transZ;
            frame.vertices[vertIdx++] = y;
            frame.vertices[vertIdx++] = z;
            frame.vertices[vertIdx++] = x;
            frame.normalIndices[i] = in.read();
        }
        return frame;
    }

    private MD2Triangle[] loadTriangles(MD2Header header, byte[] bytes) throws IOException {
        LittleEndianInputStream in = new LittleEndianInputStream(new ByteArrayInputStream(bytes));
        in.skip(header.offsetTriangles);
        MD2Triangle[] triangles = new MD2Triangle[header.numTriangles];
        for (int i = 0; i < header.numTriangles; ++i) {
            MD2Triangle triangle = new MD2Triangle();
            triangle.vertices[0] = in.readShort();
            triangle.vertices[1] = in.readShort();
            triangle.vertices[2] = in.readShort();
            triangle.texCoords[0] = in.readShort();
            triangle.texCoords[1] = in.readShort();
            triangle.texCoords[2] = in.readShort();
            triangles[i] = triangle;
        }
        in.close();
        return triangles;
    }

    private float[] loadTexCoords(MD2Header header, byte[] bytes) throws IOException {
        LittleEndianInputStream in = new LittleEndianInputStream(new ByteArrayInputStream(bytes));
        in.skip(header.offsetTexCoords);
        float[] texCoords = new float[header.numTexCoords * 2];
        float width = header.skinWidth;
        float height = header.skinHeight;
        for (int i = 0; i < header.numTexCoords * 2; i += 2) {
            short u = in.readShort();
            short v = in.readShort();
            texCoords[i] = (float)u / width;
            texCoords[i + 1] = (float)v / height;
        }
        in.close();
        return texCoords;
    }

    private MD2Header loadHeader(byte[] bytes) throws IOException {
        LittleEndianInputStream in = new LittleEndianInputStream(new ByteArrayInputStream(bytes));
        MD2Header header = new MD2Header();
        header.ident = in.readInt();
        header.version = in.readInt();
        header.skinWidth = in.readInt();
        header.skinHeight = in.readInt();
        header.frameSize = in.readInt();
        header.numSkins = in.readInt();
        header.numVertices = in.readInt();
        header.numTexCoords = in.readInt();
        header.numTriangles = in.readInt();
        header.numGLCommands = in.readInt();
        header.numFrames = in.readInt();
        header.offsetSkin = in.readInt();
        header.offsetTexCoords = in.readInt();
        header.offsetTriangles = in.readInt();
        header.offsetFrames = in.readInt();
        header.offsetGLCommands = in.readInt();
        header.offsetEnd = in.readInt();
        in.close();
        return header;
    }

    private byte[] loadBytes(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int readBytes = 0;
        while ((readBytes = in.read(buffer)) > 0) {
            out.write(buffer, 0, readBytes);
        }
        out.close();
        return out.toByteArray();
    }

    public static class MD2LoaderHints
    extends ModelLoaderHints {
        public final float frameDuration;

        public MD2LoaderHints(float frameDuration) {
            super(false);
            this.frameDuration = frameDuration;
        }
    }

    public class VertexIndices {
        public short vIdx;
        public short tIdx;
        public short nIdx;

        public VertexIndices(short vIdx, short tIdx, short nIdx) {
            this.vIdx = vIdx;
            this.tIdx = tIdx;
            this.nIdx = nIdx;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.tIdx;
            result = 31 * result + this.vIdx;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VertexIndices other = (VertexIndices)obj;
            if (this.tIdx != other.tIdx) {
                return false;
            }
            return this.vIdx == other.vIdx;
        }
    }
}

