/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.loaders.g3d.chunks;

import com.badlogic.gdx.utils.Array;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ChunkWriter {
    final Chunk root;
    Chunk currChunk;

    public ChunkWriter() {
        this.currChunk = this.root = new Chunk(1194542106);
    }

    public void newChunk(int id) {
        Chunk chunk = new Chunk(id, this.currChunk);
        this.currChunk.children.add(chunk);
        this.currChunk = chunk;
    }

    public void endChunk() {
        this.currChunk = this.currChunk.parent;
    }

    public void writeByte(int v) {
        try {
            this.currChunk.out.writeByte(v);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeShort(short v) {
        try {
            this.currChunk.out.writeShort(v);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeInt(int v) {
        try {
            this.currChunk.out.writeInt(v);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeLong(long v) {
        try {
            this.currChunk.out.writeLong(v);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeFloat(float v) {
        try {
            this.currChunk.out.writeFloat(v);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeDouble(double v) {
        try {
            this.currChunk.out.writeDouble(v);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeString(String v) {
        try {
            byte[] bytes = v.getBytes("UTF-8");
            this.currChunk.out.writeInt(bytes.length);
            this.currChunk.out.write(bytes);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeToStream(OutputStream out) throws IOException {
        this.writeToStream(this.root, new DataOutputStream(out));
    }

    private void writeToStream(Chunk chunk, DataOutputStream out) throws IOException {
        out.writeInt(chunk.id);
        out.writeInt(chunk.payload.size());
        out.writeInt(chunk.children.size);
        out.write(chunk.payload.toByteArray());
        for (int i = 0; i < chunk.children.size; ++i) {
            Chunk child = chunk.children.get(i);
            this.writeToStream(child, out);
        }
    }

    public void writeBytes(byte[] v) {
        try {
            this.currChunk.out.writeInt(v.length);
            for (int i = 0; i < v.length; ++i) {
                this.currChunk.out.writeByte(v[i]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeShorts(short[] v) {
        try {
            this.currChunk.out.writeInt(v.length);
            for (int i = 0; i < v.length; ++i) {
                this.currChunk.out.writeShort(v[i]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeInts(int[] v) {
        try {
            this.currChunk.out.writeInt(v.length);
            for (int i = 0; i < v.length; ++i) {
                this.currChunk.out.writeInt(v[i]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeLongs(long[] v) {
        try {
            this.currChunk.out.writeInt(v.length);
            for (int i = 0; i < v.length; ++i) {
                this.currChunk.out.writeLong(v[i]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeFloats(float[] v) {
        try {
            this.currChunk.out.writeInt(v.length);
            for (int i = 0; i < v.length; ++i) {
                this.currChunk.out.writeFloat(v[i]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeDoubles(double[] v) {
        try {
            this.currChunk.out.writeInt(v.length);
            for (int i = 0; i < v.length; ++i) {
                this.currChunk.out.writeDouble(v[i]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    class Chunk {
        final int id;
        final Chunk parent;
        final Array<Chunk> children = new Array();
        final ByteArrayOutputStream payload = new ByteArrayOutputStream();
        final DataOutputStream out = new DataOutputStream(this.payload);

        public Chunk(int id) {
            this.id = id;
            this.parent = null;
        }

        public Chunk(int id, Chunk parent) {
            this.id = id;
            this.parent = parent;
        }
    }
}

