/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.os.NativeLibrary;
import com.jogamp.common.util.IOUtil;
import com.jogamp.common.util.SecurityUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import jogamp.common.Debug;

public class JarUtil {
    private static final boolean DEBUG = Debug.debug("JarUtil");
    private static Resolver resolver;

    public static void setResolver(Resolver resolver) throws IllegalArgumentException, IllegalStateException, SecurityException {
        if (resolver == null) {
            throw new IllegalArgumentException("Null Resolver passed");
        }
        if (JarUtil.resolver != null) {
            throw new IllegalStateException("Resolver already set!");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        JarUtil.resolver = resolver;
    }

    public static boolean hasJarURI(String string, ClassLoader classLoader) {
        try {
            return null != JarUtil.getJarURI(string, classLoader);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static URI getJarURI(String string, ClassLoader classLoader) throws IllegalArgumentException, IOException, URISyntaxException {
        URI uRI;
        if (null == string || null == classLoader) {
            throw new IllegalArgumentException("null arguments: clazzBinName " + string + ", cl " + classLoader);
        }
        URL uRL = IOUtil.getClassURL(string, classLoader);
        String string2 = uRL.getProtocol();
        if (!(null == resolver || string2.equals("jar") || string2.equals("file") || string2.equals("http") || string2.equals("https"))) {
            URL uRL2 = resolver.resolve(uRL);
            uRI = uRL2.toURI();
            if (DEBUG) {
                System.out.println("getJarURI Resolver: " + uRL + "\n\t-> " + uRL2 + "\n\t-> " + uRI);
            }
        } else {
            uRI = uRL.toURI();
            if (DEBUG) {
                System.out.println("getJarURI Default " + uRL + "\n\t-> " + uRI);
            }
        }
        if (!uRI.getScheme().equals("jar")) {
            throw new IllegalArgumentException("URI is not using scheme jar: <" + uRI + ">");
        }
        return uRI;
    }

    public static String getJarBasename(URI uRI) throws IllegalArgumentException {
        if (null == uRI) {
            throw new IllegalArgumentException("URI is null");
        }
        if (!uRI.getScheme().equals("jar")) {
            throw new IllegalArgumentException("URI is not using scheme jar: <" + uRI + ">");
        }
        String string = uRI.getRawSchemeSpecificPart();
        int n = string.lastIndexOf(33);
        if (0 > n) {
            throw new IllegalArgumentException("JAR URI does not contain jar uri terminator '!', in <" + uRI + ">");
        }
        string = string.substring(0, n);
        n = string.lastIndexOf(47);
        if (0 > n && 0 > (n = string.lastIndexOf(58))) {
            throw new IllegalArgumentException("JAR URI does not contain protocol terminator ':', in <" + uRI + ">");
        }
        if (0 >= (string = string.substring(n + 1)).lastIndexOf(".jar")) {
            throw new IllegalArgumentException("No Jar name in <" + uRI + ">");
        }
        if (DEBUG) {
            System.out.println("getJarName res: " + string);
        }
        return string;
    }

    public static String getJarBasename(String string, ClassLoader classLoader) throws IllegalArgumentException, IOException, URISyntaxException {
        return JarUtil.getJarBasename(JarUtil.getJarURI(string, classLoader));
    }

    public static URI getJarSubURI(URI uRI) throws IllegalArgumentException, URISyntaxException {
        if (null == uRI) {
            throw new IllegalArgumentException("URI is null");
        }
        if (!uRI.getScheme().equals("jar")) {
            throw new IllegalArgumentException("URI is not a using scheme jar: <" + uRI + ">");
        }
        String string = uRI.getRawSchemeSpecificPart();
        int n = string.lastIndexOf(33);
        if (0 > n) {
            throw new IllegalArgumentException("JAR URI does not contain jar uri terminator '!', uri <" + uRI + ">");
        }
        string = string.substring(0, n);
        if (0 >= string.lastIndexOf(".jar")) {
            throw new IllegalArgumentException("No Jar name in <" + uRI + ">");
        }
        if (DEBUG) {
            System.out.println("getJarSubURI res: " + string);
        }
        return new URI(string);
    }

    public static String getJarEntry(URI uRI) {
        if (null == uRI) {
            throw new IllegalArgumentException("URI is null");
        }
        if (!uRI.getScheme().equals("jar")) {
            throw new IllegalArgumentException("URI is not a using scheme jar: <" + uRI + ">");
        }
        String string = uRI.getRawSchemeSpecificPart();
        int n = string.lastIndexOf(33);
        if (0 <= n) {
            return string.substring(n + 1);
        }
        throw new IllegalArgumentException("JAR URI does not contain jar uri terminator '!', uri <" + uRI + ">");
    }

    public static URI getJarSubURI(String string, ClassLoader classLoader) throws IllegalArgumentException, IOException, URISyntaxException {
        return JarUtil.getJarSubURI(JarUtil.getJarURI(string, classLoader));
    }

    public static URI getJarFileURI(String string, ClassLoader classLoader) throws IllegalArgumentException, IOException, URISyntaxException {
        if (null == string || null == classLoader) {
            throw new IllegalArgumentException("null arguments: clazzBinName " + string + ", cl " + classLoader);
        }
        URI uRI = new URI("jar", JarUtil.getJarSubURI(string, classLoader).toString() + "!/", null);
        if (DEBUG) {
            System.out.println("getJarFileURI res: " + uRI);
        }
        return uRI;
    }

    public static URI getJarFileURI(URI uRI, String string) throws IllegalArgumentException, URISyntaxException {
        if (null == uRI || null == string) {
            throw new IllegalArgumentException("null arguments: baseURI " + uRI + ", jarFileName " + string);
        }
        return new URI("jar", uRI.toString() + string + "!/", null);
    }

    public static URI getJarFileURI(URI uRI) throws IllegalArgumentException, URISyntaxException {
        if (null == uRI) {
            throw new IllegalArgumentException("jarSubURI is null");
        }
        return new URI("jar", uRI.toString() + "!/", null);
    }

    public static URI getJarEntryURI(URI uRI, String string) throws IllegalArgumentException, URISyntaxException {
        if (null == string) {
            throw new IllegalArgumentException("jarEntry is null");
        }
        return new URI(uRI.toString() + string);
    }

    public static JarFile getJarFile(String string, ClassLoader classLoader) throws IOException, IllegalArgumentException, URISyntaxException {
        return JarUtil.getJarFile(JarUtil.getJarFileURI(string, classLoader));
    }

    public static JarFile getJarFile(URI uRI) throws IOException, IllegalArgumentException, URISyntaxException {
        URL uRL;
        URLConnection uRLConnection;
        if (null == uRI) {
            throw new IllegalArgumentException("null jarFileURI");
        }
        if (DEBUG) {
            System.out.println("getJarFile: " + uRI.toString());
        }
        if ((uRLConnection = (uRL = IOUtil.toURL(uRI)).openConnection()) instanceof JarURLConnection) {
            JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
            JarFile jarFile = jarURLConnection.getJarFile();
            if (DEBUG) {
                System.out.println("getJarFile res: " + jarFile.getName());
            }
            return jarFile;
        }
        if (DEBUG) {
            System.out.println("getJarFile res: NULL");
        }
        return null;
    }

    public static Map<String, String> getNativeLibNames(JarFile jarFile) {
        if (DEBUG) {
            System.err.println("JarUtil: getNativeLibNames: " + jarFile);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            String string = jarEntry.getName();
            String string2 = NativeLibrary.isValidNativeLibraryName(string, false);
            if (null == string2) continue;
            hashMap.put(string2, string);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int extract(File file, Map<String, String> map, JarFile jarFile, boolean bl, boolean bl2, boolean bl3) throws IOException {
        if (DEBUG) {
            System.err.println("JarUtil: extract: " + jarFile.getName() + " -> " + file + ", extractNativeLibraries " + bl + ", extractClassFiles " + bl2 + ", extractOtherFiles " + bl3);
        }
        int n = 0;
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            boolean bl4;
            boolean bl5;
            JarEntry jarEntry = enumeration.nextElement();
            String string = jarEntry.getName();
            String string2 = NativeLibrary.isValidNativeLibraryName(string, false);
            boolean bl6 = bl5 = null != string2;
            if (bl5 && !bl) {
                if (!DEBUG) continue;
                System.err.println("JarUtil: JarEntry : " + string + " native-lib skipped");
                continue;
            }
            boolean bl7 = string.endsWith(".class");
            if (bl7 && !bl2) {
                if (!DEBUG) continue;
                System.err.println("JarUtil: JarEntry : " + string + " class-file skipped");
                continue;
            }
            if (!(bl5 || bl7 || bl3)) {
                if (!DEBUG) continue;
                System.err.println("JarUtil: JarEntry : " + string + " other-file skipped");
                continue;
            }
            boolean bl8 = string.endsWith("/");
            boolean bl9 = bl4 = string.indexOf(47) == -1 && string.indexOf(File.separatorChar) == -1;
            if (DEBUG) {
                System.err.println("JarUtil: JarEntry : isNativeLib " + bl5 + ", isClassFile " + bl7 + ", isDir " + bl8 + ", isRootEntry " + bl4);
            }
            File file2 = new File(file, string);
            if (bl8) {
                if (DEBUG) {
                    System.err.println("JarUtil: MKDIR: " + string + " -> " + file2);
                }
                file2.mkdir();
                continue;
            }
            File file3 = new File(file2.getParent());
            if (!file3.exists()) {
                if (DEBUG) {
                    System.err.println("JarUtil: MKDIR (parent): " + string + " -> " + file3);
                }
                file3.mkdir();
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(jarFile.getInputStream(jarEntry));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            int n2 = -1;
            try {
                n2 = IOUtil.copyStream2Stream(bufferedInputStream, bufferedOutputStream, -1);
            }
            finally {
                ((InputStream)bufferedInputStream).close();
                ((OutputStream)bufferedOutputStream).close();
            }
            boolean bl10 = false;
            if (n2 > 0) {
                ++n;
                if (bl5 && (bl4 || !map.containsKey(string2))) {
                    map.put(string2, file2.getAbsolutePath());
                    bl10 = true;
                }
            }
            if (!DEBUG) continue;
            System.err.println("JarUtil: EXTRACT[" + n + "]: [" + string2 + " -> ] " + string + " -> " + file2 + ": " + n2 + " bytes, addedAsNativeLib: " + bl10);
        }
        return n;
    }

    public static final void validateCertificates(Certificate[] certificateArray, JarFile jarFile) throws IOException, SecurityException {
        if (DEBUG) {
            System.err.println("JarUtil: validateCertificates: " + jarFile.getName());
        }
        if (certificateArray == null || certificateArray.length == 0) {
            throw new IllegalArgumentException("Null certificates passed");
        }
        byte[] byArray = new byte[1024];
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            if (jarEntry.isDirectory() || jarEntry.getName().startsWith("META-INF/")) continue;
            JarUtil.validateCertificate(certificateArray, jarFile, jarEntry, byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void validateCertificate(Certificate[] certificateArray, JarFile jarFile, JarEntry jarEntry, byte[] byArray) throws IOException, SecurityException {
        if (DEBUG) {
            System.err.println("JarUtil: validate JarEntry : " + jarEntry.getName());
        }
        InputStream inputStream = jarFile.getInputStream(jarEntry);
        try {
            while (inputStream.read(byArray) > 0) {
            }
        }
        finally {
            inputStream.close();
        }
        Certificate[] certificateArray2 = jarEntry.getCertificates();
        if (certificateArray2 == null || certificateArray2.length == 0) {
            throw new SecurityException("no certificate for " + jarEntry.getName() + " in " + jarFile.getName());
        }
        if (!SecurityUtil.equals(certificateArray, certificateArray2)) {
            throw new SecurityException("certificates not equal for " + jarEntry.getName() + " in " + jarFile.getName());
        }
    }

    public static interface Resolver {
        public URL resolve(URL var1);
    }
}

