/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.awt.event;

import com.jogamp.newt.Window;
import com.jogamp.newt.event.awt.AWTAdapter;
import com.jogamp.newt.event.awt.AWTWindowAdapter;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowEvent;
import javax.media.nativewindow.NativeWindow;
import jogamp.newt.driver.DriverUpdatePosition;

public class AWTParentWindowAdapter
extends AWTWindowAdapter
implements HierarchyListener {
    NativeWindow downstreamParent;

    public AWTParentWindowAdapter(NativeWindow nativeWindow, Window window) {
        super(window);
        this.downstreamParent = nativeWindow;
    }

    @Override
    public AWTAdapter addTo(Component component) {
        component.addHierarchyListener(this);
        return super.addTo(component);
    }

    @Override
    public AWTAdapter removeFrom(Component component) {
        component.removeHierarchyListener(this);
        return super.removeFrom(component);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        Window window = this.getNewtWindow();
        boolean bl = window.isNativeValid() && window.getGraphicsConfiguration().getChosenCapabilities().isOnscreen();
        boolean bl2 = this.downstreamParent == window.getParent();
        boolean bl3 = window.isFullscreen();
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("AWT: focusGained: onscreen " + bl + ", " + focusEvent + ", isParent: " + bl2 + ", isFS " + bl3);
        }
        if (bl2) {
            if (bl && !bl3) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
            }
            window.requestFocus(false);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("AWT: focusLost: " + focusEvent);
        }
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        final Component component = componentEvent.getComponent();
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("AWT: componentResized: " + component);
        }
        final Window window = this.getNewtWindow();
        window.runOnEDTIfAvail(false, new Runnable(){

            @Override
            public void run() {
                int n = component.getWidth();
                int n2 = component.getHeight();
                if (0 < n && 0 < n2) {
                    if (window.getWidth() != n || window.getHeight() != n2) {
                        window.setSize(n, n2);
                        if (component.isVisible() != window.isVisible()) {
                            window.setVisible(component.isVisible());
                        }
                    }
                } else if (window.isVisible()) {
                    window.setVisible(false);
                }
            }
        });
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        Window window;
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("AWT: componentMoved: " + componentEvent);
        }
        if ((window = this.getNewtWindow()).getDelegatedWindow() instanceof DriverUpdatePosition) {
            ((DriverUpdatePosition)((Object)window.getDelegatedWindow())).updatePosition(0, 0);
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
        if (null == this.getNewtEventListener()) {
            boolean bl;
            long l = hierarchyEvent.getChangeFlags();
            Component component = hierarchyEvent.getChanged();
            if (0L != (4L & l)) {
                bl = component.isShowing();
                if (DEBUG_IMPLEMENTATION) {
                    System.err.println("AWT: hierarchyChanged SHOWING_CHANGED: showing " + bl + ", " + component + ", source " + hierarchyEvent.getComponent());
                }
                this.getNewtWindow().runOnEDTIfAvail(false, new Runnable(){

                    @Override
                    public void run() {
                        if (AWTParentWindowAdapter.this.getNewtWindow().isVisible() != bl) {
                            AWTParentWindowAdapter.this.getNewtWindow().setVisible(bl);
                        }
                    }
                });
            }
            if (DEBUG_IMPLEMENTATION && 0L != (2L & l)) {
                bl = component.isDisplayable();
                System.err.println("AWT: hierarchyChanged DISPLAYABILITY_CHANGED: displayability " + bl + ", " + component);
            }
        }
    }
}

