/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.openal.av;

import com.jogamp.openal.AL;
import com.jogamp.openal.ALC;
import com.jogamp.openal.ALCcontext;
import com.jogamp.openal.ALCdevice;
import com.jogamp.openal.ALFactory;
import com.jogamp.opengl.util.av.AudioSink;
import java.nio.Buffer;
import jogamp.opengl.util.av.SyncedRingbuffer;

public class ALAudioSink
implements AudioSink {
    public static final int BUFFER_SIZE = 4096;
    public static final int SAMPLES_PER_BUFFER = 2048;
    private static final ALC alc;
    private static final AL al;
    private static final boolean staticAvailable;
    private String deviceSpecifier;
    private ALCdevice device;
    private ALCcontext context;
    public float samplePeriod;
    public float bufferPeriod;
    int[] alBuffers = null;
    private SyncedRingbuffer<Integer> alBufferAvail = null;
    private SyncedRingbuffer<ActiveBuffer> alBufferPlaying = null;
    private int alBufferBytesQueued = 0;
    private int[] alSource = null;
    private AudioSink.AudioDataFormat chosenFormat = null;
    private int alFormat;
    private boolean initialized = false;

    public ALAudioSink() {
        if (!staticAvailable) {
            return;
        }
        try {
            this.device = alc.alcOpenDevice(null);
            if (this.device == null) {
                throw new RuntimeException("ALAudioSink: Error opening default OpenAL device");
            }
            this.deviceSpecifier = alc.alcGetString(this.device, 4101);
            if (this.deviceSpecifier == null) {
                throw new RuntimeException("ALAudioSink: Error getting specifier for default OpenAL device");
            }
            this.context = alc.alcCreateContext(this.device, null);
            if (this.context == null) {
                throw new RuntimeException("ALAudioSink: Error creating OpenAL context");
            }
            alc.alcMakeContextCurrent(this.context);
            if (alc.alcGetError(this.device) != 0) {
                throw new RuntimeException("ALAudioSink: Error making OpenAL context current");
            }
            this.alSource = new int[1];
            al.alGenSources(1, this.alSource, 0);
            int n = al.alGetError();
            if (n != 0) {
                this.alSource = null;
                throw new RuntimeException("ALAudioSink: Error generating Source: 0x" + Integer.toHexString(n));
            }
            if (DEBUG) {
                System.err.println("ALAudioSink: Using device: " + this.deviceSpecifier);
            }
            this.initialized = true;
            return;
        }
        catch (Exception exception) {
            if (DEBUG) {
                System.err.println(exception.getMessage());
            }
            this.destroy();
            return;
        }
    }

    public String toString() {
        int n = null != this.alSource ? this.alSource[0] : 0;
        int n2 = null != this.alBuffers ? this.alBuffers.length : 0;
        return "ALAudioSink[init " + this.initialized + ", device " + this.deviceSpecifier + ", ctx " + this.context + ", alSource " + n + ", chosen " + this.chosenFormat + ", alFormat " + ALAudioSink.toHexString(this.alFormat) + ", buffers[total " + n2 + ", avail " + this.alBufferAvail.size() + ", " + this.alBufferPlaying.getFreeSlots() + ", queued[bufferCount " + this.alBufferPlaying.size() + ", " + this.getQueuedTime() + " ms, " + this.alBufferBytesQueued + " bytes]";
    }

    @Override
    public AudioSink.AudioDataFormat getPreferredFormat() {
        return DefaultFormat;
    }

    @Override
    public AudioSink.AudioDataFormat initSink(AudioSink.AudioDataFormat audioDataFormat, int n) {
        if (!staticAvailable) {
            return null;
        }
        this.samplePeriod = 1.0f / (float)audioDataFormat.sampleRate;
        this.bufferPeriod = this.samplePeriod * 2048.0f;
        block0 : switch (audioDataFormat.channelCount) {
            case 1: {
                switch (audioDataFormat.sampleSize) {
                    case 8: {
                        this.alFormat = 4352;
                        break block0;
                    }
                    case 16: {
                        this.alFormat = 4353;
                        break block0;
                    }
                }
                return null;
            }
            case 2: {
                switch (audioDataFormat.sampleSize) {
                    case 8: {
                        this.alFormat = 4354;
                        break block0;
                    }
                    case 16: {
                        this.alFormat = 4355;
                        break block0;
                    }
                }
                return null;
            }
        }
        this.destroyBuffers();
        this.alBuffers = new int[n];
        al.alGenBuffers(n, this.alBuffers, 0);
        int n2 = al.alGetError();
        if (n2 != 0) {
            this.alBuffers = null;
            throw new RuntimeException("ALAudioSink: Error generating Buffers: 0x" + Integer.toHexString(n2));
        }
        Integer[] integerArray = new Integer[n];
        for (int i = 0; i < n; ++i) {
            integerArray[i] = this.alBuffers[i];
        }
        this.alBufferAvail = new SyncedRingbuffer<Integer>(integerArray, true);
        this.alBufferPlaying = new SyncedRingbuffer<ActiveBuffer>(new ActiveBuffer[n], false);
        this.chosenFormat = audioDataFormat;
        return this.chosenFormat;
    }

    private void destroyBuffers() {
        if (!staticAvailable) {
            return;
        }
        if (null != this.alBuffers) {
            block4: {
                try {
                    al.alDeleteBuffers(this.alBufferAvail.capacity(), this.alBuffers, 0);
                }
                catch (Throwable throwable) {
                    if (!DEBUG) break block4;
                    System.err.println("Catched " + throwable.getClass().getName() + ": " + throwable.getMessage());
                    throwable.printStackTrace();
                }
            }
            this.alBufferAvail.clear(true);
            this.alBufferAvail = null;
            this.alBufferPlaying.clear(true);
            this.alBufferPlaying = null;
            this.alBufferBytesQueued = 0;
            this.alBuffers = null;
        }
    }

    @Override
    public void destroy() {
        this.initialized = false;
        if (!staticAvailable) {
            return;
        }
        if (null != this.alSource) {
            block10: {
                try {
                    al.alDeleteSources(1, this.alSource, 0);
                }
                catch (Throwable throwable) {
                    if (!DEBUG) break block10;
                    System.err.println("Catched " + throwable.getClass().getName() + ": " + throwable.getMessage());
                    throwable.printStackTrace();
                }
            }
            this.alSource = null;
        }
        this.destroyBuffers();
        if (null != this.context) {
            block11: {
                try {
                    alc.alcDestroyContext(this.context);
                }
                catch (Throwable throwable) {
                    if (!DEBUG) break block11;
                    System.err.println("Catched " + throwable.getClass().getName() + ": " + throwable.getMessage());
                    throwable.printStackTrace();
                }
            }
            this.context = null;
        }
        if (null != this.device) {
            block12: {
                try {
                    alc.alcCloseDevice(this.device);
                }
                catch (Throwable throwable) {
                    if (!DEBUG) break block12;
                    System.err.println("Catched " + throwable.getClass().getName() + ": " + throwable.getMessage());
                    throwable.printStackTrace();
                }
            }
            this.device = null;
        }
        this.chosenFormat = null;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    private final void dequeueBuffer(boolean bl) {
        int n = 0;
        int[] nArray = new int[1];
        do {
            al.alGetSourcei(this.alSource[0], 4118, nArray, 0);
            n = al.alGetError();
            if (0 != n) {
                throw new RuntimeException("ALError " + ALAudioSink.toHexString(n) + " while quering processed buffers at source. " + this);
            }
            if (!bl || nArray[0] > 0) continue;
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (nArray[0] <= 0);
        int n2 = nArray[0];
        if (n2 > 0) {
            int[] nArray2 = new int[n2];
            al.alSourceUnqueueBuffers(this.alSource[0], n2, nArray2, 0);
            n = al.alGetError();
            if (0 != n) {
                throw new RuntimeException("ALError " + ALAudioSink.toHexString(n) + " while dequeueing " + n2 + " processed buffers. " + this);
            }
            for (int i = 0; i < n2; ++i) {
                ActiveBuffer activeBuffer = this.alBufferPlaying.get(true);
                if (null == activeBuffer) {
                    throw new InternalError("Internal Error: " + this);
                }
                if (activeBuffer.name != nArray2[i]) {
                    throw new InternalError("Buffer name mismatch: dequeued: " + nArray2[i] + ", released " + activeBuffer);
                }
                this.alBufferBytesQueued -= activeBuffer.size;
                if (!this.alBufferAvail.put(activeBuffer.name)) {
                    throw new InternalError("Internal Error: " + this);
                }
                if (!DEBUG) continue;
                System.err.println("ALAudioSink: Dequeued " + n2 + ", wait " + bl + ", " + this);
            }
        }
    }

    private static final String toHexString(int n) {
        return "0x" + Integer.toHexString(n);
    }

    @Override
    public void writeData(AudioSink.AudioFrame audioFrame) {
        Integer n;
        if (!this.initialized || null == this.chosenFormat) {
            return;
        }
        int n2 = 0;
        alc.alcMakeContextCurrent(this.context);
        n2 = al.alGetError();
        if (al.alGetError() != 0) {
            throw new RuntimeException("ALError " + ALAudioSink.toHexString(n2) + " while makeCurrent. " + this);
        }
        if (this.alBufferAvail.isEmpty()) {
            this.dequeueBuffer(true);
        }
        if (null == (n = this.alBufferAvail.get(true))) {
            throw new InternalError("Internal Error: " + this);
        }
        if (!this.alBufferPlaying.put(new ActiveBuffer(n, audioFrame.dataSize))) {
            throw new InternalError("Internal Error: " + this);
        }
        al.alBufferData(n.intValue(), this.alFormat, (Buffer)audioFrame.data, audioFrame.dataSize, this.chosenFormat.sampleRate);
        int[] nArray = new int[]{n};
        al.alSourceQueueBuffers(this.alSource[0], 1, nArray, 0);
        n2 = al.alGetError();
        if (al.alGetError() != 0) {
            throw new RuntimeException("ALError " + ALAudioSink.toHexString(n2) + " while queueing buffer " + ALAudioSink.toHexString(nArray[0]) + ". " + this);
        }
        this.alBufferBytesQueued += audioFrame.dataSize;
        int[] nArray2 = new int[1];
        al.alGetSourcei(this.alSource[0], 4112, nArray2, 0);
        if (nArray2[0] != 4114) {
            if (DEBUG) {
                System.err.println("ALAudioSink: Start playing: " + this);
            }
            al.alSourcePlay(this.alSource[0]);
            n2 = al.alGetError();
            if (al.alGetError() != 0) {
                throw new RuntimeException("ALError " + ALAudioSink.toHexString(n2) + " while start playing. " + this);
            }
        }
    }

    @Override
    public int getQueuedByteCount() {
        if (!this.initialized || null == this.chosenFormat) {
            return 0;
        }
        return this.alBufferBytesQueued;
    }

    @Override
    public int getQueuedTime() {
        if (!this.initialized || null == this.chosenFormat) {
            return 0;
        }
        int n = this.chosenFormat.sampleSize / 8;
        return this.alBufferBytesQueued / (this.chosenFormat.channelCount * n * (this.chosenFormat.sampleRate / 1000));
    }

    @Override
    public int getWritableBufferCount() {
        if (!this.initialized || null == this.chosenFormat) {
            return 0;
        }
        return this.alBufferPlaying.getFreeSlots();
    }

    @Override
    public boolean isDataAvailable(int n) {
        return this.initialized && null != this.chosenFormat;
    }

    static {
        AL aL;
        ALC aLC;
        block2: {
            aLC = null;
            aL = null;
            try {
                aLC = ALFactory.getALC();
                aL = ALFactory.getAL();
            }
            catch (Throwable throwable) {
                if (!DEBUG) break block2;
                System.err.println("ALAudioSink: Catched " + throwable.getClass().getName() + ": " + throwable.getMessage());
                throwable.printStackTrace();
            }
        }
        alc = aLC;
        al = aL;
        staticAvailable = null != alc && null != al;
    }

    static class ActiveBuffer {
        public final Integer name;
        public final int size;

        ActiveBuffer(Integer n, int n2) {
            this.name = n;
            this.size = n2;
        }

        public String toString() {
            return "ABuffer[name " + this.name + ", size " + this.size + "]";
        }
    }
}

