/*
 * Decompiled with CFR 0.152.
 */
package processing.data;

import processing.core.PApplet;

public class FloatList {
    int count;
    float[] data;

    public FloatList() {
        this.data = new float[10];
    }

    public FloatList(float[] list) {
        this.count = list.length;
        this.data = new float[this.count];
        System.arraycopy(list, 0, this.data, 0, this.count);
    }

    public FloatList(String[] list) {
        this(PApplet.parseFloat(list));
    }

    public int size() {
        return this.count;
    }

    public float get(int index) {
        return this.data[index];
    }

    public void set(int index, int what) {
        if (index >= this.count) {
            this.data = PApplet.expand(this.data, index + 1);
        }
        this.data[index] = what;
    }

    public void append(int value) {
        if (this.count == this.data.length) {
            this.data = PApplet.expand(this.data);
        }
        this.data[this.count++] = value;
    }

    public void clear() {
        this.count = 0;
    }

    public float calcMin() {
        if (this.data.length == 0) {
            return Float.NaN;
        }
        float m = Float.NaN;
        int i = 0;
        while (i < this.data.length) {
            if (this.data[i] == this.data[i]) {
                m = this.data[i];
                int j = i + 1;
                while (j < this.data.length) {
                    float d = this.data[j];
                    if (!Float.isNaN(d) && d < m) {
                        m = this.data[j];
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        return m;
    }

    public float calcMax() {
        if (this.data.length == 0) {
            return Float.NaN;
        }
        float m = Float.NaN;
        int i = 0;
        while (i < this.data.length) {
            if (this.data[i] == this.data[i]) {
                m = this.data[i];
                int j = i + 1;
                while (j < this.data.length) {
                    float d = this.data[j];
                    if (!Float.isNaN(d) && d > m) {
                        m = this.data[j];
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        return m;
    }

    public void removeNaN() {
        int index = 0;
        int i = 0;
        while (i < this.count) {
            if (this.data[i] == this.data[i]) {
                if (i != index) {
                    this.data[index] = this.data[i];
                }
                ++index;
            }
            ++i;
        }
        this.count = index;
    }

    public void replaceNaN(float replacement) {
        int i = 0;
        while (i < this.count) {
            if (this.data[i] != this.data[i]) {
                this.data[i] = replacement;
            }
            ++i;
        }
    }

    public void add(float amt) {
        int i = 0;
        while (i < this.count) {
            int n = i++;
            this.data[n] = this.data[n] + amt;
        }
    }

    public void sub(float amt) {
        int i = 0;
        while (i < this.count) {
            int n = i++;
            this.data[n] = this.data[n] - amt;
        }
    }

    public void mul(float amt) {
        int i = 0;
        while (i < this.count) {
            int n = i++;
            this.data[n] = this.data[n] * amt;
        }
    }

    public void div(float amt) {
        int i = 0;
        while (i < this.count) {
            int n = i++;
            this.data[n] = this.data[n] / amt;
        }
    }

    public void crop() {
        if (this.count != this.data.length) {
            this.data = PApplet.subset(this.data, 0, this.count);
        }
    }

    public float[] values() {
        this.crop();
        return this.data;
    }

    public int[] toIntArray() {
        int[] outgoing = new int[this.count];
        int i = 0;
        while (i < this.count) {
            outgoing[i] = (int)this.data[i];
            ++i;
        }
        return outgoing;
    }

    public long[] toLongArray() {
        long[] outgoing = new long[this.count];
        int i = 0;
        while (i < this.count) {
            outgoing[i] = (long)this.data[i];
            ++i;
        }
        return outgoing;
    }

    public float[] toFloatArray() {
        float[] outgoing = new float[this.count];
        System.arraycopy(this.data, 0, outgoing, 0, this.count);
        return outgoing;
    }

    public double[] toDoubleArray() {
        double[] outgoing = new double[this.count];
        int i = 0;
        while (i < this.count) {
            outgoing[i] = this.data[i];
            ++i;
        }
        return outgoing;
    }

    public String[] toStringArray() {
        String[] outgoing = new String[this.count];
        int i = 0;
        while (i < this.count) {
            outgoing[i] = String.valueOf(this.data[i]);
            ++i;
        }
        return outgoing;
    }
}

