/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.awt.event;

import com.jogamp.newt.Window;
import com.jogamp.newt.event.InputEvent;
import com.jogamp.newt.event.KeyEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowEvent;

public class AWTNewtEventFactory {
    private static int[] awtButtonDownMasks = new int[16];

    public static final short eventTypeAWT2NEWT(int n) {
        switch (n) {
            case 201: {
                return 102;
            }
            case 202: {
                return 106;
            }
            case 205: {
                return 103;
            }
            case 207: {
                return 103;
            }
            case 1004: {
                return 103;
            }
            case 206: {
                return 104;
            }
            case 208: {
                return 104;
            }
            case 1005: {
                return 104;
            }
            case 100: {
                return 101;
            }
            case 101: {
                return 100;
            }
            case 500: {
                return 200;
            }
            case 501: {
                return 203;
            }
            case 502: {
                return 204;
            }
            case 503: {
                return 205;
            }
            case 504: {
                return 201;
            }
            case 505: {
                return 202;
            }
            case 506: {
                return 206;
            }
            case 507: {
                return 207;
            }
            case 401: {
                return 300;
            }
            case 402: {
                return 301;
            }
        }
        return 0;
    }

    private static int getAWTButtonDownMaskImpl(int n) {
        int n2;
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 1024;
                break;
            }
            case 2: {
                n2 = 2048;
                break;
            }
            case 3: {
                n2 = 4096;
                break;
            }
            default: {
                n2 = n <= 16 ? 1 << 10 + n : 0;
            }
        }
        return n2;
    }

    public static int getAWTButtonDownMask(int n) {
        if (0 < n && n <= awtButtonDownMasks.length) {
            return awtButtonDownMasks[n - 1];
        }
        return 0;
    }

    public static final int awtModifiers2Newt(int n, int n2) {
        int n3 = 0;
        if ((n2 & 0x40) != 0) {
            n3 |= 1;
        }
        if ((n2 & 0x80) != 0) {
            n3 |= 2;
        }
        if ((n2 & 0x100) != 0) {
            n3 |= 4;
        }
        if ((n2 & 0x200) != 0) {
            n3 |= 8;
        }
        if ((n2 & 0x2000) != 0) {
            n3 |= 0x10;
        }
        if (0 != n2) {
            for (int i = 0; i < awtButtonDownMasks.length; ++i) {
                if ((n2 & awtButtonDownMasks[i]) == 0) continue;
                n3 |= InputEvent.getButtonMask(i + 1);
            }
        }
        return n3;
    }

    public static final short awtButton2Newt(int n) {
        if (0 < n && n <= 16) {
            return (short)n;
        }
        return 0;
    }

    public static final com.jogamp.newt.event.WindowEvent createWindowEvent(WindowEvent windowEvent, Window window) {
        short s = AWTNewtEventFactory.eventTypeAWT2NEWT(windowEvent.getID());
        if (0 != s) {
            return new com.jogamp.newt.event.WindowEvent(s, null == window ? windowEvent.getComponent() : window, System.currentTimeMillis());
        }
        return null;
    }

    public static final com.jogamp.newt.event.WindowEvent createWindowEvent(ComponentEvent componentEvent, Window window) {
        short s = AWTNewtEventFactory.eventTypeAWT2NEWT(componentEvent.getID());
        if (0 != s) {
            return new com.jogamp.newt.event.WindowEvent(s, null == window ? componentEvent.getComponent() : window, System.currentTimeMillis());
        }
        return null;
    }

    public static final com.jogamp.newt.event.WindowEvent createWindowEvent(FocusEvent focusEvent, Window window) {
        short s = AWTNewtEventFactory.eventTypeAWT2NEWT(focusEvent.getID());
        if (0 != s) {
            return new com.jogamp.newt.event.WindowEvent(s, null == window ? focusEvent.getComponent() : window, System.currentTimeMillis());
        }
        return null;
    }

    public static final com.jogamp.newt.event.MouseEvent createMouseEvent(MouseEvent mouseEvent, Window window) {
        short s = AWTNewtEventFactory.eventTypeAWT2NEWT(mouseEvent.getID());
        if (0 != s) {
            float f = 0.0f;
            if (mouseEvent instanceof MouseWheelEvent) {
                f = -1.0f * (float)((MouseWheelEvent)mouseEvent).getWheelRotation();
            }
            short s2 = AWTNewtEventFactory.awtButton2Newt(mouseEvent.getButton());
            int n = AWTNewtEventFactory.awtModifiers2Newt(mouseEvent.getModifiers(), mouseEvent.getModifiersEx());
            n |= InputEvent.getButtonMask(s2);
            if (null != window) {
                if (window.isPointerConfined()) {
                    n |= 0x40000000;
                }
                if (!window.isPointerVisible()) {
                    n |= Integer.MIN_VALUE;
                }
            }
            return new com.jogamp.newt.event.MouseEvent(s, null == window ? mouseEvent.getComponent() : window, mouseEvent.getWhen(), n, mouseEvent.getX(), mouseEvent.getY(), (short)mouseEvent.getClickCount(), s2, f);
        }
        return null;
    }

    public static final KeyEvent createKeyEvent(java.awt.event.KeyEvent keyEvent, Window window) {
        return AWTNewtEventFactory.createKeyEvent(AWTNewtEventFactory.eventTypeAWT2NEWT(keyEvent.getID()), keyEvent, window);
    }

    public static final KeyEvent createKeyEvent(short s, java.awt.event.KeyEvent keyEvent, Window window) {
        if (0 != s) {
            short s2 = (short)keyEvent.getKeyCode();
            return new KeyEvent(s, null == window ? keyEvent.getComponent() : window, keyEvent.getWhen(), AWTNewtEventFactory.awtModifiers2Newt(keyEvent.getModifiers(), keyEvent.getModifiersEx()), s2, s2, keyEvent.getKeyChar());
        }
        return null;
    }

    static {
        for (int i = 0; i < awtButtonDownMasks.length; ++i) {
            AWTNewtEventFactory.awtButtonDownMasks[i] = AWTNewtEventFactory.getAWTButtonDownMaskImpl(i + 1);
        }
    }
}

