/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.jawt.macosx;

import com.jogamp.common.util.Function;
import com.jogamp.nativewindow.awt.JAWTWindow;
import java.nio.Buffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.Capabilities;
import javax.media.nativewindow.MutableSurface;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.util.Point;
import jogamp.nativewindow.jawt.JAWT;
import jogamp.nativewindow.jawt.JAWTUtil;
import jogamp.nativewindow.jawt.JAWT_DrawingSurface;
import jogamp.nativewindow.jawt.JAWT_DrawingSurfaceInfo;
import jogamp.nativewindow.jawt.macosx.JAWT_MacOSXDrawingSurfaceInfo;
import jogamp.nativewindow.macosx.OSXUtil;

public class MacOSXJAWTWindow
extends JAWTWindow
implements MutableSurface {
    private JAWT_DrawingSurface ds;
    private boolean dsLocked;
    private JAWT_DrawingSurfaceInfo dsi;
    private JAWT_MacOSXDrawingSurfaceInfo macosxdsi;
    private long rootSurfaceLayerHandle = 0L;
    private long windowHandle = 0L;
    private long offscreenSurfaceHandle = 0L;
    private boolean offscreenSurfaceHandleSet = false;
    private boolean firstLock = true;

    public MacOSXJAWTWindow(Object object, AbstractGraphicsConfiguration abstractGraphicsConfiguration) {
        super(object, abstractGraphicsConfiguration);
        if (DEBUG) {
            this.dumpInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void invalidateNative() {
        if (DEBUG) {
            System.err.println("MacOSXJAWTWindow.invalidateNative(): osh-enabled " + this.isOffscreenLayerSurfaceEnabled() + ", osh-set " + this.offscreenSurfaceHandleSet + ", osh " + this.toHexString(this.offscreenSurfaceHandle) + ", rsh " + this.toHexString(this.rootSurfaceLayerHandle) + ", wh " + this.toHexString(this.windowHandle));
        }
        this.offscreenSurfaceHandle = 0L;
        this.offscreenSurfaceHandleSet = false;
        if (this.isOffscreenLayerSurfaceEnabled()) {
            if (0L != this.rootSurfaceLayerHandle) {
                JAWT_DrawingSurface jAWT_DrawingSurface;
                JAWT jAWT = this.getJAWT();
                if (null != jAWT && (jAWT_DrawingSurface = jAWT.GetDrawingSurface(this.component)) != null) {
                    if (0 == (jAWT_DrawingSurface.Lock() & 1)) {
                        JAWT_DrawingSurfaceInfo jAWT_DrawingSurfaceInfo = null;
                        try {
                            jAWT_DrawingSurfaceInfo = jAWT_DrawingSurface.GetDrawingSurfaceInfo();
                            if (!MacOSXJAWTWindow.UnsetJAWTRootSurfaceLayer(jAWT_DrawingSurfaceInfo.getBuffer(), this.rootSurfaceLayerHandle)) {
                                System.err.println("Error clearing JAWT rootSurfaceLayerHandle " + this.toHexString(this.rootSurfaceLayerHandle));
                            }
                        }
                        finally {
                            if (null != jAWT_DrawingSurfaceInfo) {
                                jAWT_DrawingSurface.FreeDrawingSurfaceInfo(jAWT_DrawingSurfaceInfo);
                            }
                            jAWT_DrawingSurface.Unlock();
                        }
                    }
                    jAWT.FreeDrawingSurface(jAWT_DrawingSurface);
                }
                OSXUtil.DestroyCALayer(this.rootSurfaceLayerHandle);
                this.rootSurfaceLayerHandle = 0L;
            }
            if (0L != this.windowHandle) {
                OSXUtil.DestroyNSWindow(this.windowHandle);
            }
        }
        this.windowHandle = 0L;
    }

    @Override
    protected void attachSurfaceLayerImpl(long l) {
        OSXUtil.AddCASublayer(this.rootSurfaceLayerHandle, l);
    }

    @Override
    protected void layoutSurfaceLayerImpl() {
        long l = this.getAttachedSurfaceLayer();
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (DEBUG) {
            System.err.println("JAWTWindow.fixSurfaceLayerLayout: " + this.toHexString(l) + ", bounds " + this.bounds + ", " + n + "x" + n2);
        }
        OSXUtil.FixCALayerPosition(this.rootSurfaceLayerHandle, l, n, n2);
    }

    @Override
    protected void detachSurfaceLayerImpl(long l) {
        OSXUtil.RemoveCASublayer(this.rootSurfaceLayerHandle, l);
    }

    @Override
    public final long getWindowHandle() {
        return this.windowHandle;
    }

    @Override
    public final long getSurfaceHandle() {
        return this.offscreenSurfaceHandleSet ? this.offscreenSurfaceHandle : this.drawable;
    }

    @Override
    public void setSurfaceHandle(long l) {
        if (!this.isOffscreenLayerSurfaceEnabled()) {
            throw new UnsupportedOperationException("Not using CALAYER");
        }
        if (DEBUG) {
            System.err.println("MacOSXJAWTWindow.setSurfaceHandle(): " + this.toHexString(l));
        }
        this.offscreenSurfaceHandle = l;
        this.offscreenSurfaceHandleSet = true;
    }

    @Override
    protected JAWT fetchJAWTImpl() throws NativeWindowException {
        return JAWTUtil.getJAWT(this.getShallUseOffscreenLayer() || this.isApplet());
    }

    @Override
    protected int lockSurfaceImpl() throws NativeWindowException {
        int n = 1;
        this.ds = this.getJAWT().GetDrawingSurface(this.component);
        if (this.ds == null) {
            this.unlockSurfaceImpl();
            return 1;
        }
        int n2 = this.ds.Lock();
        boolean bl = this.dsLocked = 0 == (n2 & 1);
        if (!this.dsLocked) {
            this.unlockSurfaceImpl();
            throw new NativeWindowException("Unable to lock surface");
        }
        if ((n2 & 8) != 0) {
            n = 2;
        }
        if (this.firstLock) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    MacOSXJAWTWindow.this.dsi = MacOSXJAWTWindow.this.ds.GetDrawingSurfaceInfo();
                    return null;
                }
            });
        } else {
            this.dsi = this.ds.GetDrawingSurfaceInfo();
        }
        if (this.dsi == null) {
            this.unlockSurfaceImpl();
            return 1;
        }
        this.updateBounds(this.dsi.getBounds());
        if (DEBUG && this.firstLock) {
            this.dumpInfo();
        }
        this.firstLock = false;
        if (!this.isOffscreenLayerSurfaceEnabled()) {
            this.macosxdsi = (JAWT_MacOSXDrawingSurfaceInfo)this.dsi.platformInfo(this.getJAWT());
            if (this.macosxdsi == null) {
                this.unlockSurfaceImpl();
                return 1;
            }
            this.drawable = this.macosxdsi.getCocoaViewRef();
            if (this.drawable == 0L) {
                this.unlockSurfaceImpl();
                return 1;
            }
            this.windowHandle = OSXUtil.GetNSWindow(this.drawable);
            n = 3;
        } else {
            String string = null;
            if (0L == this.drawable) {
                this.windowHandle = OSXUtil.CreateNSWindow(0, 0, 64, 64);
                if (0L == this.windowHandle) {
                    string = "Unable to create dummy NSWindow (layered case)";
                } else {
                    this.drawable = OSXUtil.GetNSView(this.windowHandle);
                    if (0L == this.drawable) {
                        string = "Null NSView of NSWindow " + this.toHexString(this.windowHandle);
                    }
                }
                if (null == string) {
                    Capabilities capabilities = (Capabilities)this.getGraphicsConfiguration().getChosenCapabilities().cloneMutable();
                    capabilities.setOnscreen(false);
                    this.setChosenCapabilities(capabilities);
                }
            }
            if (null == string && 0L == this.rootSurfaceLayerHandle) {
                this.rootSurfaceLayerHandle = OSXUtil.CreateCALayer(this.bounds.getX(), this.bounds.getY(), this.bounds.getWidth(), this.bounds.getHeight());
                if (0L == this.rootSurfaceLayerHandle) {
                    string = "Could not create root CALayer";
                } else if (!MacOSXJAWTWindow.SetJAWTRootSurfaceLayer(this.dsi.getBuffer(), this.rootSurfaceLayerHandle)) {
                    string = "Could not set JAWT rootSurfaceLayerHandle " + this.toHexString(this.rootSurfaceLayerHandle);
                }
            }
            if (null != string) {
                if (0L != this.rootSurfaceLayerHandle) {
                    OSXUtil.DestroyCALayer(this.rootSurfaceLayerHandle);
                    this.rootSurfaceLayerHandle = 0L;
                }
                if (0L != this.windowHandle) {
                    OSXUtil.DestroyNSWindow(this.windowHandle);
                    this.windowHandle = 0L;
                }
                this.drawable = 0L;
                this.unlockSurfaceImpl();
                throw new NativeWindowException(string + ": " + this);
            }
            n = 3;
        }
        return n;
    }

    @Override
    protected void unlockSurfaceImpl() throws NativeWindowException {
        if (null != this.ds) {
            if (null != this.dsi) {
                this.ds.FreeDrawingSurfaceInfo(this.dsi);
            }
            if (this.dsLocked) {
                this.ds.Unlock();
            }
            this.getJAWT().FreeDrawingSurface(this.ds);
        }
        this.ds = null;
        this.dsi = null;
    }

    private void dumpInfo() {
        System.err.println("MaxOSXJAWTWindow: 0x" + Integer.toHexString(this.hashCode()) + " - thread: " + Thread.currentThread().getName());
        this.dumpJAWTInfo();
    }

    @Override
    public Point getLocationOnScreen(Point point) {
        return MacOSXJAWTWindow.getLocationOnScreenNonBlocking(point, this.component);
    }

    @Override
    protected Point getLocationOnScreenNativeImpl(int n, int n2) {
        return null;
    }

    private static boolean SetJAWTRootSurfaceLayer(final Buffer buffer, final long l) {
        return OSXUtil.RunOnMainThread(true, new Function<Boolean, Object>(){

            public Boolean eval(Object ... objectArray) {
                return MacOSXJAWTWindow.SetJAWTRootSurfaceLayer0(buffer, l);
            }
        }, new Object[0]);
    }

    private static boolean UnsetJAWTRootSurfaceLayer(final Buffer buffer, final long l) {
        return OSXUtil.RunOnMainThread(true, new Function<Boolean, Object>(){

            public Boolean eval(Object ... objectArray) {
                return MacOSXJAWTWindow.UnsetJAWTRootSurfaceLayer0(buffer, l);
            }
        }, new Object[0]);
    }

    private static native boolean SetJAWTRootSurfaceLayer0(Buffer var0, long var1);

    private static native boolean UnsetJAWTRootSurfaceLayer0(Buffer var0, long var1);
}

